/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.request;

import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.search.filter.JobFilter;
import io.camunda.client.api.search.request.FinalSearchRequestStep;
import io.camunda.client.api.search.request.JobSearchRequest;
import io.camunda.client.api.search.request.SearchRequestBuilders;
import io.camunda.client.api.search.request.SearchRequestPage;
import io.camunda.client.api.search.response.Job;
import io.camunda.client.api.search.response.SearchResponse;
import io.camunda.client.api.search.sort.JobSort;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.request.SearchRequestSortMapper;
import io.camunda.client.impl.search.request.TypedSearchRequestPropertyProvider;
import io.camunda.client.impl.search.response.SearchResponseMapper;
import io.camunda.client.protocol.rest.JobSearchQuery;
import io.camunda.client.protocol.rest.JobSearchQueryResult;
import io.camunda.client.protocol.rest.SearchQueryPageRequest;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class JobSearchRequestImpl
extends TypedSearchRequestPropertyProvider<JobSearchQuery>
implements JobSearchRequest {
    private final JobSearchQuery request = new JobSearchQuery();
    private final JsonMapper jsonMapper;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public JobSearchRequestImpl(HttpClient httpClient, JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public FinalSearchRequestStep<Job> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public HttpCamundaFuture<SearchResponse<Job>> send() {
        HttpCamundaFuture<SearchResponse<Job>> result = new HttpCamundaFuture<SearchResponse<Job>>();
        this.httpClient.post("jobs/search", this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), JobSearchQueryResult.class, SearchResponseMapper::toJobSearchResponse, result);
        return result;
    }

    @Override
    public JobSearchRequest filter(JobFilter value) {
        this.request.setFilter((io.camunda.client.protocol.rest.JobFilter)JobSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public JobSearchRequest filter(Consumer<JobFilter> fn) {
        return this.filter(SearchRequestBuilders.jobFilter(fn));
    }

    @Override
    public JobSearchRequest sort(JobSort value) {
        this.request.setSort(SearchRequestSortMapper.toJobSearchQuerySortRequest((List)JobSearchRequestImpl.provideSearchRequestProperty(value)));
        return this;
    }

    @Override
    public JobSearchRequest sort(Consumer<JobSort> fn) {
        return this.sort(SearchRequestBuilders.jobSort(fn));
    }

    @Override
    public JobSearchRequest page(SearchRequestPage value) {
        this.request.setPage((SearchQueryPageRequest)JobSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public JobSearchRequest page(Consumer<SearchRequestPage> fn) {
        return this.page(SearchRequestBuilders.searchRequestPage(fn));
    }

    @Override
    protected JobSearchQuery getSearchRequestProperty() {
        return this.request;
    }
}

