/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.request;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.search.request.FinalSearchRequestStep;
import io.camunda.client.api.search.request.SearchRequestBuilders;
import io.camunda.client.api.search.request.SearchRequestPage;
import io.camunda.client.api.search.request.UserTaskVariableSearchRequest;
import io.camunda.client.api.search.response.SearchResponse;
import io.camunda.client.api.search.response.Variable;
import io.camunda.client.api.search.sort.VariableSort;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.request.SearchRequestSortMapper;
import io.camunda.client.impl.search.request.TypedSearchRequestPropertyProvider;
import io.camunda.client.impl.search.response.SearchResponseMapper;
import io.camunda.client.protocol.rest.SearchQueryPageRequest;
import io.camunda.client.protocol.rest.UserTaskVariableFilter;
import io.camunda.client.protocol.rest.UserTaskVariableSearchQueryRequest;
import io.camunda.client.protocol.rest.VariableSearchQueryResult;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class UserTaskVariableSearchRequestImpl
extends TypedSearchRequestPropertyProvider<UserTaskVariableSearchQueryRequest>
implements UserTaskVariableSearchRequest {
    private final UserTaskVariableSearchQueryRequest request;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final JsonMapper jsonMapper;
    private final long userTaskKey;
    private boolean withFullValues = false;

    public UserTaskVariableSearchRequestImpl(HttpClient httpClient, JsonMapper jsonMapper, long userTaskKey) {
        this.httpClient = httpClient;
        this.jsonMapper = jsonMapper;
        this.userTaskKey = userTaskKey;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.request = new UserTaskVariableSearchQueryRequest();
    }

    @Override
    public FinalSearchRequestStep<Variable> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<SearchResponse<Variable>> send() {
        HttpCamundaFuture<SearchResponse<Variable>> result = new HttpCamundaFuture<SearchResponse<Variable>>();
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (this.withFullValues) {
            queryParams.put("truncateValues", String.valueOf(false));
        }
        this.httpClient.post(String.format("/user-tasks/%d/variables/search", this.userTaskKey), queryParams, this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), VariableSearchQueryResult.class, SearchResponseMapper::toVariableSearchResponse, result);
        return result;
    }

    @Override
    public UserTaskVariableSearchRequest filter(io.camunda.client.api.search.filter.UserTaskVariableFilter value) {
        this.request.setFilter((UserTaskVariableFilter)UserTaskVariableSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public UserTaskVariableSearchRequest filter(Consumer<io.camunda.client.api.search.filter.UserTaskVariableFilter> fn) {
        return this.filter(SearchRequestBuilders.userTaskVariableFilter(fn));
    }

    @Override
    public UserTaskVariableSearchRequest sort(VariableSort value) {
        this.request.setSort(SearchRequestSortMapper.toUserTaskVariableSearchQuerySortRequest((List)UserTaskVariableSearchRequestImpl.provideSearchRequestProperty(value)));
        return this;
    }

    @Override
    public UserTaskVariableSearchRequest sort(Consumer<VariableSort> fn) {
        return this.sort(SearchRequestBuilders.variableSort(fn));
    }

    @Override
    public UserTaskVariableSearchRequest page(SearchRequestPage value) {
        this.request.setPage((SearchQueryPageRequest)UserTaskVariableSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public UserTaskVariableSearchRequest page(Consumer<SearchRequestPage> fn) {
        return this.page(SearchRequestBuilders.searchRequestPage(fn));
    }

    @Override
    public UserTaskVariableSearchRequest withFullValues() {
        this.withFullValues = true;
        return this;
    }

    @Override
    protected UserTaskVariableSearchQueryRequest getSearchRequestProperty() {
        return this.request;
    }
}

