/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.request;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.search.filter.VariableFilter;
import io.camunda.client.api.search.request.FinalSearchRequestStep;
import io.camunda.client.api.search.request.SearchRequestBuilders;
import io.camunda.client.api.search.request.SearchRequestPage;
import io.camunda.client.api.search.request.VariableSearchRequest;
import io.camunda.client.api.search.response.SearchResponse;
import io.camunda.client.api.search.response.Variable;
import io.camunda.client.api.search.sort.VariableSort;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.request.SearchRequestSortMapper;
import io.camunda.client.impl.search.request.TypedSearchRequestPropertyProvider;
import io.camunda.client.impl.search.response.SearchResponseMapper;
import io.camunda.client.protocol.rest.SearchQueryPageRequest;
import io.camunda.client.protocol.rest.VariableSearchQuery;
import io.camunda.client.protocol.rest.VariableSearchQueryResult;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class VariableSearchRequestImpl
extends TypedSearchRequestPropertyProvider<VariableSearchQuery>
implements VariableSearchRequest {
    private final VariableSearchQuery request = new VariableSearchQuery();
    private final JsonMapper jsonMapper;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private boolean withFullValues = false;

    public VariableSearchRequestImpl(HttpClient httpClient, JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public FinalSearchRequestStep<Variable> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<SearchResponse<Variable>> send() {
        HttpCamundaFuture<SearchResponse<Variable>> result = new HttpCamundaFuture<SearchResponse<Variable>>();
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (this.withFullValues) {
            queryParams.put("truncateValues", String.valueOf(false));
        }
        this.httpClient.post("/variables/search", queryParams, this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), VariableSearchQueryResult.class, SearchResponseMapper::toVariableSearchResponse, result);
        return result;
    }

    @Override
    public VariableSearchRequest filter(VariableFilter value) {
        this.request.setFilter((io.camunda.client.protocol.rest.VariableFilter)VariableSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public VariableSearchRequest filter(Consumer<VariableFilter> fn) {
        return this.filter(SearchRequestBuilders.variableFilter(fn));
    }

    @Override
    public VariableSearchRequest sort(VariableSort value) {
        this.request.setSort(SearchRequestSortMapper.toVariableSearchQuerySortRequest((List)VariableSearchRequestImpl.provideSearchRequestProperty(value)));
        return this;
    }

    @Override
    public VariableSearchRequest sort(Consumer<VariableSort> fn) {
        return this.sort(SearchRequestBuilders.variableSort(fn));
    }

    @Override
    public VariableSearchRequest page(SearchRequestPage value) {
        this.request.setPage((SearchQueryPageRequest)VariableSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public VariableSearchRequest page(Consumer<SearchRequestPage> fn) {
        return this.page(SearchRequestBuilders.searchRequestPage(fn));
    }

    @Override
    public VariableSearchRequest withFullValues() {
        this.withFullValues = true;
        return this;
    }

    @Override
    protected VariableSearchQuery getSearchRequestProperty() {
        return this.request;
    }
}

