/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.camunda.client.protocol.rest.TenantResult;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"username", "displayName", "email", "authorizedComponents", "tenants", "groups", "roles", "salesPlanType", "c8Links", "canLogout", "apiUser"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CamundaUserResult {
    public static final String JSON_PROPERTY_USERNAME = "username";
    @Nullable
    private String username;
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    @Nullable
    private String displayName;
    public static final String JSON_PROPERTY_EMAIL = "email";
    @Nullable
    private String email;
    public static final String JSON_PROPERTY_AUTHORIZED_COMPONENTS = "authorizedComponents";
    @Nullable
    private List<String> authorizedComponents = new ArrayList<String>();
    public static final String JSON_PROPERTY_TENANTS = "tenants";
    @Nullable
    private List<TenantResult> tenants = new ArrayList<TenantResult>();
    public static final String JSON_PROPERTY_GROUPS = "groups";
    @Nullable
    private List<String> groups = new ArrayList<String>();
    public static final String JSON_PROPERTY_ROLES = "roles";
    @Nullable
    private List<String> roles = new ArrayList<String>();
    public static final String JSON_PROPERTY_SALES_PLAN_TYPE = "salesPlanType";
    @Nullable
    private String salesPlanType;
    public static final String JSON_PROPERTY_C8_LINKS = "c8Links";
    @Nullable
    private Map<String, String> c8Links = new HashMap<String, String>();
    public static final String JSON_PROPERTY_CAN_LOGOUT = "canLogout";
    @Nullable
    private Boolean canLogout;
    public static final String JSON_PROPERTY_API_USER = "apiUser";
    @Nullable
    private Boolean apiUser;

    public CamundaUserResult username(@Nullable String username) {
        this.username = username;
        return this;
    }

    @Nullable
    @JsonProperty(value="username")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUsername() {
        return this.username;
    }

    @JsonProperty(value="username")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUsername(@Nullable String username) {
        this.username = username;
    }

    public CamundaUserResult displayName(@Nullable String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Nullable
    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayName(@Nullable String displayName) {
        this.displayName = displayName;
    }

    public CamundaUserResult email(@Nullable String email) {
        this.email = email;
        return this;
    }

    @Nullable
    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEmail(@Nullable String email) {
        this.email = email;
    }

    public CamundaUserResult authorizedComponents(@Nullable List<String> authorizedComponents) {
        this.authorizedComponents = authorizedComponents;
        return this;
    }

    public CamundaUserResult addAuthorizedComponentsItem(String authorizedComponentsItem) {
        if (this.authorizedComponents == null) {
            this.authorizedComponents = new ArrayList<String>();
        }
        this.authorizedComponents.add(authorizedComponentsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="authorizedComponents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getAuthorizedComponents() {
        return this.authorizedComponents;
    }

    @JsonProperty(value="authorizedComponents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthorizedComponents(@Nullable List<String> authorizedComponents) {
        this.authorizedComponents = authorizedComponents;
    }

    public CamundaUserResult tenants(@Nullable List<TenantResult> tenants) {
        this.tenants = tenants;
        return this;
    }

    public CamundaUserResult addTenantsItem(TenantResult tenantsItem) {
        if (this.tenants == null) {
            this.tenants = new ArrayList<TenantResult>();
        }
        this.tenants.add(tenantsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tenants")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TenantResult> getTenants() {
        return this.tenants;
    }

    @JsonProperty(value="tenants")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTenants(@Nullable List<TenantResult> tenants) {
        this.tenants = tenants;
    }

    public CamundaUserResult groups(@Nullable List<String> groups) {
        this.groups = groups;
        return this;
    }

    public CamundaUserResult addGroupsItem(String groupsItem) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        this.groups.add(groupsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="groups")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getGroups() {
        return this.groups;
    }

    @JsonProperty(value="groups")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGroups(@Nullable List<String> groups) {
        this.groups = groups;
    }

    public CamundaUserResult roles(@Nullable List<String> roles) {
        this.roles = roles;
        return this;
    }

    public CamundaUserResult addRolesItem(String rolesItem) {
        if (this.roles == null) {
            this.roles = new ArrayList<String>();
        }
        this.roles.add(rolesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="roles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getRoles() {
        return this.roles;
    }

    @JsonProperty(value="roles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoles(@Nullable List<String> roles) {
        this.roles = roles;
    }

    public CamundaUserResult salesPlanType(@Nullable String salesPlanType) {
        this.salesPlanType = salesPlanType;
        return this;
    }

    @Nullable
    @JsonProperty(value="salesPlanType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSalesPlanType() {
        return this.salesPlanType;
    }

    @JsonProperty(value="salesPlanType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSalesPlanType(@Nullable String salesPlanType) {
        this.salesPlanType = salesPlanType;
    }

    public CamundaUserResult c8Links(@Nullable Map<String, String> c8Links) {
        this.c8Links = c8Links;
        return this;
    }

    public CamundaUserResult putC8LinksItem(String key, String c8LinksItem) {
        if (this.c8Links == null) {
            this.c8Links = new HashMap<String, String>();
        }
        this.c8Links.put(key, c8LinksItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="c8Links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getC8Links() {
        return this.c8Links;
    }

    @JsonProperty(value="c8Links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setC8Links(@Nullable Map<String, String> c8Links) {
        this.c8Links = c8Links;
    }

    public CamundaUserResult canLogout(@Nullable Boolean canLogout) {
        this.canLogout = canLogout;
        return this;
    }

    @Nullable
    @JsonProperty(value="canLogout")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCanLogout() {
        return this.canLogout;
    }

    @JsonProperty(value="canLogout")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCanLogout(@Nullable Boolean canLogout) {
        this.canLogout = canLogout;
    }

    public CamundaUserResult apiUser(@Nullable Boolean apiUser) {
        this.apiUser = apiUser;
        return this;
    }

    @Nullable
    @JsonProperty(value="apiUser")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getApiUser() {
        return this.apiUser;
    }

    @JsonProperty(value="apiUser")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApiUser(@Nullable Boolean apiUser) {
        this.apiUser = apiUser;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CamundaUserResult camundaUserResult = (CamundaUserResult)o;
        return Objects.equals(this.username, camundaUserResult.username) && Objects.equals(this.displayName, camundaUserResult.displayName) && Objects.equals(this.email, camundaUserResult.email) && Objects.equals(this.authorizedComponents, camundaUserResult.authorizedComponents) && Objects.equals(this.tenants, camundaUserResult.tenants) && Objects.equals(this.groups, camundaUserResult.groups) && Objects.equals(this.roles, camundaUserResult.roles) && Objects.equals(this.salesPlanType, camundaUserResult.salesPlanType) && Objects.equals(this.c8Links, camundaUserResult.c8Links) && Objects.equals(this.canLogout, camundaUserResult.canLogout) && Objects.equals(this.apiUser, camundaUserResult.apiUser);
    }

    public int hashCode() {
        return Objects.hash(this.username, this.displayName, this.email, this.authorizedComponents, this.tenants, this.groups, this.roles, this.salesPlanType, this.c8Links, this.canLogout, this.apiUser);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CamundaUserResult {\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    authorizedComponents: ").append(this.toIndentedString(this.authorizedComponents)).append("\n");
        sb.append("    tenants: ").append(this.toIndentedString(this.tenants)).append("\n");
        sb.append("    groups: ").append(this.toIndentedString(this.groups)).append("\n");
        sb.append("    roles: ").append(this.toIndentedString(this.roles)).append("\n");
        sb.append("    salesPlanType: ").append(this.toIndentedString(this.salesPlanType)).append("\n");
        sb.append("    c8Links: ").append(this.toIndentedString(this.c8Links)).append("\n");
        sb.append("    canLogout: ").append(this.toIndentedString(this.canLogout)).append("\n");
        sb.append("    apiUser: ").append(this.toIndentedString(this.apiUser)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getUsername() != null) {
            try {
                joiner.add(String.format("%susername%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getUsername()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getDisplayName() != null) {
            try {
                joiner.add(String.format("%sdisplayName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDisplayName()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getEmail() != null) {
            try {
                joiner.add(String.format("%semail%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getEmail()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getAuthorizedComponents() != null) {
            for (i = 0; i < this.getAuthorizedComponents().size(); ++i) {
                try {
                    joiner.add(String.format("%sauthorizedComponents%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getAuthorizedComponents().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getTenants() != null) {
            for (i = 0; i < this.getTenants().size(); ++i) {
                if (this.getTenants().get(i) == null) continue;
                joiner.add(this.getTenants().get(i).toUrlQueryString(String.format("%stenants%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getGroups() != null) {
            for (i = 0; i < this.getGroups().size(); ++i) {
                try {
                    joiner.add(String.format("%sgroups%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getGroups().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getRoles() != null) {
            for (i = 0; i < this.getRoles().size(); ++i) {
                try {
                    joiner.add(String.format("%sroles%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getRoles().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getSalesPlanType() != null) {
            try {
                joiner.add(String.format("%ssalesPlanType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getSalesPlanType()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getC8Links() != null) {
            for (String _key : this.getC8Links().keySet()) {
                try {
                    joiner.add(String.format("%sc8Links%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getC8Links().get(_key), URLEncoder.encode(String.valueOf(this.getC8Links().get(_key)), "UTF-8").replaceAll("\\+", "%20")));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getCanLogout() != null) {
            try {
                joiner.add(String.format("%scanLogout%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getCanLogout()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getApiUser() != null) {
            try {
                joiner.add(String.format("%sapiUser%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getApiUser()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }
}

