/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.spring.annotation.processor;

import io.camunda.client.CamundaClient;
import io.camunda.client.annotation.AnnotationUtil;
import io.camunda.client.annotation.value.DeploymentValue;
import io.camunda.client.api.command.DeployResourceCommandStep1;
import io.camunda.client.api.response.DeploymentEvent;
import io.camunda.client.bean.BeanInfo;
import io.camunda.client.spring.annotation.processor.AbstractCamundaAnnotationProcessor;
import io.camunda.client.spring.event.CamundaPostDeploymentSpringEvent;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public class DeploymentAnnotationProcessor
extends AbstractCamundaAnnotationProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeploymentAnnotationProcessor.class);
    private static final ResourcePatternResolver RESOURCE_RESOLVER = new PathMatchingResourcePatternResolver();
    private final List<DeploymentValue> deploymentValues = new ArrayList<DeploymentValue>();
    private final ApplicationEventPublisher publisher;

    public DeploymentAnnotationProcessor(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    @Override
    public boolean isApplicableFor(BeanInfo beanInfo) {
        return AnnotationUtil.isDeployment(beanInfo);
    }

    @Override
    public void configureFor(BeanInfo beanInfo) {
        List<DeploymentValue> zeebeDeploymentValue = AnnotationUtil.getDeploymentValues(beanInfo);
        if (!zeebeDeploymentValue.isEmpty()) {
            LOGGER.info("Configuring deployments: {}", zeebeDeploymentValue);
            this.deploymentValues.addAll(zeebeDeploymentValue);
        }
    }

    @Override
    public void start(CamundaClient client) {
        if (this.deploymentValues.isEmpty()) {
            return;
        }
        List<DeploymentEvent> deploymentEvents = this.deploymentValues.stream().map(d -> this.deploy(client, (DeploymentValue)d)).toList();
        this.publisher.publishEvent((ApplicationEvent)new CamundaPostDeploymentSpringEvent(this, deploymentEvents));
    }

    @Override
    public void stop(CamundaClient client) {
    }

    private DeploymentEvent deploy(CamundaClient camundaClient, DeploymentValue deploymentValue) {
        String tenantId = deploymentValue.getTenantId();
        List resources = deploymentValue.getResources().stream().flatMap(r -> Arrays.stream(this.getResources((String)r))).distinct().toList();
        if (resources.isEmpty()) {
            throw new IllegalArgumentException("No resources found to deploy");
        }
        DeployResourceCommandStep1 command = camundaClient.newDeployResourceCommand();
        DeployResourceCommandStep1.DeployResourceCommandStep2 commandStep2 = null;
        for (Resource resource : resources) {
            try {
                InputStream inputStream = resource.getInputStream();
                try {
                    if (commandStep2 == null) {
                        commandStep2 = command.addResourceStream(inputStream, resource.getFilename());
                        continue;
                    }
                    commandStep2 = commandStep2.addResourceStream(inputStream, resource.getFilename());
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading resource: " + e.getMessage(), e);
            }
        }
        if (tenantId != null) {
            commandStep2.tenantId(tenantId);
        }
        DeploymentEvent deploymentEvent = (DeploymentEvent)commandStep2.execute();
        LOGGER.info("Deployed: {}", (Object)Stream.concat(deploymentEvent.getDecisionRequirements().stream().map(wf -> String.format("<%s:%d>", wf.getDmnDecisionRequirementsId(), wf.getVersion())), deploymentEvent.getProcesses().stream().map(wf -> String.format("<%s:%d>", wf.getBpmnProcessId(), wf.getVersion()))).collect(Collectors.joining(",")));
        return deploymentEvent;
    }

    public Resource[] getResources(String resources) {
        try {
            return RESOURCE_RESOLVER.getResources(resources);
        }
        catch (IOException e) {
            return new Resource[0];
        }
    }
}

