/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.common.auth.Authentication;
import io.camunda.common.auth.JwtCredential;
import io.camunda.common.auth.Product;
import io.camunda.common.auth.SaaSAuthentication;
import io.camunda.connector.api.json.ConnectorsObjectMapperSupplier;
import io.camunda.connector.api.secret.SecretProvider;
import io.camunda.connector.feel.FeelEngineWrapper;
import io.camunda.connector.runtime.ConnectorProperties;
import io.camunda.connector.runtime.core.secret.SecretProviderAggregator;
import io.camunda.connector.runtime.core.secret.SecretProviderDiscovery;
import io.camunda.connector.runtime.outbound.OutboundConnectorRuntimeConfiguration;
import io.camunda.connector.runtime.secret.ConsoleSecretApiClient;
import io.camunda.connector.runtime.secret.ConsoleSecretProvider;
import io.camunda.connector.runtime.secret.EnvironmentSecretProvider;
import java.time.Duration;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;

@AutoConfiguration
@AutoConfigureBefore(value={JacksonAutoConfiguration.class})
@Import(value={OutboundConnectorRuntimeConfiguration.class})
@EnableConfigurationProperties(value={ConnectorProperties.class})
public class OutboundConnectorsAutoConfiguration {
    @Value(value="${camunda.connector.secretprovider.discovery.enabled:true}")
    Boolean secretProviderLookupEnabled;
    @Value(value="${camunda.connector.secretprovider.environment.prefix:}")
    String environmentSecretProviderPrefix;
    @Value(value="${camunda.connector.secretprovider.console.endpoint:https://cluster-api.cloud.camunda.io/secrets}")
    String consoleSecretsApiEndpoint;
    @Value(value="${camunda.connector.secretprovider.console.audience:secrets.camunda.io}")
    String consoleSecretsApiAudience;
    private static final Logger LOG = LoggerFactory.getLogger(OutboundConnectorsAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(value={FeelEngineWrapper.class})
    public FeelEngineWrapper feelEngine() {
        return new FeelEngineWrapper();
    }

    @Bean
    @ConditionalOnMissingBean
    public SecretProviderAggregator springSecretProviderAggregator(Optional<List<SecretProvider>> secretProviderBeans) {
        List secretProviders = secretProviderBeans.orElseGet(LinkedList::new);
        LOG.debug("Using secret providers discovered as Spring beans: {}", secretProviderBeans);
        if (this.secretProviderLookupEnabled != Boolean.FALSE) {
            List discoveredSecretProviders = SecretProviderDiscovery.discoverSecretProviders();
            LOG.debug("Using secret providers discovered by lookup: {}", (Object)discoveredSecretProviders);
            secretProviders.addAll(discoveredSecretProviders);
        }
        return new SecretProviderAggregator(secretProviders);
    }

    @Bean
    @ConditionalOnProperty(name={"camunda.connector.secretprovider.environment.enabled"}, havingValue="true", matchIfMissing=true)
    public EnvironmentSecretProvider defaultSecretProvider(Environment environment) {
        return new EnvironmentSecretProvider(environment, this.environmentSecretProviderPrefix);
    }

    @Bean
    @ConditionalOnProperty(name={"camunda.connector.secretprovider.console.enabled"}, havingValue="true")
    public ConsoleSecretProvider consoleSecretProvider(ConsoleSecretApiClient consoleSecretApiClient) {
        return new ConsoleSecretProvider(consoleSecretApiClient, Duration.ofSeconds(20L));
    }

    @Bean
    @ConditionalOnProperty(name={"camunda.connector.secretprovider.console.enabled"}, havingValue="true")
    public ConsoleSecretApiClient consoleSecretApiClient(Authentication authentication) {
        if (authentication instanceof SaaSAuthentication) {
            SaaSAuthentication saaSAuthentication = (SaaSAuthentication)authentication;
            JwtCredential zeebeJwtCredential = saaSAuthentication.getJwtConfig().getProduct(Product.ZEEBE);
            JwtCredential jwtCredential = new JwtCredential(zeebeJwtCredential.getClientId(), zeebeJwtCredential.getClientSecret(), this.consoleSecretsApiAudience, zeebeJwtCredential.getAuthUrl());
            return new ConsoleSecretApiClient(this.consoleSecretsApiEndpoint, jwtCredential);
        }
        throw new RuntimeException("Console Secrets require an authentication against the SaaS environment:" + String.valueOf(authentication.getClass()));
    }

    @Bean
    @ConditionalOnMissingBean
    public ObjectMapper objectMapper() {
        return ConnectorsObjectMapperSupplier.getCopy();
    }
}

