/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.runtime;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.response.BrokerInfo;
import io.camunda.zeebe.client.api.response.PartitionBrokerHealth;
import io.camunda.zeebe.client.api.response.PartitionInfo;
import io.camunda.zeebe.client.api.response.Topology;
import java.util.Collection;
import java.util.Map;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;

public class ZeebeHealthIndicator
extends AbstractHealthIndicator {
    private final ZeebeClient zeebeClient;

    public ZeebeHealthIndicator(ZeebeClient zeebeClient) {
        this.zeebeClient = zeebeClient;
    }

    protected void doHealthCheck(Health.Builder builder) {
        Topology topology = (Topology)this.zeebeClient.newTopologyRequest().send().join();
        int numBrokers = topology.getBrokers().size();
        boolean anyPartitionHealthy = topology.getBrokers().stream().map(BrokerInfo::getPartitions).flatMap(Collection::stream).map(PartitionInfo::getHealth).anyMatch(health -> health == PartitionBrokerHealth.HEALTHY);
        Map<String, Boolean> details = Map.of("numBrokers", numBrokers, "anyPartitionHealthy", anyPartitionHealthy);
        if (numBrokers > 0 && anyPartitionHealthy) {
            builder.up().withDetails(details);
        } else {
            builder.down().withDetails(details);
        }
    }
}

