/*
 * Copyright Camunda Services GmbH and/or licensed to Camunda Services GmbH under
 * one or more contributor license agreements. Licensed under a proprietary license. See the
 * License.txt file for more information. You may not use this file except in compliance with the
 * proprietary license.
 */
package io.camunda.identity.sdk.authentication;

import java.net.URI;

public abstract class SingleSignOutUriBuilder {

  /**
   * Builds and returns the single sign out uri.
   * Will throw a {@link IllegalArgumentException} when called more than once on a single builder
   * instance.
   *
   * @return the uri
   */
  public abstract URI build();
}
