/*
 * Copyright Camunda Services GmbH and/or licensed to Camunda Services GmbH under
 * one or more contributor license agreements. Licensed under a proprietary license. See the
 * License.txt file for more information. You may not use this file except in compliance with the
 * proprietary license.
 */
package io.camunda.identity.sdk.impl;

import io.camunda.identity.sdk.authentication.SingleSignOutUriBuilder;
import java.net.URI;
import org.apache.commons.lang3.Validate;

public class GenericSingleSignOutBuilder extends SingleSignOutUriBuilder {
  protected final String singleSignOutEndpoint;

  public GenericSingleSignOutBuilder(
      final String singleSignOutEndpoint
  ) {
    Validate.notEmpty(singleSignOutEndpoint, "single sign out endpoint must not be null");
    this.singleSignOutEndpoint = singleSignOutEndpoint;
  }

  @Override
  public URI build() {
    return URI.create(
        String.format(
            "%s",
            this.singleSignOutEndpoint
        )
    );
  }

}
