/*
 * Copyright Camunda Services GmbH and/or licensed to Camunda Services GmbH under
 * one or more contributor license agreements. Licensed under a proprietary license. See the
 * License.txt file for more information. You may not use this file except in compliance with the
 * proprietary license.
 */
package io.camunda.identity.sdk.impl.auth0.authentication;

import com.auth0.client.auth.AuthAPI;
import com.auth0.client.auth.AuthorizeUrlBuilder;
import io.camunda.identity.sdk.IdentityConfiguration;
import io.camunda.identity.sdk.authentication.AuthorizeUriBuilder;
import java.net.URI;

class Auth0AuthorizeUriBuilder extends AuthorizeUriBuilder {
  private static final String DEFAULT_SCOPES = "openid email";
  private final AuthAPI authApi;
  private final IdentityConfiguration configuration;
  private final String redirectUri;

  Auth0AuthorizeUriBuilder(final IdentityConfiguration configuration,
                           final AuthAPI authApi,
                           final String redirectUri) {
    this.configuration = configuration;
    this.authApi = authApi;
    this.redirectUri = redirectUri;
  }

  @Override
  public URI build() {
    final AuthorizeUrlBuilder builder = authApi.authorizeUrl(redirectUri)
        .withScope(DEFAULT_SCOPES)
        .withAudience(configuration.getAudience())
        .withState(state);

    return URI.create(builder.build());
  }
}
