/*
 * Copyright Camunda Services GmbH and/or licensed to Camunda Services GmbH under
 * one or more contributor license agreements. Licensed under a proprietary license. See the
 * License.txt file for more information. You may not use this file except in compliance with the
 * proprietary license.
 */
package io.camunda.identity.sdk.impl.generic;

import io.camunda.identity.sdk.IdentityConfiguration;
import io.camunda.identity.sdk.authentication.AuthorizeUriBuilder;
import io.camunda.identity.sdk.utility.UrlQueryString;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;

public class GenericAuthorizeUriBuilder extends AuthorizeUriBuilder {

  protected final IdentityConfiguration configuration;

  private final String authorizeEndpoint;
  private final String redirectUri;

  public GenericAuthorizeUriBuilder(
      final IdentityConfiguration configuration,
      final String authorizeEndpoint,
      final String redirectUri
  ) {
    this.configuration = configuration;
    this.authorizeEndpoint = authorizeEndpoint;
    this.redirectUri = redirectUri;
  }

  @Override
  public URI build() {
    final UrlQueryString query = new UrlQueryString()
        .add("client_id", configuration.getClientId())
        .add("redirect_uri", redirectUri)
        .add("response_type", "code")
        .add("scope", buildScopes());

    if (state != null) {
      query.add("state", state);
    }

    if (configuration.getAudience() != null) {
      query.add("audience", configuration.getAudience());
    }

    return URI.create(
        String.format(
            "%s?%s",
            authorizeEndpoint, query.toString()
        )
    );
  }

  protected String buildScopes() {
    return StringUtils.isNotEmpty(configuration.getAuthScopes())
        ? configuration.getAuthScopes() : "openid email offline_access";
  }
}
