/*
 * Copyright Camunda Services GmbH and/or licensed to Camunda Services GmbH under
 * one or more contributor license agreements. Licensed under a proprietary license. See the
 * License.txt file for more information. You may not use this file except in compliance with the
 * proprietary license.
 */
package io.camunda.identity.sdk.impl.rest.request;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GroupRequest extends Request<List<String>> {
  public GroupRequest(
      final String path,
      final String authentication,
      final String organizationId
  ) {
    super(path,
        new TypeReference<>() {});
    final Map<String, String> params = buildParamMap(organizationId);
    this.setAuthentication(authentication);
    this.setParams(params);
  }

  private Map<String, String> buildParamMap(
      final String organizationId
  ) {
    final Map<String, String> params = new HashMap<>();

    if (organizationId != null) {
      params.put("organizationId", organizationId);
    }
    return params;
  }
}
