/*
 * Orchestration Cluster API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.zeebe.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.camunda.zeebe.client.protocol.rest.JobKindEnum;
import io.camunda.zeebe.client.protocol.rest.JobListenerEventTypeEnum;
import io.camunda.zeebe.client.protocol.rest.UserTaskProperties;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * ActivatedJobResult
 */
@JsonPropertyOrder({
  ActivatedJobResult.JSON_PROPERTY_TYPE,
  ActivatedJobResult.JSON_PROPERTY_PROCESS_DEFINITION_ID,
  ActivatedJobResult.JSON_PROPERTY_PROCESS_DEFINITION_VERSION,
  ActivatedJobResult.JSON_PROPERTY_ELEMENT_ID,
  ActivatedJobResult.JSON_PROPERTY_CUSTOM_HEADERS,
  ActivatedJobResult.JSON_PROPERTY_WORKER,
  ActivatedJobResult.JSON_PROPERTY_RETRIES,
  ActivatedJobResult.JSON_PROPERTY_DEADLINE,
  ActivatedJobResult.JSON_PROPERTY_VARIABLES,
  ActivatedJobResult.JSON_PROPERTY_TENANT_ID,
  ActivatedJobResult.JSON_PROPERTY_JOB_KEY,
  ActivatedJobResult.JSON_PROPERTY_PROCESS_INSTANCE_KEY,
  ActivatedJobResult.JSON_PROPERTY_PROCESS_DEFINITION_KEY,
  ActivatedJobResult.JSON_PROPERTY_ELEMENT_INSTANCE_KEY,
  ActivatedJobResult.JSON_PROPERTY_KIND,
  ActivatedJobResult.JSON_PROPERTY_LISTENER_EVENT_TYPE,
  ActivatedJobResult.JSON_PROPERTY_USER_TASK,
  ActivatedJobResult.JSON_PROPERTY_TAGS
})
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-12-11T14:21:53.463692534Z[GMT]", comments = "Generator version: 7.12.0")
public class ActivatedJobResult {
  public static final String JSON_PROPERTY_TYPE = "type";
  @javax.annotation.Nullable
  private String type;

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
  @javax.annotation.Nullable
  private String processDefinitionId;

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_VERSION = "processDefinitionVersion";
  @javax.annotation.Nullable
  private Integer processDefinitionVersion;

  public static final String JSON_PROPERTY_ELEMENT_ID = "elementId";
  @javax.annotation.Nullable
  private String elementId;

  public static final String JSON_PROPERTY_CUSTOM_HEADERS = "customHeaders";
  @javax.annotation.Nullable
  private Map<String, Object> customHeaders = new HashMap<>();

  public static final String JSON_PROPERTY_WORKER = "worker";
  @javax.annotation.Nullable
  private String worker;

  public static final String JSON_PROPERTY_RETRIES = "retries";
  @javax.annotation.Nullable
  private Integer retries;

  public static final String JSON_PROPERTY_DEADLINE = "deadline";
  @javax.annotation.Nullable
  private Long deadline;

  public static final String JSON_PROPERTY_VARIABLES = "variables";
  @javax.annotation.Nullable
  private Map<String, Object> variables = new HashMap<>();

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  @javax.annotation.Nullable
  private String tenantId;

  public static final String JSON_PROPERTY_JOB_KEY = "jobKey";
  @javax.annotation.Nullable
  private String jobKey;

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_KEY = "processInstanceKey";
  @javax.annotation.Nullable
  private String processInstanceKey;

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
  @javax.annotation.Nullable
  private String processDefinitionKey;

  public static final String JSON_PROPERTY_ELEMENT_INSTANCE_KEY = "elementInstanceKey";
  @javax.annotation.Nullable
  private String elementInstanceKey;

  public static final String JSON_PROPERTY_KIND = "kind";
  @javax.annotation.Nullable
  private JobKindEnum kind;

  public static final String JSON_PROPERTY_LISTENER_EVENT_TYPE = "listenerEventType";
  @javax.annotation.Nullable
  private JobListenerEventTypeEnum listenerEventType;

  public static final String JSON_PROPERTY_USER_TASK = "userTask";
  @javax.annotation.Nullable
  private UserTaskProperties userTask;

  public static final String JSON_PROPERTY_TAGS = "tags";
  @javax.annotation.Nullable
  private Set<String> tags = new LinkedHashSet<>();

  public ActivatedJobResult() {
  }

  public ActivatedJobResult type(@javax.annotation.Nullable String type) {
    
    this.type = type;
    return this;
  }

  /**
   * The type of the job (should match what was requested).
   * @return type
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(@javax.annotation.Nullable String type) {
    this.type = type;
  }

  public ActivatedJobResult processDefinitionId(@javax.annotation.Nullable String processDefinitionId) {
    
    this.processDefinitionId = processDefinitionId;
    return this;
  }

  /**
   * The bpmn process ID of the job&#39;s process definition.
   * @return processDefinitionId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProcessDefinitionId() {
    return processDefinitionId;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionId(@javax.annotation.Nullable String processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public ActivatedJobResult processDefinitionVersion(@javax.annotation.Nullable Integer processDefinitionVersion) {
    
    this.processDefinitionVersion = processDefinitionVersion;
    return this;
  }

  /**
   * The version of the job&#39;s process definition.
   * @return processDefinitionVersion
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getProcessDefinitionVersion() {
    return processDefinitionVersion;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionVersion(@javax.annotation.Nullable Integer processDefinitionVersion) {
    this.processDefinitionVersion = processDefinitionVersion;
  }

  public ActivatedJobResult elementId(@javax.annotation.Nullable String elementId) {
    
    this.elementId = elementId;
    return this;
  }

  /**
   * The associated task element ID.
   * @return elementId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ELEMENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getElementId() {
    return elementId;
  }


  @JsonProperty(JSON_PROPERTY_ELEMENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setElementId(@javax.annotation.Nullable String elementId) {
    this.elementId = elementId;
  }

  public ActivatedJobResult customHeaders(@javax.annotation.Nullable Map<String, Object> customHeaders) {
    
    this.customHeaders = customHeaders;
    return this;
  }

  public ActivatedJobResult putCustomHeadersItem(String key, Object customHeadersItem) {
    if (this.customHeaders == null) {
      this.customHeaders = new HashMap<>();
    }
    this.customHeaders.put(key, customHeadersItem);
    return this;
  }

  /**
   * A set of custom headers defined during modelling; returned as a serialized JSON document.
   * @return customHeaders
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CUSTOM_HEADERS)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Object> getCustomHeaders() {
    return customHeaders;
  }


  @JsonProperty(JSON_PROPERTY_CUSTOM_HEADERS)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)
  public void setCustomHeaders(@javax.annotation.Nullable Map<String, Object> customHeaders) {
    this.customHeaders = customHeaders;
  }

  public ActivatedJobResult worker(@javax.annotation.Nullable String worker) {
    
    this.worker = worker;
    return this;
  }

  /**
   * The name of the worker which activated this job.
   * @return worker
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_WORKER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getWorker() {
    return worker;
  }


  @JsonProperty(JSON_PROPERTY_WORKER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWorker(@javax.annotation.Nullable String worker) {
    this.worker = worker;
  }

  public ActivatedJobResult retries(@javax.annotation.Nullable Integer retries) {
    
    this.retries = retries;
    return this;
  }

  /**
   * The amount of retries left to this job (should always be positive).
   * @return retries
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RETRIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getRetries() {
    return retries;
  }


  @JsonProperty(JSON_PROPERTY_RETRIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRetries(@javax.annotation.Nullable Integer retries) {
    this.retries = retries;
  }

  public ActivatedJobResult deadline(@javax.annotation.Nullable Long deadline) {
    
    this.deadline = deadline;
    return this;
  }

  /**
   * When the job can be activated again, sent as a UNIX epoch timestamp.
   * @return deadline
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DEADLINE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getDeadline() {
    return deadline;
  }


  @JsonProperty(JSON_PROPERTY_DEADLINE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeadline(@javax.annotation.Nullable Long deadline) {
    this.deadline = deadline;
  }

  public ActivatedJobResult variables(@javax.annotation.Nullable Map<String, Object> variables) {
    
    this.variables = variables;
    return this;
  }

  public ActivatedJobResult putVariablesItem(String key, Object variablesItem) {
    if (this.variables == null) {
      this.variables = new HashMap<>();
    }
    this.variables.put(key, variablesItem);
    return this;
  }

  /**
   * All variables visible to the task scope, computed at activation time.
   * @return variables
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_VARIABLES)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Object> getVariables() {
    return variables;
  }


  @JsonProperty(JSON_PROPERTY_VARIABLES)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)
  public void setVariables(@javax.annotation.Nullable Map<String, Object> variables) {
    this.variables = variables;
  }

  public ActivatedJobResult tenantId(@javax.annotation.Nullable String tenantId) {
    
    this.tenantId = tenantId;
    return this;
  }

  /**
   * The ID of the tenant that owns the job.
   * @return tenantId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTenantId() {
    return tenantId;
  }


  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTenantId(@javax.annotation.Nullable String tenantId) {
    this.tenantId = tenantId;
  }

  public ActivatedJobResult jobKey(@javax.annotation.Nullable String jobKey) {
    
    this.jobKey = jobKey;
    return this;
  }

  /**
   * The key, a unique identifier for the job.
   * @return jobKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_JOB_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getJobKey() {
    return jobKey;
  }


  @JsonProperty(JSON_PROPERTY_JOB_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setJobKey(@javax.annotation.Nullable String jobKey) {
    this.jobKey = jobKey;
  }

  public ActivatedJobResult processInstanceKey(@javax.annotation.Nullable String processInstanceKey) {
    
    this.processInstanceKey = processInstanceKey;
    return this;
  }

  /**
   * The job&#39;s process instance key.
   * @return processInstanceKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProcessInstanceKey() {
    return processInstanceKey;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessInstanceKey(@javax.annotation.Nullable String processInstanceKey) {
    this.processInstanceKey = processInstanceKey;
  }

  public ActivatedJobResult processDefinitionKey(@javax.annotation.Nullable String processDefinitionKey) {
    
    this.processDefinitionKey = processDefinitionKey;
    return this;
  }

  /**
   * The key of the job&#39;s process definition.
   * @return processDefinitionKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProcessDefinitionKey() {
    return processDefinitionKey;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionKey(@javax.annotation.Nullable String processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  public ActivatedJobResult elementInstanceKey(@javax.annotation.Nullable String elementInstanceKey) {
    
    this.elementInstanceKey = elementInstanceKey;
    return this;
  }

  /**
   * The unique key identifying the associated task, unique within the scope of the process instance. 
   * @return elementInstanceKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ELEMENT_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getElementInstanceKey() {
    return elementInstanceKey;
  }


  @JsonProperty(JSON_PROPERTY_ELEMENT_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setElementInstanceKey(@javax.annotation.Nullable String elementInstanceKey) {
    this.elementInstanceKey = elementInstanceKey;
  }

  public ActivatedJobResult kind(@javax.annotation.Nullable JobKindEnum kind) {
    
    this.kind = kind;
    return this;
  }

  /**
   * Get kind
   * @return kind
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_KIND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JobKindEnum getKind() {
    return kind;
  }


  @JsonProperty(JSON_PROPERTY_KIND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setKind(@javax.annotation.Nullable JobKindEnum kind) {
    this.kind = kind;
  }

  public ActivatedJobResult listenerEventType(@javax.annotation.Nullable JobListenerEventTypeEnum listenerEventType) {
    
    this.listenerEventType = listenerEventType;
    return this;
  }

  /**
   * Get listenerEventType
   * @return listenerEventType
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LISTENER_EVENT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JobListenerEventTypeEnum getListenerEventType() {
    return listenerEventType;
  }


  @JsonProperty(JSON_PROPERTY_LISTENER_EVENT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setListenerEventType(@javax.annotation.Nullable JobListenerEventTypeEnum listenerEventType) {
    this.listenerEventType = listenerEventType;
  }

  public ActivatedJobResult userTask(@javax.annotation.Nullable UserTaskProperties userTask) {
    
    this.userTask = userTask;
    return this;
  }

  /**
   * Get userTask
   * @return userTask
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_USER_TASK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UserTaskProperties getUserTask() {
    return userTask;
  }


  @JsonProperty(JSON_PROPERTY_USER_TASK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserTask(@javax.annotation.Nullable UserTaskProperties userTask) {
    this.userTask = userTask;
  }

  public ActivatedJobResult tags(@javax.annotation.Nullable Set<String> tags) {
    
    this.tags = tags;
    return this;
  }

  public ActivatedJobResult addTagsItem(String tagsItem) {
    if (this.tags == null) {
      this.tags = new LinkedHashSet<>();
    }
    this.tags.add(tagsItem);
    return this;
  }

  /**
   * List of tags
   * @return tags
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Set<String> getTags() {
    return tags;
  }


  @JsonDeserialize(as = LinkedHashSet.class)
  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTags(@javax.annotation.Nullable Set<String> tags) {
    this.tags = tags;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ActivatedJobResult activatedJobResult = (ActivatedJobResult) o;
    return Objects.equals(this.type, activatedJobResult.type) &&
        Objects.equals(this.processDefinitionId, activatedJobResult.processDefinitionId) &&
        Objects.equals(this.processDefinitionVersion, activatedJobResult.processDefinitionVersion) &&
        Objects.equals(this.elementId, activatedJobResult.elementId) &&
        Objects.equals(this.customHeaders, activatedJobResult.customHeaders) &&
        Objects.equals(this.worker, activatedJobResult.worker) &&
        Objects.equals(this.retries, activatedJobResult.retries) &&
        Objects.equals(this.deadline, activatedJobResult.deadline) &&
        Objects.equals(this.variables, activatedJobResult.variables) &&
        Objects.equals(this.tenantId, activatedJobResult.tenantId) &&
        Objects.equals(this.jobKey, activatedJobResult.jobKey) &&
        Objects.equals(this.processInstanceKey, activatedJobResult.processInstanceKey) &&
        Objects.equals(this.processDefinitionKey, activatedJobResult.processDefinitionKey) &&
        Objects.equals(this.elementInstanceKey, activatedJobResult.elementInstanceKey) &&
        Objects.equals(this.kind, activatedJobResult.kind) &&
        Objects.equals(this.listenerEventType, activatedJobResult.listenerEventType) &&
        Objects.equals(this.userTask, activatedJobResult.userTask) &&
        Objects.equals(this.tags, activatedJobResult.tags);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, processDefinitionId, processDefinitionVersion, elementId, customHeaders, worker, retries, deadline, variables, tenantId, jobKey, processInstanceKey, processDefinitionKey, elementInstanceKey, kind, listenerEventType, userTask, tags);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ActivatedJobResult {\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    processDefinitionVersion: ").append(toIndentedString(processDefinitionVersion)).append("\n");
    sb.append("    elementId: ").append(toIndentedString(elementId)).append("\n");
    sb.append("    customHeaders: ").append(toIndentedString(customHeaders)).append("\n");
    sb.append("    worker: ").append(toIndentedString(worker)).append("\n");
    sb.append("    retries: ").append(toIndentedString(retries)).append("\n");
    sb.append("    deadline: ").append(toIndentedString(deadline)).append("\n");
    sb.append("    variables: ").append(toIndentedString(variables)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    jobKey: ").append(toIndentedString(jobKey)).append("\n");
    sb.append("    processInstanceKey: ").append(toIndentedString(processInstanceKey)).append("\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    elementInstanceKey: ").append(toIndentedString(elementInstanceKey)).append("\n");
    sb.append("    kind: ").append(toIndentedString(kind)).append("\n");
    sb.append("    listenerEventType: ").append(toIndentedString(listenerEventType)).append("\n");
    sb.append("    userTask: ").append(toIndentedString(userTask)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `type` to the URL query string
    if (getType() != null) {
      try {
        joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionId` to the URL query string
    if (getProcessDefinitionId() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionVersion` to the URL query string
    if (getProcessDefinitionVersion() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionVersion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionVersion()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `elementId` to the URL query string
    if (getElementId() != null) {
      try {
        joiner.add(String.format("%selementId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getElementId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `customHeaders` to the URL query string
    if (getCustomHeaders() != null) {
      for (String _key : getCustomHeaders().keySet()) {
        try {
          joiner.add(String.format("%scustomHeaders%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix),
              getCustomHeaders().get(_key), URLEncoder.encode(String.valueOf(getCustomHeaders().get(_key)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `worker` to the URL query string
    if (getWorker() != null) {
      try {
        joiner.add(String.format("%sworker%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getWorker()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `retries` to the URL query string
    if (getRetries() != null) {
      try {
        joiner.add(String.format("%sretries%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRetries()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `deadline` to the URL query string
    if (getDeadline() != null) {
      try {
        joiner.add(String.format("%sdeadline%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDeadline()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `variables` to the URL query string
    if (getVariables() != null) {
      for (String _key : getVariables().keySet()) {
        try {
          joiner.add(String.format("%svariables%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix),
              getVariables().get(_key), URLEncoder.encode(String.valueOf(getVariables().get(_key)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `tenantId` to the URL query string
    if (getTenantId() != null) {
      try {
        joiner.add(String.format("%stenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `jobKey` to the URL query string
    if (getJobKey() != null) {
      try {
        joiner.add(String.format("%sjobKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getJobKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processInstanceKey` to the URL query string
    if (getProcessInstanceKey() != null) {
      try {
        joiner.add(String.format("%sprocessInstanceKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessInstanceKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionKey` to the URL query string
    if (getProcessDefinitionKey() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `elementInstanceKey` to the URL query string
    if (getElementInstanceKey() != null) {
      try {
        joiner.add(String.format("%selementInstanceKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getElementInstanceKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `kind` to the URL query string
    if (getKind() != null) {
      try {
        joiner.add(String.format("%skind%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getKind()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `listenerEventType` to the URL query string
    if (getListenerEventType() != null) {
      try {
        joiner.add(String.format("%slistenerEventType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getListenerEventType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `userTask` to the URL query string
    if (getUserTask() != null) {
      joiner.add(getUserTask().toUrlQueryString(prefix + "userTask" + suffix));
    }

    // add `tags` to the URL query string
    if (getTags() != null) {
      int i = 0;
      for (String _item : getTags()) {
        try {
          joiner.add(String.format("%stags%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(_item), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
      i++;
    }

    return joiner.toString();
  }

}

