/*
 * Orchestration Cluster API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.zeebe.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.camunda.zeebe.client.protocol.rest.OwnerTypeEnum;
import io.camunda.zeebe.client.protocol.rest.PermissionTypeEnum;
import io.camunda.zeebe.client.protocol.rest.ResourceTypeEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * AuthorizationResult
 */
@JsonPropertyOrder({
  AuthorizationResult.JSON_PROPERTY_OWNER_ID,
  AuthorizationResult.JSON_PROPERTY_OWNER_TYPE,
  AuthorizationResult.JSON_PROPERTY_RESOURCE_TYPE,
  AuthorizationResult.JSON_PROPERTY_RESOURCE_ID,
  AuthorizationResult.JSON_PROPERTY_PERMISSION_TYPES,
  AuthorizationResult.JSON_PROPERTY_AUTHORIZATION_KEY
})
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-12-11T14:21:53.463692534Z[GMT]", comments = "Generator version: 7.12.0")
public class AuthorizationResult {
  public static final String JSON_PROPERTY_OWNER_ID = "ownerId";
  @javax.annotation.Nullable
  private String ownerId;

  public static final String JSON_PROPERTY_OWNER_TYPE = "ownerType";
  @javax.annotation.Nullable
  private OwnerTypeEnum ownerType;

  public static final String JSON_PROPERTY_RESOURCE_TYPE = "resourceType";
  @javax.annotation.Nullable
  private ResourceTypeEnum resourceType;

  public static final String JSON_PROPERTY_RESOURCE_ID = "resourceId";
  @javax.annotation.Nullable
  private String resourceId;

  public static final String JSON_PROPERTY_PERMISSION_TYPES = "permissionTypes";
  @javax.annotation.Nullable
  private List<PermissionTypeEnum> permissionTypes = new ArrayList<>();

  public static final String JSON_PROPERTY_AUTHORIZATION_KEY = "authorizationKey";
  @javax.annotation.Nullable
  private String authorizationKey;

  public AuthorizationResult() {
  }

  public AuthorizationResult ownerId(@javax.annotation.Nullable String ownerId) {
    
    this.ownerId = ownerId;
    return this;
  }

  /**
   * The ID of the owner of permissions.
   * @return ownerId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_OWNER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOwnerId() {
    return ownerId;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwnerId(@javax.annotation.Nullable String ownerId) {
    this.ownerId = ownerId;
  }

  public AuthorizationResult ownerType(@javax.annotation.Nullable OwnerTypeEnum ownerType) {
    
    this.ownerType = ownerType;
    return this;
  }

  /**
   * The type of the owner of permissions.
   * @return ownerType
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_OWNER_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OwnerTypeEnum getOwnerType() {
    return ownerType;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwnerType(@javax.annotation.Nullable OwnerTypeEnum ownerType) {
    this.ownerType = ownerType;
  }

  public AuthorizationResult resourceType(@javax.annotation.Nullable ResourceTypeEnum resourceType) {
    
    this.resourceType = resourceType;
    return this;
  }

  /**
   * The type of resource that owner have permissions.
   * @return resourceType
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RESOURCE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ResourceTypeEnum getResourceType() {
    return resourceType;
  }


  @JsonProperty(JSON_PROPERTY_RESOURCE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResourceType(@javax.annotation.Nullable ResourceTypeEnum resourceType) {
    this.resourceType = resourceType;
  }

  public AuthorizationResult resourceId(@javax.annotation.Nullable String resourceId) {
    
    this.resourceId = resourceId;
    return this;
  }

  /**
   * ID of the resource the permission relates to.
   * @return resourceId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RESOURCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getResourceId() {
    return resourceId;
  }


  @JsonProperty(JSON_PROPERTY_RESOURCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResourceId(@javax.annotation.Nullable String resourceId) {
    this.resourceId = resourceId;
  }

  public AuthorizationResult permissionTypes(@javax.annotation.Nullable List<PermissionTypeEnum> permissionTypes) {
    
    this.permissionTypes = permissionTypes;
    return this;
  }

  public AuthorizationResult addPermissionTypesItem(PermissionTypeEnum permissionTypesItem) {
    if (this.permissionTypes == null) {
      this.permissionTypes = new ArrayList<>();
    }
    this.permissionTypes.add(permissionTypesItem);
    return this;
  }

  /**
   * Specifies the types of the permissions.
   * @return permissionTypes
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PERMISSION_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<PermissionTypeEnum> getPermissionTypes() {
    return permissionTypes;
  }


  @JsonProperty(JSON_PROPERTY_PERMISSION_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPermissionTypes(@javax.annotation.Nullable List<PermissionTypeEnum> permissionTypes) {
    this.permissionTypes = permissionTypes;
  }

  public AuthorizationResult authorizationKey(@javax.annotation.Nullable String authorizationKey) {
    
    this.authorizationKey = authorizationKey;
    return this;
  }

  /**
   * The key of the authorization.
   * @return authorizationKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_AUTHORIZATION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAuthorizationKey() {
    return authorizationKey;
  }


  @JsonProperty(JSON_PROPERTY_AUTHORIZATION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAuthorizationKey(@javax.annotation.Nullable String authorizationKey) {
    this.authorizationKey = authorizationKey;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AuthorizationResult authorizationResult = (AuthorizationResult) o;
    return Objects.equals(this.ownerId, authorizationResult.ownerId) &&
        Objects.equals(this.ownerType, authorizationResult.ownerType) &&
        Objects.equals(this.resourceType, authorizationResult.resourceType) &&
        Objects.equals(this.resourceId, authorizationResult.resourceId) &&
        Objects.equals(this.permissionTypes, authorizationResult.permissionTypes) &&
        Objects.equals(this.authorizationKey, authorizationResult.authorizationKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(ownerId, ownerType, resourceType, resourceId, permissionTypes, authorizationKey);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AuthorizationResult {\n");
    sb.append("    ownerId: ").append(toIndentedString(ownerId)).append("\n");
    sb.append("    ownerType: ").append(toIndentedString(ownerType)).append("\n");
    sb.append("    resourceType: ").append(toIndentedString(resourceType)).append("\n");
    sb.append("    resourceId: ").append(toIndentedString(resourceId)).append("\n");
    sb.append("    permissionTypes: ").append(toIndentedString(permissionTypes)).append("\n");
    sb.append("    authorizationKey: ").append(toIndentedString(authorizationKey)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `ownerId` to the URL query string
    if (getOwnerId() != null) {
      try {
        joiner.add(String.format("%sownerId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getOwnerId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `ownerType` to the URL query string
    if (getOwnerType() != null) {
      try {
        joiner.add(String.format("%sownerType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getOwnerType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `resourceType` to the URL query string
    if (getResourceType() != null) {
      try {
        joiner.add(String.format("%sresourceType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getResourceType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `resourceId` to the URL query string
    if (getResourceId() != null) {
      try {
        joiner.add(String.format("%sresourceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getResourceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `permissionTypes` to the URL query string
    if (getPermissionTypes() != null) {
      for (int i = 0; i < getPermissionTypes().size(); i++) {
        if (getPermissionTypes().get(i) != null) {
          try {
            joiner.add(String.format("%spermissionTypes%s%s=%s", prefix, suffix,
                "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
                URLEncoder.encode(String.valueOf(getPermissionTypes().get(i)), "UTF-8").replaceAll("\\+", "%20")));
          } catch (UnsupportedEncodingException e) {
            // Should never happen, UTF-8 is always supported
            throw new RuntimeException(e);
          }
        }
      }
    }

    // add `authorizationKey` to the URL query string
    if (getAuthorizationKey() != null) {
      try {
        joiner.add(String.format("%sauthorizationKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAuthorizationKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

