/*
 * Orchestration Cluster API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.zeebe.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * A deployed decision.
 */
@JsonPropertyOrder({
  DeploymentDecisionResult.JSON_PROPERTY_DECISION_DEFINITION_ID,
  DeploymentDecisionResult.JSON_PROPERTY_VERSION,
  DeploymentDecisionResult.JSON_PROPERTY_NAME,
  DeploymentDecisionResult.JSON_PROPERTY_TENANT_ID,
  DeploymentDecisionResult.JSON_PROPERTY_DECISION_REQUIREMENTS_ID,
  DeploymentDecisionResult.JSON_PROPERTY_DECISION_DEFINITION_KEY,
  DeploymentDecisionResult.JSON_PROPERTY_DECISION_REQUIREMENTS_KEY
})
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-12-11T14:21:53.463692534Z[GMT]", comments = "Generator version: 7.12.0")
public class DeploymentDecisionResult {
  public static final String JSON_PROPERTY_DECISION_DEFINITION_ID = "decisionDefinitionId";
  @javax.annotation.Nullable
  private String decisionDefinitionId;

  public static final String JSON_PROPERTY_VERSION = "version";
  @javax.annotation.Nullable
  private Integer version;

  public static final String JSON_PROPERTY_NAME = "name";
  @javax.annotation.Nullable
  private String name;

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  @javax.annotation.Nullable
  private String tenantId;

  public static final String JSON_PROPERTY_DECISION_REQUIREMENTS_ID = "decisionRequirementsId";
  @javax.annotation.Nullable
  private String decisionRequirementsId;

  public static final String JSON_PROPERTY_DECISION_DEFINITION_KEY = "decisionDefinitionKey";
  @javax.annotation.Nullable
  private String decisionDefinitionKey;

  public static final String JSON_PROPERTY_DECISION_REQUIREMENTS_KEY = "decisionRequirementsKey";
  @javax.annotation.Nullable
  private String decisionRequirementsKey;

  public DeploymentDecisionResult() {
  }

  public DeploymentDecisionResult decisionDefinitionId(@javax.annotation.Nullable String decisionDefinitionId) {
    
    this.decisionDefinitionId = decisionDefinitionId;
    return this;
  }

  /**
   * The dmn decision ID, as parsed during deployment, together with the version forms a unique identifier for a specific decision. 
   * @return decisionDefinitionId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDecisionDefinitionId() {
    return decisionDefinitionId;
  }


  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDecisionDefinitionId(@javax.annotation.Nullable String decisionDefinitionId) {
    this.decisionDefinitionId = decisionDefinitionId;
  }

  public DeploymentDecisionResult version(@javax.annotation.Nullable Integer version) {
    
    this.version = version;
    return this;
  }

  /**
   * The assigned decision version.
   * @return version
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getVersion() {
    return version;
  }


  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVersion(@javax.annotation.Nullable Integer version) {
    this.version = version;
  }

  public DeploymentDecisionResult name(@javax.annotation.Nullable String name) {
    
    this.name = name;
    return this;
  }

  /**
   * The DMN name of the decision, as parsed during deployment.
   * @return name
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(@javax.annotation.Nullable String name) {
    this.name = name;
  }

  public DeploymentDecisionResult tenantId(@javax.annotation.Nullable String tenantId) {
    
    this.tenantId = tenantId;
    return this;
  }

  /**
   * The tenant ID of the deployed decision.
   * @return tenantId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTenantId() {
    return tenantId;
  }


  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTenantId(@javax.annotation.Nullable String tenantId) {
    this.tenantId = tenantId;
  }

  public DeploymentDecisionResult decisionRequirementsId(@javax.annotation.Nullable String decisionRequirementsId) {
    
    this.decisionRequirementsId = decisionRequirementsId;
    return this;
  }

  /**
   * The dmn ID of the decision requirements graph that this decision is part of, as parsed during deployment. 
   * @return decisionRequirementsId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DECISION_REQUIREMENTS_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDecisionRequirementsId() {
    return decisionRequirementsId;
  }


  @JsonProperty(JSON_PROPERTY_DECISION_REQUIREMENTS_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDecisionRequirementsId(@javax.annotation.Nullable String decisionRequirementsId) {
    this.decisionRequirementsId = decisionRequirementsId;
  }

  public DeploymentDecisionResult decisionDefinitionKey(@javax.annotation.Nullable String decisionDefinitionKey) {
    
    this.decisionDefinitionKey = decisionDefinitionKey;
    return this;
  }

  /**
   * The assigned decision key, which acts as a unique identifier for this decision. 
   * @return decisionDefinitionKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDecisionDefinitionKey() {
    return decisionDefinitionKey;
  }


  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDecisionDefinitionKey(@javax.annotation.Nullable String decisionDefinitionKey) {
    this.decisionDefinitionKey = decisionDefinitionKey;
  }

  public DeploymentDecisionResult decisionRequirementsKey(@javax.annotation.Nullable String decisionRequirementsKey) {
    
    this.decisionRequirementsKey = decisionRequirementsKey;
    return this;
  }

  /**
   * The assigned key of the decision requirements graph that this decision is part of. 
   * @return decisionRequirementsKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DECISION_REQUIREMENTS_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDecisionRequirementsKey() {
    return decisionRequirementsKey;
  }


  @JsonProperty(JSON_PROPERTY_DECISION_REQUIREMENTS_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDecisionRequirementsKey(@javax.annotation.Nullable String decisionRequirementsKey) {
    this.decisionRequirementsKey = decisionRequirementsKey;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DeploymentDecisionResult deploymentDecisionResult = (DeploymentDecisionResult) o;
    return Objects.equals(this.decisionDefinitionId, deploymentDecisionResult.decisionDefinitionId) &&
        Objects.equals(this.version, deploymentDecisionResult.version) &&
        Objects.equals(this.name, deploymentDecisionResult.name) &&
        Objects.equals(this.tenantId, deploymentDecisionResult.tenantId) &&
        Objects.equals(this.decisionRequirementsId, deploymentDecisionResult.decisionRequirementsId) &&
        Objects.equals(this.decisionDefinitionKey, deploymentDecisionResult.decisionDefinitionKey) &&
        Objects.equals(this.decisionRequirementsKey, deploymentDecisionResult.decisionRequirementsKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(decisionDefinitionId, version, name, tenantId, decisionRequirementsId, decisionDefinitionKey, decisionRequirementsKey);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DeploymentDecisionResult {\n");
    sb.append("    decisionDefinitionId: ").append(toIndentedString(decisionDefinitionId)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    decisionRequirementsId: ").append(toIndentedString(decisionRequirementsId)).append("\n");
    sb.append("    decisionDefinitionKey: ").append(toIndentedString(decisionDefinitionKey)).append("\n");
    sb.append("    decisionRequirementsKey: ").append(toIndentedString(decisionRequirementsKey)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `decisionDefinitionId` to the URL query string
    if (getDecisionDefinitionId() != null) {
      try {
        joiner.add(String.format("%sdecisionDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDecisionDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `version` to the URL query string
    if (getVersion() != null) {
      try {
        joiner.add(String.format("%sversion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getVersion()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `name` to the URL query string
    if (getName() != null) {
      try {
        joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tenantId` to the URL query string
    if (getTenantId() != null) {
      try {
        joiner.add(String.format("%stenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `decisionRequirementsId` to the URL query string
    if (getDecisionRequirementsId() != null) {
      try {
        joiner.add(String.format("%sdecisionRequirementsId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDecisionRequirementsId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `decisionDefinitionKey` to the URL query string
    if (getDecisionDefinitionKey() != null) {
      try {
        joiner.add(String.format("%sdecisionDefinitionKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDecisionDefinitionKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `decisionRequirementsKey` to the URL query string
    if (getDecisionRequirementsKey() != null) {
      try {
        joiner.add(String.format("%sdecisionRequirementsKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDecisionRequirementsKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

