/*
 * Orchestration Cluster API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.zeebe.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * JSON object with attributes that were corrected by the worker.  The following attributes can be corrected, additional attributes will be ignored:  * &#x60;assignee&#x60; - clear by providing an empty String * &#x60;dueDate&#x60; - clear by providing an empty String * &#x60;followUpDate&#x60; - clear by providing an empty String * &#x60;candidateGroups&#x60; - clear by providing an empty list * &#x60;candidateUsers&#x60; - clear by providing an empty list * &#x60;priority&#x60; - minimum 0, maximum 100, default 50  Providing any of those attributes with a &#x60;null&#x60; value or omitting it preserves the persisted attribute&#39;s value. 
 */
@JsonPropertyOrder({
  JobResultCorrections.JSON_PROPERTY_ASSIGNEE,
  JobResultCorrections.JSON_PROPERTY_DUE_DATE,
  JobResultCorrections.JSON_PROPERTY_FOLLOW_UP_DATE,
  JobResultCorrections.JSON_PROPERTY_CANDIDATE_USERS,
  JobResultCorrections.JSON_PROPERTY_CANDIDATE_GROUPS,
  JobResultCorrections.JSON_PROPERTY_PRIORITY
})
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-12-11T14:21:53.463692534Z[GMT]", comments = "Generator version: 7.12.0")
public class JobResultCorrections {
  public static final String JSON_PROPERTY_ASSIGNEE = "assignee";
  @javax.annotation.Nullable
  private String assignee;

  public static final String JSON_PROPERTY_DUE_DATE = "dueDate";
  @javax.annotation.Nullable
  private String dueDate;

  public static final String JSON_PROPERTY_FOLLOW_UP_DATE = "followUpDate";
  @javax.annotation.Nullable
  private String followUpDate;

  public static final String JSON_PROPERTY_CANDIDATE_USERS = "candidateUsers";
  @javax.annotation.Nullable
  private List<String> candidateUsers;

  public static final String JSON_PROPERTY_CANDIDATE_GROUPS = "candidateGroups";
  @javax.annotation.Nullable
  private List<String> candidateGroups;

  public static final String JSON_PROPERTY_PRIORITY = "priority";
  @javax.annotation.Nullable
  private Integer priority;

  public JobResultCorrections() {
  }

  public JobResultCorrections assignee(@javax.annotation.Nullable String assignee) {
    
    this.assignee = assignee;
    return this;
  }

  /**
   * Assignee of the task.
   * @return assignee
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ASSIGNEE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAssignee() {
    return assignee;
  }


  @JsonProperty(JSON_PROPERTY_ASSIGNEE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAssignee(@javax.annotation.Nullable String assignee) {
    this.assignee = assignee;
  }

  public JobResultCorrections dueDate(@javax.annotation.Nullable String dueDate) {
    
    this.dueDate = dueDate;
    return this;
  }

  /**
   * The due date of the task.
   * @return dueDate
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DUE_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDueDate() {
    return dueDate;
  }


  @JsonProperty(JSON_PROPERTY_DUE_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDueDate(@javax.annotation.Nullable String dueDate) {
    this.dueDate = dueDate;
  }

  public JobResultCorrections followUpDate(@javax.annotation.Nullable String followUpDate) {
    
    this.followUpDate = followUpDate;
    return this;
  }

  /**
   * The follow-up date of the task.
   * @return followUpDate
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FOLLOW_UP_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFollowUpDate() {
    return followUpDate;
  }


  @JsonProperty(JSON_PROPERTY_FOLLOW_UP_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFollowUpDate(@javax.annotation.Nullable String followUpDate) {
    this.followUpDate = followUpDate;
  }

  public JobResultCorrections candidateUsers(@javax.annotation.Nullable List<String> candidateUsers) {
    
    this.candidateUsers = candidateUsers;
    return this;
  }

  public JobResultCorrections addCandidateUsersItem(String candidateUsersItem) {
    if (this.candidateUsers == null) {
      this.candidateUsers = new ArrayList<>();
    }
    this.candidateUsers.add(candidateUsersItem);
    return this;
  }

  /**
   * The list of candidate users of the task.
   * @return candidateUsers
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CANDIDATE_USERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getCandidateUsers() {
    return candidateUsers;
  }


  @JsonProperty(JSON_PROPERTY_CANDIDATE_USERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCandidateUsers(@javax.annotation.Nullable List<String> candidateUsers) {
    this.candidateUsers = candidateUsers;
  }

  public JobResultCorrections candidateGroups(@javax.annotation.Nullable List<String> candidateGroups) {
    
    this.candidateGroups = candidateGroups;
    return this;
  }

  public JobResultCorrections addCandidateGroupsItem(String candidateGroupsItem) {
    if (this.candidateGroups == null) {
      this.candidateGroups = new ArrayList<>();
    }
    this.candidateGroups.add(candidateGroupsItem);
    return this;
  }

  /**
   * The list of candidate groups of the task.
   * @return candidateGroups
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CANDIDATE_GROUPS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getCandidateGroups() {
    return candidateGroups;
  }


  @JsonProperty(JSON_PROPERTY_CANDIDATE_GROUPS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCandidateGroups(@javax.annotation.Nullable List<String> candidateGroups) {
    this.candidateGroups = candidateGroups;
  }

  public JobResultCorrections priority(@javax.annotation.Nullable Integer priority) {
    
    this.priority = priority;
    return this;
  }

  /**
   * The priority of the task.
   * minimum: 0
   * maximum: 100
   * @return priority
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PRIORITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPriority() {
    return priority;
  }


  @JsonProperty(JSON_PROPERTY_PRIORITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPriority(@javax.annotation.Nullable Integer priority) {
    this.priority = priority;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    JobResultCorrections jobResultCorrections = (JobResultCorrections) o;
    return Objects.equals(this.assignee, jobResultCorrections.assignee) &&
        Objects.equals(this.dueDate, jobResultCorrections.dueDate) &&
        Objects.equals(this.followUpDate, jobResultCorrections.followUpDate) &&
        Objects.equals(this.candidateUsers, jobResultCorrections.candidateUsers) &&
        Objects.equals(this.candidateGroups, jobResultCorrections.candidateGroups) &&
        Objects.equals(this.priority, jobResultCorrections.priority);
  }

  @Override
  public int hashCode() {
    return Objects.hash(assignee, dueDate, followUpDate, candidateUsers, candidateGroups, priority);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class JobResultCorrections {\n");
    sb.append("    assignee: ").append(toIndentedString(assignee)).append("\n");
    sb.append("    dueDate: ").append(toIndentedString(dueDate)).append("\n");
    sb.append("    followUpDate: ").append(toIndentedString(followUpDate)).append("\n");
    sb.append("    candidateUsers: ").append(toIndentedString(candidateUsers)).append("\n");
    sb.append("    candidateGroups: ").append(toIndentedString(candidateGroups)).append("\n");
    sb.append("    priority: ").append(toIndentedString(priority)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `assignee` to the URL query string
    if (getAssignee() != null) {
      try {
        joiner.add(String.format("%sassignee%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAssignee()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `dueDate` to the URL query string
    if (getDueDate() != null) {
      try {
        joiner.add(String.format("%sdueDate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDueDate()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `followUpDate` to the URL query string
    if (getFollowUpDate() != null) {
      try {
        joiner.add(String.format("%sfollowUpDate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFollowUpDate()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `candidateUsers` to the URL query string
    if (getCandidateUsers() != null) {
      for (int i = 0; i < getCandidateUsers().size(); i++) {
        try {
          joiner.add(String.format("%scandidateUsers%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getCandidateUsers().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `candidateGroups` to the URL query string
    if (getCandidateGroups() != null) {
      for (int i = 0; i < getCandidateGroups().size(); i++) {
        try {
          joiner.add(String.format("%scandidateGroups%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getCandidateGroups().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `priority` to the URL query string
    if (getPriority() != null) {
      try {
        joiner.add(String.format("%spriority%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getPriority()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

