/*
 * Orchestration Cluster API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.zeebe.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.camunda.zeebe.client.protocol.rest.StringFilterProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * Process definition search filter.
 */
@JsonPropertyOrder({
  ProcessDefinitionFilter.JSON_PROPERTY_NAME,
  ProcessDefinitionFilter.JSON_PROPERTY_IS_LATEST_VERSION,
  ProcessDefinitionFilter.JSON_PROPERTY_RESOURCE_NAME,
  ProcessDefinitionFilter.JSON_PROPERTY_VERSION,
  ProcessDefinitionFilter.JSON_PROPERTY_VERSION_TAG,
  ProcessDefinitionFilter.JSON_PROPERTY_PROCESS_DEFINITION_ID,
  ProcessDefinitionFilter.JSON_PROPERTY_TENANT_ID,
  ProcessDefinitionFilter.JSON_PROPERTY_PROCESS_DEFINITION_KEY,
  ProcessDefinitionFilter.JSON_PROPERTY_HAS_START_FORM
})
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-12-11T14:21:53.463692534Z[GMT]", comments = "Generator version: 7.12.0")
public class ProcessDefinitionFilter {
  public static final String JSON_PROPERTY_NAME = "name";
  @javax.annotation.Nullable
  private StringFilterProperty name;

  public static final String JSON_PROPERTY_IS_LATEST_VERSION = "isLatestVersion";
  @javax.annotation.Nullable
  private Boolean isLatestVersion;

  public static final String JSON_PROPERTY_RESOURCE_NAME = "resourceName";
  @javax.annotation.Nullable
  private String resourceName;

  public static final String JSON_PROPERTY_VERSION = "version";
  @javax.annotation.Nullable
  private Integer version;

  public static final String JSON_PROPERTY_VERSION_TAG = "versionTag";
  @javax.annotation.Nullable
  private String versionTag;

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
  @javax.annotation.Nullable
  private StringFilterProperty processDefinitionId;

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  @javax.annotation.Nullable
  private String tenantId;

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
  @javax.annotation.Nullable
  private String processDefinitionKey;

  public static final String JSON_PROPERTY_HAS_START_FORM = "hasStartForm";
  @javax.annotation.Nullable
  private Boolean hasStartForm;

  public ProcessDefinitionFilter() {
  }

  public ProcessDefinitionFilter name(@javax.annotation.Nullable StringFilterProperty name) {
    
    this.name = name;
    return this;
  }

  /**
   * Name of this process definition.
   * @return name
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StringFilterProperty getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(@javax.annotation.Nullable StringFilterProperty name) {
    this.name = name;
  }

  public ProcessDefinitionFilter isLatestVersion(@javax.annotation.Nullable Boolean isLatestVersion) {
    
    this.isLatestVersion = isLatestVersion;
    return this;
  }

  /**
   * Whether to only return the latest version of each process definition. When using this filter, pagination functionality is limited, you can only paginate forward using &#x60;after&#x60; and &#x60;limit&#x60;. The response contains no &#x60;startCursor&#x60; in the &#x60;page&#x60;, and requests ignore the &#x60;from&#x60; and &#x60;before&#x60; in the &#x60;page&#x60;. 
   * @return isLatestVersion
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_IS_LATEST_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsLatestVersion() {
    return isLatestVersion;
  }


  @JsonProperty(JSON_PROPERTY_IS_LATEST_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsLatestVersion(@javax.annotation.Nullable Boolean isLatestVersion) {
    this.isLatestVersion = isLatestVersion;
  }

  public ProcessDefinitionFilter resourceName(@javax.annotation.Nullable String resourceName) {
    
    this.resourceName = resourceName;
    return this;
  }

  /**
   * Resource name of this process definition.
   * @return resourceName
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RESOURCE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getResourceName() {
    return resourceName;
  }


  @JsonProperty(JSON_PROPERTY_RESOURCE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResourceName(@javax.annotation.Nullable String resourceName) {
    this.resourceName = resourceName;
  }

  public ProcessDefinitionFilter version(@javax.annotation.Nullable Integer version) {
    
    this.version = version;
    return this;
  }

  /**
   * Version of this process definition.
   * @return version
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getVersion() {
    return version;
  }


  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVersion(@javax.annotation.Nullable Integer version) {
    this.version = version;
  }

  public ProcessDefinitionFilter versionTag(@javax.annotation.Nullable String versionTag) {
    
    this.versionTag = versionTag;
    return this;
  }

  /**
   * Version tag of this process definition.
   * @return versionTag
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_VERSION_TAG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getVersionTag() {
    return versionTag;
  }


  @JsonProperty(JSON_PROPERTY_VERSION_TAG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVersionTag(@javax.annotation.Nullable String versionTag) {
    this.versionTag = versionTag;
  }

  public ProcessDefinitionFilter processDefinitionId(@javax.annotation.Nullable StringFilterProperty processDefinitionId) {
    
    this.processDefinitionId = processDefinitionId;
    return this;
  }

  /**
   * Process definition ID of this process definition.
   * @return processDefinitionId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StringFilterProperty getProcessDefinitionId() {
    return processDefinitionId;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionId(@javax.annotation.Nullable StringFilterProperty processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public ProcessDefinitionFilter tenantId(@javax.annotation.Nullable String tenantId) {
    
    this.tenantId = tenantId;
    return this;
  }

  /**
   * Tenant ID of this process definition.
   * @return tenantId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTenantId() {
    return tenantId;
  }


  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTenantId(@javax.annotation.Nullable String tenantId) {
    this.tenantId = tenantId;
  }

  public ProcessDefinitionFilter processDefinitionKey(@javax.annotation.Nullable String processDefinitionKey) {
    
    this.processDefinitionKey = processDefinitionKey;
    return this;
  }

  /**
   * The key for this process definition.
   * @return processDefinitionKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProcessDefinitionKey() {
    return processDefinitionKey;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionKey(@javax.annotation.Nullable String processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  public ProcessDefinitionFilter hasStartForm(@javax.annotation.Nullable Boolean hasStartForm) {
    
    this.hasStartForm = hasStartForm;
    return this;
  }

  /**
   * Indicates whether the start event of the process has an associated Form Key.
   * @return hasStartForm
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_HAS_START_FORM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasStartForm() {
    return hasStartForm;
  }


  @JsonProperty(JSON_PROPERTY_HAS_START_FORM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasStartForm(@javax.annotation.Nullable Boolean hasStartForm) {
    this.hasStartForm = hasStartForm;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProcessDefinitionFilter processDefinitionFilter = (ProcessDefinitionFilter) o;
    return Objects.equals(this.name, processDefinitionFilter.name) &&
        Objects.equals(this.isLatestVersion, processDefinitionFilter.isLatestVersion) &&
        Objects.equals(this.resourceName, processDefinitionFilter.resourceName) &&
        Objects.equals(this.version, processDefinitionFilter.version) &&
        Objects.equals(this.versionTag, processDefinitionFilter.versionTag) &&
        Objects.equals(this.processDefinitionId, processDefinitionFilter.processDefinitionId) &&
        Objects.equals(this.tenantId, processDefinitionFilter.tenantId) &&
        Objects.equals(this.processDefinitionKey, processDefinitionFilter.processDefinitionKey) &&
        Objects.equals(this.hasStartForm, processDefinitionFilter.hasStartForm);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, isLatestVersion, resourceName, version, versionTag, processDefinitionId, tenantId, processDefinitionKey, hasStartForm);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ProcessDefinitionFilter {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    isLatestVersion: ").append(toIndentedString(isLatestVersion)).append("\n");
    sb.append("    resourceName: ").append(toIndentedString(resourceName)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    versionTag: ").append(toIndentedString(versionTag)).append("\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    hasStartForm: ").append(toIndentedString(hasStartForm)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `name` to the URL query string
    if (getName() != null) {
      joiner.add(getName().toUrlQueryString(prefix + "name" + suffix));
    }

    // add `isLatestVersion` to the URL query string
    if (getIsLatestVersion() != null) {
      try {
        joiner.add(String.format("%sisLatestVersion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getIsLatestVersion()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `resourceName` to the URL query string
    if (getResourceName() != null) {
      try {
        joiner.add(String.format("%sresourceName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getResourceName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `version` to the URL query string
    if (getVersion() != null) {
      try {
        joiner.add(String.format("%sversion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getVersion()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `versionTag` to the URL query string
    if (getVersionTag() != null) {
      try {
        joiner.add(String.format("%sversionTag%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getVersionTag()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionId` to the URL query string
    if (getProcessDefinitionId() != null) {
      joiner.add(getProcessDefinitionId().toUrlQueryString(prefix + "processDefinitionId" + suffix));
    }

    // add `tenantId` to the URL query string
    if (getTenantId() != null) {
      try {
        joiner.add(String.format("%stenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionKey` to the URL query string
    if (getProcessDefinitionKey() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `hasStartForm` to the URL query string
    if (getHasStartForm() != null) {
      try {
        joiner.add(String.format("%shasStartForm%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getHasStartForm()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

