/*
 * Orchestration Cluster API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.zeebe.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.camunda.zeebe.client.protocol.rest.BasicStringFilterProperty;
import io.camunda.zeebe.client.protocol.rest.DateTimeFilterProperty;
import io.camunda.zeebe.client.protocol.rest.ElementInstanceStateFilterProperty;
import io.camunda.zeebe.client.protocol.rest.IntegerFilterProperty;
import io.camunda.zeebe.client.protocol.rest.ProcessInstanceStateFilterProperty;
import io.camunda.zeebe.client.protocol.rest.StringFilterProperty;
import io.camunda.zeebe.client.protocol.rest.VariableValueFilterProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * Process instance search filter.
 */
@JsonPropertyOrder({
  ProcessInstanceFilterFields.JSON_PROPERTY_PROCESS_DEFINITION_ID,
  ProcessInstanceFilterFields.JSON_PROPERTY_PROCESS_DEFINITION_NAME,
  ProcessInstanceFilterFields.JSON_PROPERTY_PROCESS_DEFINITION_VERSION,
  ProcessInstanceFilterFields.JSON_PROPERTY_PROCESS_DEFINITION_VERSION_TAG,
  ProcessInstanceFilterFields.JSON_PROPERTY_PROCESS_DEFINITION_KEY,
  ProcessInstanceFilterFields.JSON_PROPERTY_TAGS,
  ProcessInstanceFilterFields.JSON_PROPERTY_START_DATE,
  ProcessInstanceFilterFields.JSON_PROPERTY_END_DATE,
  ProcessInstanceFilterFields.JSON_PROPERTY_STATE,
  ProcessInstanceFilterFields.JSON_PROPERTY_HAS_INCIDENT,
  ProcessInstanceFilterFields.JSON_PROPERTY_TENANT_ID,
  ProcessInstanceFilterFields.JSON_PROPERTY_VARIABLES,
  ProcessInstanceFilterFields.JSON_PROPERTY_PROCESS_INSTANCE_KEY,
  ProcessInstanceFilterFields.JSON_PROPERTY_PARENT_PROCESS_INSTANCE_KEY,
  ProcessInstanceFilterFields.JSON_PROPERTY_PARENT_ELEMENT_INSTANCE_KEY,
  ProcessInstanceFilterFields.JSON_PROPERTY_BATCH_OPERATION_ID,
  ProcessInstanceFilterFields.JSON_PROPERTY_ERROR_MESSAGE,
  ProcessInstanceFilterFields.JSON_PROPERTY_HAS_RETRIES_LEFT,
  ProcessInstanceFilterFields.JSON_PROPERTY_ELEMENT_INSTANCE_STATE,
  ProcessInstanceFilterFields.JSON_PROPERTY_ELEMENT_ID,
  ProcessInstanceFilterFields.JSON_PROPERTY_HAS_ELEMENT_INSTANCE_INCIDENT,
  ProcessInstanceFilterFields.JSON_PROPERTY_INCIDENT_ERROR_HASH_CODE
})
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-12-11T14:21:53.463692534Z[GMT]", comments = "Generator version: 7.12.0")
public class ProcessInstanceFilterFields {
  public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
  @javax.annotation.Nullable
  private StringFilterProperty processDefinitionId;

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_NAME = "processDefinitionName";
  @javax.annotation.Nullable
  private StringFilterProperty processDefinitionName;

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_VERSION = "processDefinitionVersion";
  @javax.annotation.Nullable
  private IntegerFilterProperty processDefinitionVersion;

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_VERSION_TAG = "processDefinitionVersionTag";
  @javax.annotation.Nullable
  private StringFilterProperty processDefinitionVersionTag;

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
  @javax.annotation.Nullable
  private BasicStringFilterProperty processDefinitionKey;

  public static final String JSON_PROPERTY_TAGS = "tags";
  @javax.annotation.Nullable
  private Set<String> tags = new LinkedHashSet<>();

  public static final String JSON_PROPERTY_START_DATE = "startDate";
  @javax.annotation.Nullable
  private DateTimeFilterProperty startDate;

  public static final String JSON_PROPERTY_END_DATE = "endDate";
  @javax.annotation.Nullable
  private DateTimeFilterProperty endDate;

  public static final String JSON_PROPERTY_STATE = "state";
  @javax.annotation.Nullable
  private ProcessInstanceStateFilterProperty state;

  public static final String JSON_PROPERTY_HAS_INCIDENT = "hasIncident";
  @javax.annotation.Nullable
  private Boolean hasIncident;

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  @javax.annotation.Nullable
  private StringFilterProperty tenantId;

  public static final String JSON_PROPERTY_VARIABLES = "variables";
  @javax.annotation.Nullable
  private List<VariableValueFilterProperty> variables = new ArrayList<>();

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_KEY = "processInstanceKey";
  @javax.annotation.Nullable
  private BasicStringFilterProperty processInstanceKey;

  public static final String JSON_PROPERTY_PARENT_PROCESS_INSTANCE_KEY = "parentProcessInstanceKey";
  @javax.annotation.Nullable
  private BasicStringFilterProperty parentProcessInstanceKey;

  public static final String JSON_PROPERTY_PARENT_ELEMENT_INSTANCE_KEY = "parentElementInstanceKey";
  @javax.annotation.Nullable
  private BasicStringFilterProperty parentElementInstanceKey;

  public static final String JSON_PROPERTY_BATCH_OPERATION_ID = "batchOperationId";
  @javax.annotation.Nullable
  private StringFilterProperty batchOperationId;

  public static final String JSON_PROPERTY_ERROR_MESSAGE = "errorMessage";
  @javax.annotation.Nullable
  private StringFilterProperty errorMessage;

  public static final String JSON_PROPERTY_HAS_RETRIES_LEFT = "hasRetriesLeft";
  @javax.annotation.Nullable
  private Boolean hasRetriesLeft;

  public static final String JSON_PROPERTY_ELEMENT_INSTANCE_STATE = "elementInstanceState";
  @javax.annotation.Nullable
  private ElementInstanceStateFilterProperty elementInstanceState;

  public static final String JSON_PROPERTY_ELEMENT_ID = "elementId";
  @javax.annotation.Nullable
  private StringFilterProperty elementId;

  public static final String JSON_PROPERTY_HAS_ELEMENT_INSTANCE_INCIDENT = "hasElementInstanceIncident";
  @javax.annotation.Nullable
  private Boolean hasElementInstanceIncident;

  public static final String JSON_PROPERTY_INCIDENT_ERROR_HASH_CODE = "incidentErrorHashCode";
  @javax.annotation.Nullable
  private IntegerFilterProperty incidentErrorHashCode;

  public ProcessInstanceFilterFields() {
  }

  public ProcessInstanceFilterFields processDefinitionId(@javax.annotation.Nullable StringFilterProperty processDefinitionId) {
    
    this.processDefinitionId = processDefinitionId;
    return this;
  }

  /**
   * The process definition ID.
   * @return processDefinitionId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StringFilterProperty getProcessDefinitionId() {
    return processDefinitionId;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionId(@javax.annotation.Nullable StringFilterProperty processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public ProcessInstanceFilterFields processDefinitionName(@javax.annotation.Nullable StringFilterProperty processDefinitionName) {
    
    this.processDefinitionName = processDefinitionName;
    return this;
  }

  /**
   * The process definition name.
   * @return processDefinitionName
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StringFilterProperty getProcessDefinitionName() {
    return processDefinitionName;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionName(@javax.annotation.Nullable StringFilterProperty processDefinitionName) {
    this.processDefinitionName = processDefinitionName;
  }

  public ProcessInstanceFilterFields processDefinitionVersion(@javax.annotation.Nullable IntegerFilterProperty processDefinitionVersion) {
    
    this.processDefinitionVersion = processDefinitionVersion;
    return this;
  }

  /**
   * The process definition version.
   * @return processDefinitionVersion
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public IntegerFilterProperty getProcessDefinitionVersion() {
    return processDefinitionVersion;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionVersion(@javax.annotation.Nullable IntegerFilterProperty processDefinitionVersion) {
    this.processDefinitionVersion = processDefinitionVersion;
  }

  public ProcessInstanceFilterFields processDefinitionVersionTag(@javax.annotation.Nullable StringFilterProperty processDefinitionVersionTag) {
    
    this.processDefinitionVersionTag = processDefinitionVersionTag;
    return this;
  }

  /**
   * The process definition version tag.
   * @return processDefinitionVersionTag
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_VERSION_TAG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StringFilterProperty getProcessDefinitionVersionTag() {
    return processDefinitionVersionTag;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_VERSION_TAG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionVersionTag(@javax.annotation.Nullable StringFilterProperty processDefinitionVersionTag) {
    this.processDefinitionVersionTag = processDefinitionVersionTag;
  }

  public ProcessInstanceFilterFields processDefinitionKey(@javax.annotation.Nullable BasicStringFilterProperty processDefinitionKey) {
    
    this.processDefinitionKey = processDefinitionKey;
    return this;
  }

  /**
   * The process definition key.
   * @return processDefinitionKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BasicStringFilterProperty getProcessDefinitionKey() {
    return processDefinitionKey;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionKey(@javax.annotation.Nullable BasicStringFilterProperty processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  public ProcessInstanceFilterFields tags(@javax.annotation.Nullable Set<String> tags) {
    
    this.tags = tags;
    return this;
  }

  public ProcessInstanceFilterFields addTagsItem(String tagsItem) {
    if (this.tags == null) {
      this.tags = new LinkedHashSet<>();
    }
    this.tags.add(tagsItem);
    return this;
  }

  /**
   * List of tags
   * @return tags
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Set<String> getTags() {
    return tags;
  }


  @JsonDeserialize(as = LinkedHashSet.class)
  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTags(@javax.annotation.Nullable Set<String> tags) {
    this.tags = tags;
  }

  public ProcessInstanceFilterFields startDate(@javax.annotation.Nullable DateTimeFilterProperty startDate) {
    
    this.startDate = startDate;
    return this;
  }

  /**
   * The start date.
   * @return startDate
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DateTimeFilterProperty getStartDate() {
    return startDate;
  }


  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStartDate(@javax.annotation.Nullable DateTimeFilterProperty startDate) {
    this.startDate = startDate;
  }

  public ProcessInstanceFilterFields endDate(@javax.annotation.Nullable DateTimeFilterProperty endDate) {
    
    this.endDate = endDate;
    return this;
  }

  /**
   * The end date.
   * @return endDate
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DateTimeFilterProperty getEndDate() {
    return endDate;
  }


  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEndDate(@javax.annotation.Nullable DateTimeFilterProperty endDate) {
    this.endDate = endDate;
  }

  public ProcessInstanceFilterFields state(@javax.annotation.Nullable ProcessInstanceStateFilterProperty state) {
    
    this.state = state;
    return this;
  }

  /**
   * The process instance state.
   * @return state
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ProcessInstanceStateFilterProperty getState() {
    return state;
  }


  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setState(@javax.annotation.Nullable ProcessInstanceStateFilterProperty state) {
    this.state = state;
  }

  public ProcessInstanceFilterFields hasIncident(@javax.annotation.Nullable Boolean hasIncident) {
    
    this.hasIncident = hasIncident;
    return this;
  }

  /**
   * Whether this process instance has a related incident or not.
   * @return hasIncident
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_HAS_INCIDENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasIncident() {
    return hasIncident;
  }


  @JsonProperty(JSON_PROPERTY_HAS_INCIDENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasIncident(@javax.annotation.Nullable Boolean hasIncident) {
    this.hasIncident = hasIncident;
  }

  public ProcessInstanceFilterFields tenantId(@javax.annotation.Nullable StringFilterProperty tenantId) {
    
    this.tenantId = tenantId;
    return this;
  }

  /**
   * The tenant ID.
   * @return tenantId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StringFilterProperty getTenantId() {
    return tenantId;
  }


  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTenantId(@javax.annotation.Nullable StringFilterProperty tenantId) {
    this.tenantId = tenantId;
  }

  public ProcessInstanceFilterFields variables(@javax.annotation.Nullable List<VariableValueFilterProperty> variables) {
    
    this.variables = variables;
    return this;
  }

  public ProcessInstanceFilterFields addVariablesItem(VariableValueFilterProperty variablesItem) {
    if (this.variables == null) {
      this.variables = new ArrayList<>();
    }
    this.variables.add(variablesItem);
    return this;
  }

  /**
   * The process instance variables.
   * @return variables
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_VARIABLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<VariableValueFilterProperty> getVariables() {
    return variables;
  }


  @JsonProperty(JSON_PROPERTY_VARIABLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVariables(@javax.annotation.Nullable List<VariableValueFilterProperty> variables) {
    this.variables = variables;
  }

  public ProcessInstanceFilterFields processInstanceKey(@javax.annotation.Nullable BasicStringFilterProperty processInstanceKey) {
    
    this.processInstanceKey = processInstanceKey;
    return this;
  }

  /**
   * The key of this process instance.
   * @return processInstanceKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BasicStringFilterProperty getProcessInstanceKey() {
    return processInstanceKey;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessInstanceKey(@javax.annotation.Nullable BasicStringFilterProperty processInstanceKey) {
    this.processInstanceKey = processInstanceKey;
  }

  public ProcessInstanceFilterFields parentProcessInstanceKey(@javax.annotation.Nullable BasicStringFilterProperty parentProcessInstanceKey) {
    
    this.parentProcessInstanceKey = parentProcessInstanceKey;
    return this;
  }

  /**
   * The parent process instance key.
   * @return parentProcessInstanceKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PARENT_PROCESS_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BasicStringFilterProperty getParentProcessInstanceKey() {
    return parentProcessInstanceKey;
  }


  @JsonProperty(JSON_PROPERTY_PARENT_PROCESS_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setParentProcessInstanceKey(@javax.annotation.Nullable BasicStringFilterProperty parentProcessInstanceKey) {
    this.parentProcessInstanceKey = parentProcessInstanceKey;
  }

  public ProcessInstanceFilterFields parentElementInstanceKey(@javax.annotation.Nullable BasicStringFilterProperty parentElementInstanceKey) {
    
    this.parentElementInstanceKey = parentElementInstanceKey;
    return this;
  }

  /**
   * The parent element instance key.
   * @return parentElementInstanceKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PARENT_ELEMENT_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BasicStringFilterProperty getParentElementInstanceKey() {
    return parentElementInstanceKey;
  }


  @JsonProperty(JSON_PROPERTY_PARENT_ELEMENT_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setParentElementInstanceKey(@javax.annotation.Nullable BasicStringFilterProperty parentElementInstanceKey) {
    this.parentElementInstanceKey = parentElementInstanceKey;
  }

  public ProcessInstanceFilterFields batchOperationId(@javax.annotation.Nullable StringFilterProperty batchOperationId) {
    
    this.batchOperationId = batchOperationId;
    return this;
  }

  /**
   * The batch operation ID.
   * @return batchOperationId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BATCH_OPERATION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StringFilterProperty getBatchOperationId() {
    return batchOperationId;
  }


  @JsonProperty(JSON_PROPERTY_BATCH_OPERATION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBatchOperationId(@javax.annotation.Nullable StringFilterProperty batchOperationId) {
    this.batchOperationId = batchOperationId;
  }

  public ProcessInstanceFilterFields errorMessage(@javax.annotation.Nullable StringFilterProperty errorMessage) {
    
    this.errorMessage = errorMessage;
    return this;
  }

  /**
   * The error message related to the process.
   * @return errorMessage
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ERROR_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StringFilterProperty getErrorMessage() {
    return errorMessage;
  }


  @JsonProperty(JSON_PROPERTY_ERROR_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setErrorMessage(@javax.annotation.Nullable StringFilterProperty errorMessage) {
    this.errorMessage = errorMessage;
  }

  public ProcessInstanceFilterFields hasRetriesLeft(@javax.annotation.Nullable Boolean hasRetriesLeft) {
    
    this.hasRetriesLeft = hasRetriesLeft;
    return this;
  }

  /**
   * Whether the process has failed jobs with retries left.
   * @return hasRetriesLeft
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_HAS_RETRIES_LEFT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasRetriesLeft() {
    return hasRetriesLeft;
  }


  @JsonProperty(JSON_PROPERTY_HAS_RETRIES_LEFT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasRetriesLeft(@javax.annotation.Nullable Boolean hasRetriesLeft) {
    this.hasRetriesLeft = hasRetriesLeft;
  }

  public ProcessInstanceFilterFields elementInstanceState(@javax.annotation.Nullable ElementInstanceStateFilterProperty elementInstanceState) {
    
    this.elementInstanceState = elementInstanceState;
    return this;
  }

  /**
   * The state of the element instances associated with the process instance.
   * @return elementInstanceState
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ELEMENT_INSTANCE_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ElementInstanceStateFilterProperty getElementInstanceState() {
    return elementInstanceState;
  }


  @JsonProperty(JSON_PROPERTY_ELEMENT_INSTANCE_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setElementInstanceState(@javax.annotation.Nullable ElementInstanceStateFilterProperty elementInstanceState) {
    this.elementInstanceState = elementInstanceState;
  }

  public ProcessInstanceFilterFields elementId(@javax.annotation.Nullable StringFilterProperty elementId) {
    
    this.elementId = elementId;
    return this;
  }

  /**
   * The element ID associated with the process instance.
   * @return elementId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ELEMENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StringFilterProperty getElementId() {
    return elementId;
  }


  @JsonProperty(JSON_PROPERTY_ELEMENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setElementId(@javax.annotation.Nullable StringFilterProperty elementId) {
    this.elementId = elementId;
  }

  public ProcessInstanceFilterFields hasElementInstanceIncident(@javax.annotation.Nullable Boolean hasElementInstanceIncident) {
    
    this.hasElementInstanceIncident = hasElementInstanceIncident;
    return this;
  }

  /**
   * Whether the element instance has an incident or not.
   * @return hasElementInstanceIncident
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_HAS_ELEMENT_INSTANCE_INCIDENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasElementInstanceIncident() {
    return hasElementInstanceIncident;
  }


  @JsonProperty(JSON_PROPERTY_HAS_ELEMENT_INSTANCE_INCIDENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasElementInstanceIncident(@javax.annotation.Nullable Boolean hasElementInstanceIncident) {
    this.hasElementInstanceIncident = hasElementInstanceIncident;
  }

  public ProcessInstanceFilterFields incidentErrorHashCode(@javax.annotation.Nullable IntegerFilterProperty incidentErrorHashCode) {
    
    this.incidentErrorHashCode = incidentErrorHashCode;
    return this;
  }

  /**
   * The incident error hash code, associated with this process.
   * @return incidentErrorHashCode
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_INCIDENT_ERROR_HASH_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public IntegerFilterProperty getIncidentErrorHashCode() {
    return incidentErrorHashCode;
  }


  @JsonProperty(JSON_PROPERTY_INCIDENT_ERROR_HASH_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncidentErrorHashCode(@javax.annotation.Nullable IntegerFilterProperty incidentErrorHashCode) {
    this.incidentErrorHashCode = incidentErrorHashCode;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProcessInstanceFilterFields processInstanceFilterFields = (ProcessInstanceFilterFields) o;
    return Objects.equals(this.processDefinitionId, processInstanceFilterFields.processDefinitionId) &&
        Objects.equals(this.processDefinitionName, processInstanceFilterFields.processDefinitionName) &&
        Objects.equals(this.processDefinitionVersion, processInstanceFilterFields.processDefinitionVersion) &&
        Objects.equals(this.processDefinitionVersionTag, processInstanceFilterFields.processDefinitionVersionTag) &&
        Objects.equals(this.processDefinitionKey, processInstanceFilterFields.processDefinitionKey) &&
        Objects.equals(this.tags, processInstanceFilterFields.tags) &&
        Objects.equals(this.startDate, processInstanceFilterFields.startDate) &&
        Objects.equals(this.endDate, processInstanceFilterFields.endDate) &&
        Objects.equals(this.state, processInstanceFilterFields.state) &&
        Objects.equals(this.hasIncident, processInstanceFilterFields.hasIncident) &&
        Objects.equals(this.tenantId, processInstanceFilterFields.tenantId) &&
        Objects.equals(this.variables, processInstanceFilterFields.variables) &&
        Objects.equals(this.processInstanceKey, processInstanceFilterFields.processInstanceKey) &&
        Objects.equals(this.parentProcessInstanceKey, processInstanceFilterFields.parentProcessInstanceKey) &&
        Objects.equals(this.parentElementInstanceKey, processInstanceFilterFields.parentElementInstanceKey) &&
        Objects.equals(this.batchOperationId, processInstanceFilterFields.batchOperationId) &&
        Objects.equals(this.errorMessage, processInstanceFilterFields.errorMessage) &&
        Objects.equals(this.hasRetriesLeft, processInstanceFilterFields.hasRetriesLeft) &&
        Objects.equals(this.elementInstanceState, processInstanceFilterFields.elementInstanceState) &&
        Objects.equals(this.elementId, processInstanceFilterFields.elementId) &&
        Objects.equals(this.hasElementInstanceIncident, processInstanceFilterFields.hasElementInstanceIncident) &&
        Objects.equals(this.incidentErrorHashCode, processInstanceFilterFields.incidentErrorHashCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(processDefinitionId, processDefinitionName, processDefinitionVersion, processDefinitionVersionTag, processDefinitionKey, tags, startDate, endDate, state, hasIncident, tenantId, variables, processInstanceKey, parentProcessInstanceKey, parentElementInstanceKey, batchOperationId, errorMessage, hasRetriesLeft, elementInstanceState, elementId, hasElementInstanceIncident, incidentErrorHashCode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ProcessInstanceFilterFields {\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    processDefinitionName: ").append(toIndentedString(processDefinitionName)).append("\n");
    sb.append("    processDefinitionVersion: ").append(toIndentedString(processDefinitionVersion)).append("\n");
    sb.append("    processDefinitionVersionTag: ").append(toIndentedString(processDefinitionVersionTag)).append("\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    hasIncident: ").append(toIndentedString(hasIncident)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    variables: ").append(toIndentedString(variables)).append("\n");
    sb.append("    processInstanceKey: ").append(toIndentedString(processInstanceKey)).append("\n");
    sb.append("    parentProcessInstanceKey: ").append(toIndentedString(parentProcessInstanceKey)).append("\n");
    sb.append("    parentElementInstanceKey: ").append(toIndentedString(parentElementInstanceKey)).append("\n");
    sb.append("    batchOperationId: ").append(toIndentedString(batchOperationId)).append("\n");
    sb.append("    errorMessage: ").append(toIndentedString(errorMessage)).append("\n");
    sb.append("    hasRetriesLeft: ").append(toIndentedString(hasRetriesLeft)).append("\n");
    sb.append("    elementInstanceState: ").append(toIndentedString(elementInstanceState)).append("\n");
    sb.append("    elementId: ").append(toIndentedString(elementId)).append("\n");
    sb.append("    hasElementInstanceIncident: ").append(toIndentedString(hasElementInstanceIncident)).append("\n");
    sb.append("    incidentErrorHashCode: ").append(toIndentedString(incidentErrorHashCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `startDate` to the URL query string
    if (getStartDate() != null) {
      joiner.add(getStartDate().toUrlQueryString(prefix + "startDate" + suffix));
    }

    // add `endDate` to the URL query string
    if (getEndDate() != null) {
      joiner.add(getEndDate().toUrlQueryString(prefix + "endDate" + suffix));
    }

    // add `state` to the URL query string
    if (getState() != null) {
      joiner.add(getState().toUrlQueryString(prefix + "state" + suffix));
    }

    // add `hasIncident` to the URL query string
    if (getHasIncident() != null) {
      try {
        joiner.add(String.format("%shasIncident%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getHasIncident()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tenantId` to the URL query string
    if (getTenantId() != null) {
      joiner.add(getTenantId().toUrlQueryString(prefix + "tenantId" + suffix));
    }

    // add `variables` to the URL query string
    if (getVariables() != null) {
      for (int i = 0; i < getVariables().size(); i++) {
        if (getVariables().get(i) != null) {
          joiner.add(getVariables().get(i).toUrlQueryString(String.format("%svariables%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `processInstanceKey` to the URL query string
    if (getProcessInstanceKey() != null) {
      joiner.add(getProcessInstanceKey().toUrlQueryString(prefix + "processInstanceKey" + suffix));
    }

    // add `parentProcessInstanceKey` to the URL query string
    if (getParentProcessInstanceKey() != null) {
      joiner.add(getParentProcessInstanceKey().toUrlQueryString(prefix + "parentProcessInstanceKey" + suffix));
    }

    // add `parentElementInstanceKey` to the URL query string
    if (getParentElementInstanceKey() != null) {
      joiner.add(getParentElementInstanceKey().toUrlQueryString(prefix + "parentElementInstanceKey" + suffix));
    }

    // add `batchOperationId` to the URL query string
    if (getBatchOperationId() != null) {
      joiner.add(getBatchOperationId().toUrlQueryString(prefix + "batchOperationId" + suffix));
    }

    // add `errorMessage` to the URL query string
    if (getErrorMessage() != null) {
      joiner.add(getErrorMessage().toUrlQueryString(prefix + "errorMessage" + suffix));
    }

    // add `hasRetriesLeft` to the URL query string
    if (getHasRetriesLeft() != null) {
      try {
        joiner.add(String.format("%shasRetriesLeft%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getHasRetriesLeft()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `elementInstanceState` to the URL query string
    if (getElementInstanceState() != null) {
      joiner.add(getElementInstanceState().toUrlQueryString(prefix + "elementInstanceState" + suffix));
    }

    // add `elementId` to the URL query string
    if (getElementId() != null) {
      joiner.add(getElementId().toUrlQueryString(prefix + "elementId" + suffix));
    }

    // add `hasElementInstanceIncident` to the URL query string
    if (getHasElementInstanceIncident() != null) {
      try {
        joiner.add(String.format("%shasElementInstanceIncident%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getHasElementInstanceIncident()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `incidentErrorHashCode` to the URL query string
    if (getIncidentErrorHashCode() != null) {
      joiner.add(getIncidentErrorHashCode().toUrlQueryString(prefix + "incidentErrorHashCode" + suffix));
    }

    return joiner.toString();
  }

}

