/*
 * Orchestration Cluster API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.zeebe.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.camunda.zeebe.client.protocol.rest.ProcessInstanceStateEnum;
import java.time.OffsetDateTime;
import java.util.LinkedHashSet;
import java.util.Set;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * Process instance search response item.
 */
@JsonPropertyOrder({
  ProcessInstanceResult.JSON_PROPERTY_PROCESS_DEFINITION_ID,
  ProcessInstanceResult.JSON_PROPERTY_PROCESS_DEFINITION_NAME,
  ProcessInstanceResult.JSON_PROPERTY_PROCESS_DEFINITION_VERSION,
  ProcessInstanceResult.JSON_PROPERTY_PROCESS_DEFINITION_VERSION_TAG,
  ProcessInstanceResult.JSON_PROPERTY_START_DATE,
  ProcessInstanceResult.JSON_PROPERTY_END_DATE,
  ProcessInstanceResult.JSON_PROPERTY_STATE,
  ProcessInstanceResult.JSON_PROPERTY_HAS_INCIDENT,
  ProcessInstanceResult.JSON_PROPERTY_TENANT_ID,
  ProcessInstanceResult.JSON_PROPERTY_PROCESS_INSTANCE_KEY,
  ProcessInstanceResult.JSON_PROPERTY_PROCESS_DEFINITION_KEY,
  ProcessInstanceResult.JSON_PROPERTY_PARENT_PROCESS_INSTANCE_KEY,
  ProcessInstanceResult.JSON_PROPERTY_PARENT_ELEMENT_INSTANCE_KEY,
  ProcessInstanceResult.JSON_PROPERTY_TAGS
})
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-12-11T14:21:53.463692534Z[GMT]", comments = "Generator version: 7.12.0")
public class ProcessInstanceResult {
  public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
  @javax.annotation.Nullable
  private String processDefinitionId;

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_NAME = "processDefinitionName";
  @javax.annotation.Nullable
  private String processDefinitionName;

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_VERSION = "processDefinitionVersion";
  @javax.annotation.Nullable
  private Integer processDefinitionVersion;

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_VERSION_TAG = "processDefinitionVersionTag";
  @javax.annotation.Nullable
  private String processDefinitionVersionTag;

  public static final String JSON_PROPERTY_START_DATE = "startDate";
  @javax.annotation.Nullable
  private String startDate;

  public static final String JSON_PROPERTY_END_DATE = "endDate";
  @javax.annotation.Nullable
  private String endDate;

  public static final String JSON_PROPERTY_STATE = "state";
  @javax.annotation.Nullable
  private ProcessInstanceStateEnum state;

  public static final String JSON_PROPERTY_HAS_INCIDENT = "hasIncident";
  @javax.annotation.Nullable
  private Boolean hasIncident;

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  @javax.annotation.Nullable
  private String tenantId;

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_KEY = "processInstanceKey";
  @javax.annotation.Nullable
  private String processInstanceKey;

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
  @javax.annotation.Nullable
  private String processDefinitionKey;

  public static final String JSON_PROPERTY_PARENT_PROCESS_INSTANCE_KEY = "parentProcessInstanceKey";
  @javax.annotation.Nullable
  private String parentProcessInstanceKey;

  public static final String JSON_PROPERTY_PARENT_ELEMENT_INSTANCE_KEY = "parentElementInstanceKey";
  @javax.annotation.Nullable
  private String parentElementInstanceKey;

  public static final String JSON_PROPERTY_TAGS = "tags";
  @javax.annotation.Nullable
  private Set<String> tags = new LinkedHashSet<>();

  public ProcessInstanceResult() {
  }

  public ProcessInstanceResult processDefinitionId(@javax.annotation.Nullable String processDefinitionId) {
    
    this.processDefinitionId = processDefinitionId;
    return this;
  }

  /**
   * The process definition ID.
   * @return processDefinitionId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProcessDefinitionId() {
    return processDefinitionId;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionId(@javax.annotation.Nullable String processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public ProcessInstanceResult processDefinitionName(@javax.annotation.Nullable String processDefinitionName) {
    
    this.processDefinitionName = processDefinitionName;
    return this;
  }

  /**
   * The process definition name.
   * @return processDefinitionName
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProcessDefinitionName() {
    return processDefinitionName;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionName(@javax.annotation.Nullable String processDefinitionName) {
    this.processDefinitionName = processDefinitionName;
  }

  public ProcessInstanceResult processDefinitionVersion(@javax.annotation.Nullable Integer processDefinitionVersion) {
    
    this.processDefinitionVersion = processDefinitionVersion;
    return this;
  }

  /**
   * The process definition version.
   * @return processDefinitionVersion
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getProcessDefinitionVersion() {
    return processDefinitionVersion;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionVersion(@javax.annotation.Nullable Integer processDefinitionVersion) {
    this.processDefinitionVersion = processDefinitionVersion;
  }

  public ProcessInstanceResult processDefinitionVersionTag(@javax.annotation.Nullable String processDefinitionVersionTag) {
    
    this.processDefinitionVersionTag = processDefinitionVersionTag;
    return this;
  }

  /**
   * The process definition version tag.
   * @return processDefinitionVersionTag
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_VERSION_TAG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProcessDefinitionVersionTag() {
    return processDefinitionVersionTag;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_VERSION_TAG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionVersionTag(@javax.annotation.Nullable String processDefinitionVersionTag) {
    this.processDefinitionVersionTag = processDefinitionVersionTag;
  }

  public ProcessInstanceResult startDate(@javax.annotation.Nullable String startDate) {
    
    this.startDate = startDate;
    return this;
  }

  /**
   * The start date.
   * @return startDate
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getStartDate() {
    return startDate;
  }


  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStartDate(@javax.annotation.Nullable String startDate) {
    this.startDate = startDate;
  }

  public ProcessInstanceResult endDate(@javax.annotation.Nullable String endDate) {
    
    this.endDate = endDate;
    return this;
  }

  /**
   * The end date.
   * @return endDate
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getEndDate() {
    return endDate;
  }


  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEndDate(@javax.annotation.Nullable String endDate) {
    this.endDate = endDate;
  }

  public ProcessInstanceResult state(@javax.annotation.Nullable ProcessInstanceStateEnum state) {
    
    this.state = state;
    return this;
  }

  /**
   * Get state
   * @return state
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ProcessInstanceStateEnum getState() {
    return state;
  }


  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setState(@javax.annotation.Nullable ProcessInstanceStateEnum state) {
    this.state = state;
  }

  public ProcessInstanceResult hasIncident(@javax.annotation.Nullable Boolean hasIncident) {
    
    this.hasIncident = hasIncident;
    return this;
  }

  /**
   * Whether this process instance has a related incident or not.
   * @return hasIncident
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_HAS_INCIDENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasIncident() {
    return hasIncident;
  }


  @JsonProperty(JSON_PROPERTY_HAS_INCIDENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasIncident(@javax.annotation.Nullable Boolean hasIncident) {
    this.hasIncident = hasIncident;
  }

  public ProcessInstanceResult tenantId(@javax.annotation.Nullable String tenantId) {
    
    this.tenantId = tenantId;
    return this;
  }

  /**
   * The tenant ID.
   * @return tenantId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTenantId() {
    return tenantId;
  }


  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTenantId(@javax.annotation.Nullable String tenantId) {
    this.tenantId = tenantId;
  }

  public ProcessInstanceResult processInstanceKey(@javax.annotation.Nullable String processInstanceKey) {
    
    this.processInstanceKey = processInstanceKey;
    return this;
  }

  /**
   * The key of this process instance.
   * @return processInstanceKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProcessInstanceKey() {
    return processInstanceKey;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessInstanceKey(@javax.annotation.Nullable String processInstanceKey) {
    this.processInstanceKey = processInstanceKey;
  }

  public ProcessInstanceResult processDefinitionKey(@javax.annotation.Nullable String processDefinitionKey) {
    
    this.processDefinitionKey = processDefinitionKey;
    return this;
  }

  /**
   * The process definition key.
   * @return processDefinitionKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProcessDefinitionKey() {
    return processDefinitionKey;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionKey(@javax.annotation.Nullable String processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  public ProcessInstanceResult parentProcessInstanceKey(@javax.annotation.Nullable String parentProcessInstanceKey) {
    
    this.parentProcessInstanceKey = parentProcessInstanceKey;
    return this;
  }

  /**
   * The parent process instance key.
   * @return parentProcessInstanceKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PARENT_PROCESS_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getParentProcessInstanceKey() {
    return parentProcessInstanceKey;
  }


  @JsonProperty(JSON_PROPERTY_PARENT_PROCESS_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setParentProcessInstanceKey(@javax.annotation.Nullable String parentProcessInstanceKey) {
    this.parentProcessInstanceKey = parentProcessInstanceKey;
  }

  public ProcessInstanceResult parentElementInstanceKey(@javax.annotation.Nullable String parentElementInstanceKey) {
    
    this.parentElementInstanceKey = parentElementInstanceKey;
    return this;
  }

  /**
   * The parent element instance key.
   * @return parentElementInstanceKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PARENT_ELEMENT_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getParentElementInstanceKey() {
    return parentElementInstanceKey;
  }


  @JsonProperty(JSON_PROPERTY_PARENT_ELEMENT_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setParentElementInstanceKey(@javax.annotation.Nullable String parentElementInstanceKey) {
    this.parentElementInstanceKey = parentElementInstanceKey;
  }

  public ProcessInstanceResult tags(@javax.annotation.Nullable Set<String> tags) {
    
    this.tags = tags;
    return this;
  }

  public ProcessInstanceResult addTagsItem(String tagsItem) {
    if (this.tags == null) {
      this.tags = new LinkedHashSet<>();
    }
    this.tags.add(tagsItem);
    return this;
  }

  /**
   * List of tags
   * @return tags
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Set<String> getTags() {
    return tags;
  }


  @JsonDeserialize(as = LinkedHashSet.class)
  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTags(@javax.annotation.Nullable Set<String> tags) {
    this.tags = tags;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProcessInstanceResult processInstanceResult = (ProcessInstanceResult) o;
    return Objects.equals(this.processDefinitionId, processInstanceResult.processDefinitionId) &&
        Objects.equals(this.processDefinitionName, processInstanceResult.processDefinitionName) &&
        Objects.equals(this.processDefinitionVersion, processInstanceResult.processDefinitionVersion) &&
        Objects.equals(this.processDefinitionVersionTag, processInstanceResult.processDefinitionVersionTag) &&
        Objects.equals(this.startDate, processInstanceResult.startDate) &&
        Objects.equals(this.endDate, processInstanceResult.endDate) &&
        Objects.equals(this.state, processInstanceResult.state) &&
        Objects.equals(this.hasIncident, processInstanceResult.hasIncident) &&
        Objects.equals(this.tenantId, processInstanceResult.tenantId) &&
        Objects.equals(this.processInstanceKey, processInstanceResult.processInstanceKey) &&
        Objects.equals(this.processDefinitionKey, processInstanceResult.processDefinitionKey) &&
        Objects.equals(this.parentProcessInstanceKey, processInstanceResult.parentProcessInstanceKey) &&
        Objects.equals(this.parentElementInstanceKey, processInstanceResult.parentElementInstanceKey) &&
        Objects.equals(this.tags, processInstanceResult.tags);
  }

  @Override
  public int hashCode() {
    return Objects.hash(processDefinitionId, processDefinitionName, processDefinitionVersion, processDefinitionVersionTag, startDate, endDate, state, hasIncident, tenantId, processInstanceKey, processDefinitionKey, parentProcessInstanceKey, parentElementInstanceKey, tags);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ProcessInstanceResult {\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    processDefinitionName: ").append(toIndentedString(processDefinitionName)).append("\n");
    sb.append("    processDefinitionVersion: ").append(toIndentedString(processDefinitionVersion)).append("\n");
    sb.append("    processDefinitionVersionTag: ").append(toIndentedString(processDefinitionVersionTag)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    hasIncident: ").append(toIndentedString(hasIncident)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    processInstanceKey: ").append(toIndentedString(processInstanceKey)).append("\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    parentProcessInstanceKey: ").append(toIndentedString(parentProcessInstanceKey)).append("\n");
    sb.append("    parentElementInstanceKey: ").append(toIndentedString(parentElementInstanceKey)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `processDefinitionId` to the URL query string
    if (getProcessDefinitionId() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionName` to the URL query string
    if (getProcessDefinitionName() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionVersion` to the URL query string
    if (getProcessDefinitionVersion() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionVersion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionVersion()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionVersionTag` to the URL query string
    if (getProcessDefinitionVersionTag() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionVersionTag%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionVersionTag()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `startDate` to the URL query string
    if (getStartDate() != null) {
      try {
        joiner.add(String.format("%sstartDate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getStartDate()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `endDate` to the URL query string
    if (getEndDate() != null) {
      try {
        joiner.add(String.format("%sendDate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getEndDate()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `state` to the URL query string
    if (getState() != null) {
      try {
        joiner.add(String.format("%sstate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getState()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `hasIncident` to the URL query string
    if (getHasIncident() != null) {
      try {
        joiner.add(String.format("%shasIncident%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getHasIncident()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tenantId` to the URL query string
    if (getTenantId() != null) {
      try {
        joiner.add(String.format("%stenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processInstanceKey` to the URL query string
    if (getProcessInstanceKey() != null) {
      try {
        joiner.add(String.format("%sprocessInstanceKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessInstanceKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionKey` to the URL query string
    if (getProcessDefinitionKey() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `parentProcessInstanceKey` to the URL query string
    if (getParentProcessInstanceKey() != null) {
      try {
        joiner.add(String.format("%sparentProcessInstanceKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getParentProcessInstanceKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `parentElementInstanceKey` to the URL query string
    if (getParentElementInstanceKey() != null) {
      try {
        joiner.add(String.format("%sparentElementInstanceKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getParentElementInstanceKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tags` to the URL query string
    if (getTags() != null) {
      int i = 0;
      for (String _item : getTags()) {
        try {
          joiner.add(String.format("%stags%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(_item), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
      i++;
    }

    return joiner.toString();
  }

}

