/*
 * Orchestration Cluster API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.zeebe.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * Pagination information about the search results.
 */
@JsonPropertyOrder({
  SearchQueryPageResponse.JSON_PROPERTY_TOTAL_ITEMS,
  SearchQueryPageResponse.JSON_PROPERTY_HAS_MORE_TOTAL_ITEMS,
  SearchQueryPageResponse.JSON_PROPERTY_START_CURSOR,
  SearchQueryPageResponse.JSON_PROPERTY_END_CURSOR
})
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-12-11T14:21:53.463692534Z[GMT]", comments = "Generator version: 7.12.0")
public class SearchQueryPageResponse {
  public static final String JSON_PROPERTY_TOTAL_ITEMS = "totalItems";
  @javax.annotation.Nullable
  private Long totalItems;

  public static final String JSON_PROPERTY_HAS_MORE_TOTAL_ITEMS = "hasMoreTotalItems";
  @javax.annotation.Nullable
  private Boolean hasMoreTotalItems;

  public static final String JSON_PROPERTY_START_CURSOR = "startCursor";
  @javax.annotation.Nullable
  private String startCursor;

  public static final String JSON_PROPERTY_END_CURSOR = "endCursor";
  @javax.annotation.Nullable
  private String endCursor;

  public SearchQueryPageResponse() {
  }

  public SearchQueryPageResponse totalItems(@javax.annotation.Nullable Long totalItems) {
    
    this.totalItems = totalItems;
    return this;
  }

  /**
   * Total items matching the criteria.
   * @return totalItems
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TOTAL_ITEMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getTotalItems() {
    return totalItems;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_ITEMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalItems(@javax.annotation.Nullable Long totalItems) {
    this.totalItems = totalItems;
  }

  public SearchQueryPageResponse hasMoreTotalItems(@javax.annotation.Nullable Boolean hasMoreTotalItems) {
    
    this.hasMoreTotalItems = hasMoreTotalItems;
    return this;
  }

  /**
   * Indicates if more results exist beyond the reported totalItems value. Due to system limitations, the totalItems value can be capped. 
   * @return hasMoreTotalItems
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_HAS_MORE_TOTAL_ITEMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasMoreTotalItems() {
    return hasMoreTotalItems;
  }


  @JsonProperty(JSON_PROPERTY_HAS_MORE_TOTAL_ITEMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasMoreTotalItems(@javax.annotation.Nullable Boolean hasMoreTotalItems) {
    this.hasMoreTotalItems = hasMoreTotalItems;
  }

  public SearchQueryPageResponse startCursor(@javax.annotation.Nullable String startCursor) {
    
    this.startCursor = startCursor;
    return this;
  }

  /**
   * The cursor value for getting the previous page of results. Use this in the &#x60;before&#x60; field of an ensuing request.
   * @return startCursor
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_START_CURSOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getStartCursor() {
    return startCursor;
  }


  @JsonProperty(JSON_PROPERTY_START_CURSOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStartCursor(@javax.annotation.Nullable String startCursor) {
    this.startCursor = startCursor;
  }

  public SearchQueryPageResponse endCursor(@javax.annotation.Nullable String endCursor) {
    
    this.endCursor = endCursor;
    return this;
  }

  /**
   * The cursor value for getting the next page of results. Use this in the &#x60;after&#x60; field of an ensuing request.
   * @return endCursor
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_END_CURSOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getEndCursor() {
    return endCursor;
  }


  @JsonProperty(JSON_PROPERTY_END_CURSOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEndCursor(@javax.annotation.Nullable String endCursor) {
    this.endCursor = endCursor;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SearchQueryPageResponse searchQueryPageResponse = (SearchQueryPageResponse) o;
    return Objects.equals(this.totalItems, searchQueryPageResponse.totalItems) &&
        Objects.equals(this.hasMoreTotalItems, searchQueryPageResponse.hasMoreTotalItems) &&
        Objects.equals(this.startCursor, searchQueryPageResponse.startCursor) &&
        Objects.equals(this.endCursor, searchQueryPageResponse.endCursor);
  }

  @Override
  public int hashCode() {
    return Objects.hash(totalItems, hasMoreTotalItems, startCursor, endCursor);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SearchQueryPageResponse {\n");
    sb.append("    totalItems: ").append(toIndentedString(totalItems)).append("\n");
    sb.append("    hasMoreTotalItems: ").append(toIndentedString(hasMoreTotalItems)).append("\n");
    sb.append("    startCursor: ").append(toIndentedString(startCursor)).append("\n");
    sb.append("    endCursor: ").append(toIndentedString(endCursor)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `totalItems` to the URL query string
    if (getTotalItems() != null) {
      try {
        joiner.add(String.format("%stotalItems%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTotalItems()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `hasMoreTotalItems` to the URL query string
    if (getHasMoreTotalItems() != null) {
      try {
        joiner.add(String.format("%shasMoreTotalItems%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getHasMoreTotalItems()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `startCursor` to the URL query string
    if (getStartCursor() != null) {
      try {
        joiner.add(String.format("%sstartCursor%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getStartCursor()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `endCursor` to the URL query string
    if (getEndCursor() != null) {
      try {
        joiner.add(String.format("%sendCursor%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getEndCursor()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

