/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.io;

import io.deephaven.base.verify.Require;
import io.deephaven.io.InputStreamFactory;
import io.deephaven.io.streams.MultiFileInputStream;
import io.deephaven.io.streams.SevenZipInputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarUtils;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;

public class CompressedFileUtil {
    public static final long UINT_TO_LONG = 0xFFFFFFFFL;
    public static final int BZIP2_MAGIC = 6838850;
    public static final String[] COMPRESSION_EXTENSIONS = new String[]{".gz", ".tgz", ".tar.gz", ".zip", ".bz2", ".7z"};
    private static final int TAR_CHECKSUM_OFFSET = 148;

    public static int bunzip2(File file) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        list.add("bzip2");
        list.add("-d");
        list.add(file.getPath());
        try {
            ProcessExecutor executor = CompressedFileUtil.exec(list, ".", "out.log", "err.log");
            executor.waitFor();
            return executor.exitValue();
        }
        catch (InterruptedException interruptedException) {
            return -1;
        }
    }

    public static void bzip2(String archiveName, String baseDir, String[] inputFiles) throws IOException {
        if (inputFiles.length == 0) {
            throw new IllegalArgumentException("Need at least one input file.");
        }
        ArrayList<String> tarCmdList = new ArrayList<String>();
        tarCmdList.add("tar");
        tarCmdList.add("cvjf");
        tarCmdList.add(archiveName);
        for (int i = 0; i < inputFiles.length; ++i) {
            File input = new File(baseDir + "/" + inputFiles[i]);
            if (!input.exists()) {
                throw new IOException("Input file " + input.getAbsolutePath() + " doesn't exist.");
            }
            tarCmdList.add(inputFiles[i]);
        }
        ProcessExecutor p = CompressedFileUtil.exec(tarCmdList, baseDir, "tar.out", "tar.err");
        try {
            p.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (p.exitValue() != 0) {
            throw new RuntimeException("TAR failed: " + tarCmdList);
        }
    }

    public static void unbzip2(File archive) throws IOException {
        if (!archive.exists()) {
            throw new IllegalArgumentException("File " + archive.getAbsolutePath() + " doesn't exist.");
        }
        String workDir = archive.getParent();
        ArrayList<String> tarCmdList = new ArrayList<String>();
        tarCmdList.add("tar");
        tarCmdList.add("xvjof");
        tarCmdList.add(archive.getName());
        ProcessExecutor p = CompressedFileUtil.exec(tarCmdList, workDir, "tar.out", "tar.err");
        try {
            p.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (p.exitValue() != 0) {
            throw new RuntimeException("Tar decompression ailed: " + tarCmdList);
        }
        new File(archive.getName()).delete();
    }

    public static void zipFile(File inputFile, File zipFilePath) throws IOException {
        int bytesRead;
        FileOutputStream fileOutputStream = new FileOutputStream(zipFilePath);
        ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
        ZipEntry zipEntry = new ZipEntry(inputFile.getName());
        zipOutputStream.putNextEntry(zipEntry);
        FileInputStream fileInputStream = new FileInputStream(inputFile);
        byte[] buf = new byte[1024];
        while ((bytesRead = fileInputStream.read(buf)) > 0) {
            zipOutputStream.write(buf, 0, bytesRead);
        }
        zipOutputStream.closeEntry();
        zipOutputStream.close();
        fileOutputStream.close();
    }

    private static ProcessExecutor exec(List commandList, String workDir, String stdoutFile, String stderrFile) {
        return new ProcessExecutor(commandList, workDir, stdoutFile, stderrFile);
    }

    public static InputStream openPossiblyCompressedFiles(String[] fileNames) throws IOException {
        ArrayList<MultiFileInputStream.DecoratedInputStream> inputStreams = new ArrayList<MultiFileInputStream.DecoratedInputStream>();
        for (String currentFileName : fileNames) {
            inputStreams.add(new MultiFileInputStream.DecoratedInputStream(currentFileName, CompressedFileUtil.openPossiblyCompressedFile(currentFileName)));
        }
        return new MultiFileInputStream(inputStreams.toArray(new MultiFileInputStream.DecoratedInputStream[inputStreams.size()]));
    }

    public static String addCompressionExtensionIfNeeded(String sFileName) {
        File file = new File(sFileName);
        if (!file.exists()) {
            for (String sExtension : COMPRESSION_EXTENSIONS) {
                File altFile = new File(file.toString() + sExtension);
                if (!altFile.exists()) continue;
                file = altFile;
                break;
            }
        }
        return file.toString();
    }

    public static InputStream openPossiblyCompressedFile(String sFileName, Boolean useMicrosPcapEmulation) throws IOException {
        if (useMicrosPcapEmulation == null) {
            return CompressedFileUtil.openPossiblyCompressedFile(new FileInputStreamFactory(sFileName));
        }
        InputStream inputStream = CompressedFileUtil.openPossiblyCompressedFile(sFileName, null);
        boolean markSupported = inputStream.markSupported();
        if (markSupported) {
            inputStream.mark(4);
        }
        int magic4 = CompressedFileUtil.getMagic4(inputStream, CompressedFileUtil.getMagic2(inputStream));
        if (markSupported) {
            inputStream.reset();
        } else {
            inputStream.close();
            inputStream = CompressedFileUtil.openPossiblyCompressedFile(sFileName, null);
        }
        return inputStream;
    }

    public static InputStream openPossiblyCompressedFile(String sFileName) throws IOException {
        return CompressedFileUtil.openPossiblyCompressedFile(sFileName, true);
    }

    public static InputStream openPossiblyCompressedFile(String sFileName, int bufferedSize, Boolean useMicrosPcapEmulation) throws IOException {
        if (useMicrosPcapEmulation == null) {
            return CompressedFileUtil.openPossiblyCompressedFile(new FileInputStreamFactory(sFileName, bufferedSize));
        }
        InputStream inputStream = CompressedFileUtil.openPossiblyCompressedFile(sFileName, bufferedSize, null);
        boolean markSupported = inputStream.markSupported();
        if (markSupported) {
            inputStream.mark(4);
        }
        int magic4 = CompressedFileUtil.getMagic4(inputStream, CompressedFileUtil.getMagic2(inputStream));
        if (markSupported) {
            inputStream.reset();
        } else {
            inputStream.close();
            inputStream = CompressedFileUtil.openPossiblyCompressedFile(sFileName, bufferedSize, null);
        }
        return inputStream;
    }

    public static InputStream openPossiblyCompressedFile(String sFileName, int bufferedSize) throws IOException {
        return CompressedFileUtil.openPossiblyCompressedFile(sFileName, bufferedSize, true);
    }

    public static InputStream openPossiblyCompressedFile(InputStreamFactory inputStreamFactory) throws IOException {
        InputStreamFactory decompressedInputStreamFactory = CompressedFileUtil.createInputStreamFactoryForPossiblyCompressedStream(inputStreamFactory);
        decompressedInputStreamFactory = CompressedFileUtil.createInputStreamFactoryForPossiblyTarredStream(decompressedInputStreamFactory);
        InputStream inputStream = decompressedInputStreamFactory.createInputStream();
        return inputStream;
    }

    public static InputStreamFactory createInputStreamFactoryForPossiblyCompressedStream(final InputStreamFactory inputStreamFactory) throws IOException {
        InputStream testStream = inputStreamFactory.createInputStream();
        int nMagic2 = CompressedFileUtil.getMagic2(testStream);
        int nMagic4 = CompressedFileUtil.getMagic4(testStream, nMagic2);
        long nMagic6 = CompressedFileUtil.getMagic6(testStream, nMagic4);
        testStream.close();
        InputStreamFactory decompressedInputStreamFactory = 6838850 == (nMagic4 & 0xFFFFFF) ? new InputStreamFactory(){

            @Override
            public InputStream createInputStream() throws IOException {
                return new BZip2CompressorInputStream(inputStreamFactory.createInputStream());
            }

            @Override
            public String getDescription() {
                return "bzip2'd " + inputStreamFactory.getDescription();
            }
        } : (35615 == nMagic2 ? new InputStreamFactory(){

            @Override
            public InputStream createInputStream() throws IOException {
                return new GZIPInputStream(inputStreamFactory.createInputStream());
            }

            @Override
            public String getDescription() {
                return "gzipped " + inputStreamFactory.getDescription();
            }
        } : (67324752L == (long)nMagic4 ? new InputStreamFactory(){
            private String m_sSubFileName;

            @Override
            public InputStream createInputStream() throws IOException {
                ZipInputStream zipInputStream = new ZipInputStream(inputStreamFactory.createInputStream());
                ZipEntry zipEntry = zipInputStream.getNextEntry();
                if (null == zipEntry) {
                    throw new FileNotFoundException("No zip entries in " + inputStreamFactory.getDescription() + ".");
                }
                this.m_sSubFileName = zipEntry.getName();
                return zipInputStream;
            }

            @Override
            public String getDescription() {
                return "zipped " + inputStreamFactory.getDescription() + (null == this.m_sSubFileName ? "" : " (sub-file \"" + this.m_sSubFileName + "\")");
            }
        } : (SevenZipInputStream.SIGNATURE_AS_LONG == nMagic6 ? new InputStreamFactory(){
            private String m_sSubFileName;

            @Override
            public InputStream createInputStream() throws IOException {
                SevenZipInputStream zipInputStream = new SevenZipInputStream(inputStreamFactory);
                SevenZipInputStream.Entry entry = zipInputStream.getNextEntry(SevenZipInputStream.Behavior.SKIP_WHEN_NO_STREAM);
                if (null == entry) {
                    throw new FileNotFoundException("No zip entries in " + inputStreamFactory.getDescription() + ".");
                }
                this.m_sSubFileName = entry.getName();
                return zipInputStream;
            }

            @Override
            public String getDescription() {
                return "7zipped " + inputStreamFactory.getDescription() + (null == this.m_sSubFileName ? "" : " (sub-file \"" + this.m_sSubFileName + "\")");
            }
        } : new InputStreamFactory(){

            @Override
            public InputStream createInputStream() throws IOException {
                return inputStreamFactory.createInputStream();
            }

            @Override
            public String getDescription() {
                return "plaintext " + inputStreamFactory.getDescription();
            }
        })));
        return decompressedInputStreamFactory;
    }

    public static long getMagic6(InputStream testStream, int nMagic4) throws IOException {
        return ((long)testStream.read() & 0xFFFFFFFFL) << 32 | ((long)testStream.read() & 0xFFFFFFFFL) << 40 | (long)nMagic4 & 0xFFFFFFFFL;
    }

    public static int getMagic4(InputStream testStream, int nMagic2) throws IOException {
        return testStream.read() << 16 | testStream.read() << 24 | nMagic2;
    }

    public static int getMagic2(InputStream testStream) throws IOException {
        return testStream.read() | testStream.read() << 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStreamFactory createInputStreamFactoryForPossiblyTarredStream(final InputStreamFactory inputStreamFactory) throws IOException {
        long nExpectedChecksum;
        byte[] header = new byte[512];
        try (InputStream testStream = inputStreamFactory.createInputStream();){
            int nBytesRead;
            for (int nOffset = 0; nOffset < header.length; nOffset += nBytesRead) {
                nBytesRead = testStream.read(header, nOffset, header.length - nOffset);
                if (-1 != nBytesRead) continue;
                InputStreamFactory inputStreamFactory2 = inputStreamFactory;
                return inputStreamFactory2;
            }
        }
        try {
            nExpectedChecksum = TarUtils.parseOctal((byte[])header, (int)148, (int)8);
        }
        catch (IllegalArgumentException ignored) {
            return inputStreamFactory;
        }
        for (int nOffset = 0; nOffset < 8; ++nOffset) {
            header[148 + nOffset] = 32;
        }
        long nActualChecksum = TarUtils.computeCheckSum((byte[])header);
        if (nExpectedChecksum != nActualChecksum) {
            return inputStreamFactory;
        }
        return new InputStreamFactory(){
            private String m_sSubFileName;

            @Override
            public InputStream createInputStream() throws IOException {
                TarArchiveInputStream tarInputStream = new TarArchiveInputStream(inputStreamFactory.createInputStream());
                TarArchiveEntry tarEntry = tarInputStream.getNextTarEntry();
                if (null == tarEntry) {
                    throw new FileNotFoundException("No tar entries in " + inputStreamFactory.getDescription() + ".");
                }
                this.m_sSubFileName = tarEntry.getName();
                return tarInputStream;
            }

            @Override
            public String getDescription() {
                return "tarred " + inputStreamFactory.getDescription() + (null == this.m_sSubFileName ? "" : " (sub-file \"" + this.m_sSubFileName + "\")");
            }
        };
    }

    private static class ProcessExecutor {
        ProcessBuilder builder;
        Process p = null;
        FilePipe outPipe;
        FilePipe errPipe;

        ProcessExecutor(List cmdList, String workDir, String stdoutFile, String stderrFile) {
            this.builder = new ProcessBuilder(cmdList);
            if (workDir != null) {
                this.builder.directory(new File(workDir));
            }
            try {
                this.p = this.builder.start();
                this.outPipe = new FilePipe(stdoutFile, this.p.getInputStream());
                this.errPipe = new FilePipe(stderrFile, this.p.getErrorStream());
                this.outPipe.start();
                this.errPipe.start();
            }
            catch (Exception e) {
                throw new RuntimeException("Error while executing native command: " + cmdList.get(0), e);
            }
        }

        public void waitFor() throws InterruptedException, IOException {
            try {
                this.p.waitFor();
            }
            finally {
                this.outPipe.close();
                this.errPipe.close();
            }
        }

        public int exitValue() {
            return this.p.exitValue();
        }
    }

    public static class FileInputStreamFactory
    implements InputStreamFactory {
        private final String m_sFileName;
        private final int m_bufferedSize;

        public FileInputStreamFactory(String sFileName) {
            this(sFileName, 8192);
        }

        public FileInputStreamFactory(String sFileName, int bufferedSize) {
            Require.nonempty((String)sFileName, (String)"sFileName");
            this.m_sFileName = sFileName;
            this.m_bufferedSize = bufferedSize;
        }

        @Override
        public InputStream createInputStream() throws IOException {
            return new BufferedInputStream(new FileInputStream(this.m_sFileName), this.m_bufferedSize);
        }

        @Override
        public String getDescription() {
            return "file \"" + this.m_sFileName + "\"";
        }
    }

    public static class FilePipe
    extends Thread {
        BufferedInputStream reader;
        FileWriter writer;
        boolean done = false;

        public FilePipe(String fileName, InputStream inStream) throws IOException {
            super("WFileUtil.FilePipe->" + fileName);
            this.reader = new BufferedInputStream(inStream);
            if (fileName != null) {
                this.writer = new FileWriter(fileName);
            }
        }

        @Override
        public void run() {
            while (!this.done) {
                try {
                    this.flush();
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Error while writing to pipe.", e);
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException x) {
                    return;
                }
            }
        }

        public synchronized void flush() throws IOException {
            int avail;
            if (!this.done && (avail = this.reader.available()) > 0) {
                byte[] buffer = new byte[avail];
                int length = this.reader.read(buffer);
                if (length == -1) {
                    this.done = true;
                } else if (this.writer != null) {
                    this.writer.write(new String(buffer));
                }
            }
        }

        public synchronized void close() throws IOException {
            if (!this.done) {
                this.flush();
                this.done = true;
                this.reader.close();
                if (this.writer != null) {
                    this.writer.close();
                }
            }
        }
    }
}

