/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.io.log;

import io.deephaven.base.MathUtil;
import io.deephaven.base.log.LogOutput;
import io.deephaven.base.log.LogOutputAppendable;
import io.deephaven.base.text.TimestampBuffer;
import io.deephaven.base.text.TimestampBufferMicros;
import io.deephaven.io.log.LogLevel;
import io.deephaven.io.log.LogSink;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.ApiStatus;

public interface LogEntry
extends LogOutput,
LogSink.Element {
    public static final Null NULL = new Null();

    public LogEntry start(LogSink var1, LogLevel var2);

    public LogEntry start(LogSink var1, LogLevel var2, long var3);

    public LogEntry start(LogSink var1, LogLevel var2, long var3, Throwable var5);

    public void end();

    public void endl();

    public LogEntry append(boolean var1);

    public LogEntry append(char var1);

    public LogEntry append(short var1);

    public LogEntry append(int var1);

    public LogEntry append(long var1);

    public LogEntry appendDouble(double var1);

    public LogEntry append(LogOutputAppendable var1);

    public LogEntry append(LogOutput.LongFormatter var1, long var2);

    public <T> LogEntry append(LogOutput.ObjFormatter<T> var1, T var2);

    public <T> LogEntry append(LogOutput.ObjIntIntFormatter<T> var1, T var2, int var3, int var4);

    public <T, U> LogEntry append(LogOutput.ObjObjFormatter<T, U> var1, T var2, U var3);

    public LogEntry append(CharSequence var1);

    public LogEntry append(CharSequence var1, int var2, int var3);

    public LogEntry append(ByteBuffer var1);

    public LogEntry appendTimestamp(long var1, TimestampBuffer var3);

    public LogEntry appendTimestampMicros(long var1, TimestampBufferMicros var3);

    public LogEntry append(Throwable var1);

    public LogEntry append(byte[] var1);

    public LogEntry append(byte[] var1, int var2, int var3);

    public LogEntry append(byte[] var1, byte var2);

    default public LogEntry append(Boolean b) {
        return b == null ? this.append("null") : this.append((boolean)b);
    }

    default public LogEntry append(Character c) {
        return c == null ? this.append("null") : this.append(c.charValue());
    }

    default public LogEntry append(Short s) {
        return s == null ? this.append("null") : this.append((short)s);
    }

    default public LogEntry append(Integer i) {
        return i == null ? this.append("null") : this.append((int)i);
    }

    default public LogEntry append(Long l) {
        return l == null ? this.append("null") : this.append((long)l);
    }

    default public LogEntry appendDouble(Double f) {
        return f == null ? this.append("null") : this.appendDouble((double)f);
    }

    default public LogEntry appendDouble(double doubleValue, int decimalPlaces) {
        return Helper.appendDoubleDecimalPlacesImpl(this, doubleValue, decimalPlaces, decimalPlaces);
    }

    default public LogEntry appendDouble(double doubleValue, int decimalPlaces, int maxTrailingZeroesToDiscard) {
        return Helper.appendDoubleDecimalPlacesImpl(this, doubleValue, decimalPlaces, decimalPlaces - maxTrailingZeroesToDiscard);
    }

    public LogEntry nf();

    public LogEntry nl();

    @ApiStatus.Internal
    public static final class Helper {
        private Helper() {
        }

        private static LogEntry appendDoubleDecimalPlacesImpl(LogEntry entry, double doubleValue, int roundToDecimalPlaces, int minDecimalPlaces) {
            int actualDecimalPlaces;
            if (roundToDecimalPlaces < 0 || roundToDecimalPlaces > 9) {
                throw new IllegalArgumentException("Invalid value for decimalPlaces = " + roundToDecimalPlaces);
            }
            int roundToAsPowerOf10 = MathUtil.pow10((int)roundToDecimalPlaces);
            boolean negative = doubleValue < 0.0;
            long longWeightedValue = negative ? -((long)(-0.5 + doubleValue * (double)roundToAsPowerOf10)) : (long)(0.5 + doubleValue * (double)roundToAsPowerOf10);
            long integral = longWeightedValue / (long)roundToAsPowerOf10;
            entry = negative ? entry.append(-integral) : entry.append(integral);
            if (roundToDecimalPlaces == 0) {
                return entry;
            }
            int fractional = (int)(longWeightedValue % (long)roundToAsPowerOf10);
            for (actualDecimalPlaces = roundToDecimalPlaces; minDecimalPlaces < actualDecimalPlaces && fractional > 0 && fractional % 10 == 0; fractional /= 10, --actualDecimalPlaces) {
            }
            if (minDecimalPlaces == 0 && fractional == 0) {
                return entry;
            }
            entry = entry.append(".");
            int base10FractionalDigits = MathUtil.base10digits((int)fractional);
            int leadingZeroes = actualDecimalPlaces - base10FractionalDigits;
            switch (leadingZeroes) {
                case 9: {
                    entry = entry.append("000000000");
                }
                case 8: {
                    entry = entry.append("00000000");
                    break;
                }
                case 7: {
                    entry = entry.append("0000000");
                    break;
                }
                case 6: {
                    entry = entry.append("000000");
                    break;
                }
                case 5: {
                    entry = entry.append("00000");
                    break;
                }
                case 4: {
                    entry = entry.append("0000");
                    break;
                }
                case 3: {
                    entry = entry.append("000");
                    break;
                }
                case 2: {
                    entry = entry.append("00");
                    break;
                }
                case 1: {
                    entry = entry.append("0");
                }
            }
            if (fractional == 0) {
                return entry;
            }
            return entry.append(fractional);
        }
    }

    public static class Null
    extends LogOutput.Null
    implements LogEntry {
        @Override
        public LogEntry start(LogSink sink, LogLevel level) {
            return this;
        }

        @Override
        public LogEntry start(LogSink sink, LogLevel level, long currentTimeMicros) {
            return this;
        }

        @Override
        public LogEntry start(LogSink sink, LogLevel level, long currentTimeMicros, Throwable t) {
            return this;
        }

        @Override
        public void end() {
        }

        @Override
        public void endl() {
        }

        @Override
        public LogEntry append(boolean b) {
            return this;
        }

        @Override
        public LogEntry append(char c) {
            return this;
        }

        @Override
        public LogEntry append(short s) {
            return this;
        }

        @Override
        public LogEntry append(int i) {
            return this;
        }

        @Override
        public LogEntry append(long l) {
            return this;
        }

        @Override
        public LogEntry appendDouble(double f) {
            return this;
        }

        @Override
        public LogEntry append(LogOutputAppendable appendable) {
            return this;
        }

        @Override
        public LogEntry append(LogOutput.LongFormatter formatter, long n) {
            return this;
        }

        @Override
        public <T> LogEntry append(LogOutput.ObjFormatter<T> objFormatter, T t) {
            return this;
        }

        @Override
        public <T> LogEntry append(LogOutput.ObjIntIntFormatter<T> objFormatter, T t, int nOffset, int nLength) {
            return this;
        }

        @Override
        public <T, U> LogEntry append(LogOutput.ObjObjFormatter<T, U> objObjFormatter, T t, U u) {
            return this;
        }

        @Override
        public LogEntry append(CharSequence seq) {
            return this;
        }

        @Override
        public LogEntry append(CharSequence seq, int start, int length) {
            return this;
        }

        @Override
        public LogEntry append(ByteBuffer buffer) {
            return this;
        }

        @Override
        public LogEntry appendTimestamp(long utcMillis, TimestampBuffer tb) {
            return this;
        }

        @Override
        public LogEntry appendTimestampMicros(long utcMicros, TimestampBufferMicros tb) {
            return this;
        }

        @Override
        public LogEntry append(Throwable t) {
            return this;
        }

        @Override
        public LogEntry append(byte[] ba) {
            return this;
        }

        @Override
        public LogEntry append(byte[] ba, int pos, int length) {
            return this;
        }

        @Override
        public LogEntry append(byte[] ba, byte terminator) {
            return this;
        }

        @Override
        public LogEntry nf() {
            return this;
        }

        @Override
        public LogEntry nl() {
            return this;
        }

        @Override
        public long getTimestampMicros() {
            return 0L;
        }

        @Override
        public LogLevel getLevel() {
            return LogLevel.INFO;
        }

        @Override
        public Throwable getThrowable() {
            return null;
        }

        @Override
        public LogOutput writing(LogOutput outputBuffer) {
            return outputBuffer;
        }

        @Override
        public void written(LogOutput outputBuffer) {
        }
    }
}

