/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.io.log;

import io.deephaven.base.log.LogOutput;
import io.deephaven.base.pool.Pool;
import io.deephaven.io.log.LogLevel;
import io.deephaven.io.log.impl.LogSinkImpl;
import java.io.IOException;
import java.text.DateFormat;
import java.util.concurrent.CopyOnWriteArraySet;

public interface LogSink<T extends Element> {
    public static final Null NULL = new Null();

    public void write(T var1);

    public void shutdown();

    public void terminate();

    public void addInterceptor(Interceptor<T> var1);

    public static class Null
    implements LogSink {
        public void write(Element e) {
        }

        @Override
        public void shutdown() {
        }

        @Override
        public void terminate() {
        }

        public void addInterceptor(Interceptor interceptor) {
        }
    }

    public static interface Factory<T extends Element> {
        public LogSink<T> create(String var1, int var2, DateFormat var3, Pool<T> var4, boolean var5, LogOutput var6, String var7, LogSinkWriter<LogSinkImpl<T>> var8);
    }

    public static interface LogSinkWriter<S extends LogSink<? extends Element>> {
        public void addLogSink(S var1);
    }

    public static class Shutdown {
        private static CopyOnWriteArraySet<LogSink> allSinks = new CopyOnWriteArraySet();

        public static void addSink(LogSink sink) {
            allSinks.add(sink);
        }

        public static void removeSink(LogSink sink) {
            allSinks.remove(sink);
        }

        public static LogSink[] getSinks() {
            return allSinks.toArray(new LogSink[0]);
        }

        public static void shutdown() {
            for (LogSink sink : allSinks) {
                sink.shutdown();
            }
        }

        public static void terminate() {
            for (LogSink sink : allSinks) {
                sink.terminate();
            }
        }
    }

    public static interface Interceptor<T extends Element> {
        public void element(T var1, LogOutput var2) throws IOException;
    }

    public static interface Element {
        public long getTimestampMicros();

        public LogLevel getLevel();

        public Throwable getThrowable();

        public LogOutput writing(LogOutput var1);

        public void written(LogOutput var1);
    }
}

