/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.io.log.impl;

import io.deephaven.base.array.FastArray;
import io.deephaven.base.array.FastBooleanArray;
import io.deephaven.base.array.FastCharArray;
import io.deephaven.base.array.FastDoubleArray;
import io.deephaven.base.array.FastFloatArray;
import io.deephaven.base.array.FastIntArray;
import io.deephaven.base.array.FastLongArray;
import io.deephaven.base.array.FastShortArray;
import io.deephaven.base.log.LogOutput;
import io.deephaven.base.log.LogOutputAppendable;
import io.deephaven.base.text.TimestampBuffer;
import io.deephaven.base.text.TimestampBufferMicros;
import io.deephaven.base.verify.Assert;
import io.deephaven.io.log.LogEntry;
import io.deephaven.io.log.LogLevel;
import io.deephaven.io.log.LogSink;
import io.deephaven.io.logger.LoggerTimeSource;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;

public class DelayedLogEntryImpl
implements LogEntry {
    private final LoggerTimeSource timeSource;
    private static final AtomicLong starts = new AtomicLong(0L);
    private static final AtomicLong ends = new AtomicLong(0L);
    private final FastArray<Action> actions = new FastArray(Action.class, null, 8, false);
    private final FastBooleanArray booleans = new FastBooleanArray(8);
    private final FastCharArray chars = new FastCharArray(8);
    private final FastShortArray shorts = new FastShortArray(8);
    private final FastIntArray ints = new FastIntArray(8);
    private final FastLongArray longs = new FastLongArray(8);
    private final FastFloatArray floats = new FastFloatArray(8);
    private final FastDoubleArray doubles = new FastDoubleArray(8);
    private final FastArray<CharSequence> sequences = new FastArray(CharSequence.class, null, 8, false);
    private final FastArray<TimestampBuffer> timestamps = new FastArray(TimestampBuffer.class, null, 8, false);
    private final FastArray<TimestampBufferMicros> timestampsMicros = new FastArray(TimestampBufferMicros.class, null, 8, false);
    private final FastArray<Throwable> throwables = new FastArray(Throwable.class, null, 8, false);
    private long timestamp;
    private LogLevel level;
    private Throwable throwable;
    private LogSink sink;

    public static long getDifferenceInStartToEnds() {
        long e = ends.get();
        long s = starts.get();
        return s - e;
    }

    public LogOutput markEndOfHeader() {
        this.actions.add((Object)Action.END_OF_HEADER);
        return this;
    }

    public int getEndOfHeaderOffset() {
        return 0;
    }

    private void reset() {
        this.actions.quickReset();
        this.booleans.quickReset();
        this.chars.quickReset();
        this.shorts.quickReset();
        this.ints.quickReset();
        this.longs.quickReset();
        this.floats.quickReset();
        this.doubles.quickReset();
        this.sequences.normalReset();
        this.timestamps.normalReset();
        this.timestampsMicros.normalReset();
        this.throwables.normalReset();
    }

    public DelayedLogEntryImpl(LoggerTimeSource timeSource) {
        this.timeSource = timeSource;
        this.timestamp = timeSource.currentTimeMicros();
        this.sink = null;
    }

    @Override
    public LogEntry start(LogSink sink, LogLevel level) {
        return this.start(sink, level, this.timeSource.currentTimeMicros());
    }

    @Override
    public LogEntry start(LogSink sink, LogLevel level, long currentTimeMicros) {
        return this.start(sink, level, currentTimeMicros, null);
    }

    @Override
    public LogEntry start(LogSink sink, LogLevel level, long currentTimeMicros, Throwable t) {
        starts.getAndIncrement();
        this.timestamp = currentTimeMicros;
        this.level = level;
        this.throwable = t;
        this.sink = sink;
        return this;
    }

    @Override
    public void end() {
        this.sink.write(this);
        ends.getAndIncrement();
    }

    @Override
    public void endl() {
        this.nl();
        this.end();
    }

    @Override
    public long getTimestampMicros() {
        return this.timestamp;
    }

    @Override
    public LogLevel getLevel() {
        return this.level;
    }

    @Override
    public Throwable getThrowable() {
        return this.throwable;
    }

    @Override
    public LogOutput writing(LogOutput outputBuffer) {
        outputBuffer.start();
        this.pushToDelegate(outputBuffer);
        outputBuffer.close();
        return outputBuffer;
    }

    @Override
    public void written(LogOutput outputBuffer) {
        outputBuffer.clear();
        this.reset();
    }

    @Override
    public LogEntry append(boolean b) {
        this.actions.add((Object)Action.APPEND_BOOLEAN);
        this.booleans.add(b);
        return this;
    }

    @Override
    public LogEntry append(char c) {
        this.actions.add((Object)Action.APPEND_CHAR);
        this.chars.add(c);
        return this;
    }

    @Override
    public LogEntry append(short s) {
        this.actions.add((Object)Action.APPEND_SHORT);
        this.shorts.add(s);
        return this;
    }

    @Override
    public LogEntry append(int i) {
        this.actions.add((Object)Action.APPEND_INT);
        this.ints.add(i);
        return this;
    }

    @Override
    public LogEntry append(long l) {
        this.actions.add((Object)Action.APPEND_LONG);
        this.longs.add(l);
        return this;
    }

    @Override
    public LogEntry appendDouble(double f) {
        this.actions.add((Object)Action.APPEND_DOUBLE);
        this.doubles.add(f);
        return this;
    }

    @Override
    public LogEntry append(LogOutputAppendable appendable) {
        if (appendable == null) {
            this.actions.add((Object)Action.APPEND_NULL);
        } else {
            appendable.append((LogOutput)this);
        }
        return this;
    }

    @Override
    public LogEntry append(LogOutput.LongFormatter formatter, long n) {
        formatter.format((LogOutput)this, n);
        return this;
    }

    @Override
    public <T> LogEntry append(LogOutput.ObjFormatter<T> objFormatter, T t) {
        objFormatter.format((LogOutput)this, t);
        return this;
    }

    @Override
    public <T> LogEntry append(LogOutput.ObjIntIntFormatter<T> objFormatter, T t, int nOffset, int nLength) {
        objFormatter.format((LogOutput)this, t, nOffset, nLength);
        return this;
    }

    @Override
    public <T, U> LogEntry append(LogOutput.ObjObjFormatter<T, U> objObjFormatter, T t, U u) {
        objObjFormatter.format((LogOutput)this, t, u);
        return this;
    }

    @Override
    public LogEntry append(CharSequence seq) {
        if (seq == null) {
            this.actions.add((Object)Action.APPEND_NULL);
        } else {
            this.actions.add((Object)Action.APPEND_CHARSEQ);
            this.sequences.add((Object)seq);
        }
        return this;
    }

    @Override
    public LogEntry append(CharSequence seq, int start, int length) {
        if (seq == null) {
            this.actions.add((Object)Action.APPEND_NULL);
        } else {
            this.actions.add((Object)Action.APPEND_CHARSEQ_RANGE);
            this.sequences.add((Object)seq);
            this.ints.add(start);
            this.ints.add(length);
        }
        return this;
    }

    @Override
    public LogEntry append(ByteBuffer bb) {
        if (bb == null) {
            this.actions.add((Object)Action.APPEND_NULL);
        } else {
            int pos = bb.position();
            int limit = bb.limit();
            for (int i = pos; i < limit; ++i) {
                this.actions.add((Object)Action.APPEND_CHAR);
                this.chars.add((char)bb.get(i));
            }
        }
        return this;
    }

    @Override
    public LogEntry appendTimestamp(long utcMillis, TimestampBuffer tb) {
        this.actions.add((Object)Action.APPEND_TIMESTAMP);
        this.longs.add(utcMillis);
        this.timestamps.add((Object)tb);
        return this;
    }

    @Override
    public LogEntry appendTimestampMicros(long utcMicros, TimestampBufferMicros tb) {
        this.actions.add((Object)Action.APPEND_TIMESTAMP_MICROS);
        this.longs.add(utcMicros);
        this.timestampsMicros.add((Object)tb);
        return this;
    }

    @Override
    public LogEntry append(Throwable t) {
        this.actions.add((Object)Action.APPEND_THROWABLE);
        this.throwables.add((Object)t);
        return this;
    }

    @Override
    public LogEntry append(byte[] ba) {
        for (byte baValue : ba) {
            this.actions.add((Object)Action.APPEND_CHAR);
            this.chars.add((char)baValue);
        }
        return this;
    }

    @Override
    public LogEntry append(byte[] ba, int pos, int length) {
        for (int i = pos; i < pos + length; ++i) {
            this.actions.add((Object)Action.APPEND_CHAR);
            this.chars.add((char)ba[i]);
        }
        return this;
    }

    @Override
    public LogEntry append(byte[] ba, byte terminator) {
        for (int i = 0; i < ba.length && ba[i] != terminator; ++i) {
            this.actions.add((Object)Action.APPEND_CHAR);
            this.chars.add((char)ba[i]);
        }
        return this;
    }

    @Override
    public LogEntry nf() {
        this.actions.add((Object)Action.NF);
        return this;
    }

    @Override
    public LogEntry nl() {
        this.actions.add((Object)Action.NL);
        return this;
    }

    private void pushToDelegate(LogOutput logOutputBuffer) {
        int booleanPosition = 0;
        int charPosition = 0;
        int shortPosition = 0;
        int intPosition = 0;
        int longPosition = 0;
        int floatPosition = 0;
        int doublePosition = 0;
        int seqPosition = 0;
        int timePosition = 0;
        int timeMicrosPosition = 0;
        int throwablePosition = 0;
        Action[] as = (Action[])this.actions.getUnsafeArray();
        boolean[] bs = this.booleans.getUnsafeArray();
        char[] cs = this.chars.getUnsafeArray();
        short[] ss = this.shorts.getUnsafeArray();
        int[] is = this.ints.getUnsafeArray();
        long[] ls = this.longs.getUnsafeArray();
        float[] fs = this.floats.getUnsafeArray();
        double[] ds = this.doubles.getUnsafeArray();
        CharSequence[] seqs = (CharSequence[])this.sequences.getUnsafeArray();
        TimestampBuffer[] times = (TimestampBuffer[])this.timestamps.getUnsafeArray();
        TimestampBufferMicros[] timesMicros = (TimestampBufferMicros[])this.timestampsMicros.getUnsafeArray();
        Throwable[] throwables = (Throwable[])this.throwables.getUnsafeArray();
        int numActions = this.actions.getLength();
        block17: for (int actionPosition = 0; actionPosition < numActions; ++actionPosition) {
            switch (as[actionPosition].ordinal()) {
                case 0: {
                    logOutputBuffer = logOutputBuffer.append(bs[booleanPosition++]);
                    continue block17;
                }
                case 1: {
                    logOutputBuffer = logOutputBuffer.append(cs[charPosition++]);
                    continue block17;
                }
                case 2: {
                    logOutputBuffer = logOutputBuffer.append(ss[shortPosition++]);
                    continue block17;
                }
                case 3: {
                    logOutputBuffer = logOutputBuffer.append(is[intPosition++]);
                    continue block17;
                }
                case 4: {
                    logOutputBuffer = logOutputBuffer.append(ls[longPosition++]);
                    continue block17;
                }
                case 5: {
                    logOutputBuffer = logOutputBuffer.appendDouble(ds[doublePosition++]);
                    continue block17;
                }
                case 6: {
                    logOutputBuffer = logOutputBuffer.append(seqs[seqPosition++]);
                    continue block17;
                }
                case 7: {
                    logOutputBuffer = logOutputBuffer.append(seqs[seqPosition++], is[intPosition++], is[intPosition++]);
                    continue block17;
                }
                case 8: {
                    logOutputBuffer = logOutputBuffer.appendTimestamp(ls[longPosition++], times[timePosition++]);
                    continue block17;
                }
                case 13: {
                    logOutputBuffer = logOutputBuffer.appendTimestampMicros(ls[longPosition++], timesMicros[timeMicrosPosition++]);
                    continue block17;
                }
                case 9: {
                    logOutputBuffer = logOutputBuffer.append((LogOutputAppendable)null);
                    continue block17;
                }
                case 10: {
                    logOutputBuffer = logOutputBuffer.append(throwables[throwablePosition++]);
                    continue block17;
                }
                case 11: {
                    logOutputBuffer = logOutputBuffer.nf();
                    continue block17;
                }
                case 12: {
                    logOutputBuffer = logOutputBuffer.nl();
                    continue block17;
                }
                case 14: {
                    logOutputBuffer.markEndOfHeader();
                    continue block17;
                }
                default: {
                    throw Assert.statementNeverExecuted((String)("Unexpected action: " + (Object)((Object)as[actionPosition])));
                }
            }
        }
        Assert.eq((int)booleanPosition, (String)"booleanPosition", (int)this.booleans.getLength());
        Assert.eq((int)charPosition, (String)"charPosition", (int)this.chars.getLength());
        Assert.eq((int)shortPosition, (String)"shortPosition", (int)this.shorts.getLength());
        Assert.eq((int)intPosition, (String)"intPosition", (int)this.ints.getLength());
        Assert.eq((int)longPosition, (String)"longPosition", (int)this.longs.getLength());
        Assert.eq((int)floatPosition, (String)"floatPosition", (int)this.floats.getLength());
        Assert.eq((int)doublePosition, (String)"doublePosition", (int)this.doubles.getLength());
        Assert.eq((int)seqPosition, (String)"seqPosition", (int)this.sequences.getLength());
        Assert.eq((int)timePosition, (String)"timePosition", (int)this.timestamps.getLength());
        Assert.eq((int)timeMicrosPosition, (String)"timePosition", (int)this.timestampsMicros.getLength());
    }

    public int relativeSize() {
        return this.actions.getLength();
    }

    public LogOutput start() {
        throw Assert.statementNeverExecuted((String)"Not implemented");
    }

    public LogOutput close() {
        throw Assert.statementNeverExecuted((String)"Not implemented");
    }

    public int size() {
        throw Assert.statementNeverExecuted((String)"Not implemented");
    }

    public int getBufferCount() {
        throw Assert.statementNeverExecuted((String)"Not implemented");
    }

    public ByteBuffer getBuffer(int i) {
        throw Assert.statementNeverExecuted((String)"Not implemented");
    }

    public LogEntry clear() {
        throw Assert.statementNeverExecuted((String)"Not implemented");
    }

    private static enum Action {
        APPEND_BOOLEAN,
        APPEND_CHAR,
        APPEND_SHORT,
        APPEND_INT,
        APPEND_LONG,
        APPEND_DOUBLE,
        APPEND_CHARSEQ,
        APPEND_CHARSEQ_RANGE,
        APPEND_TIMESTAMP,
        APPEND_NULL,
        APPEND_THROWABLE,
        NF,
        NL,
        APPEND_TIMESTAMP_MICROS,
        END_OF_HEADER;

    }
}

