/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.io.log.impl;

import io.deephaven.base.ArrayUtil;
import io.deephaven.base.log.LogOutput;
import io.deephaven.base.log.LogOutputAppendable;
import io.deephaven.base.pool.Pool;
import io.deephaven.base.text.TimestampBuffer;
import io.deephaven.base.text.TimestampBufferMicros;
import io.deephaven.base.verify.Assert;
import io.deephaven.io.log.LogEntry;
import io.deephaven.io.log.LogLevel;
import io.deephaven.io.log.LogSink;
import io.deephaven.io.streams.ByteBufferStreams;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class DelayedLogEntryImpl2
implements LogEntry {
    private static final byte APPEND_BOOLEAN = 0;
    private static final byte APPEND_CHAR = 1;
    private static final byte APPEND_SHORT = 2;
    private static final byte APPEND_INT = 3;
    private static final byte APPEND_LONG = 5;
    private static final byte APPEND_DOUBLE = 11;
    private static final byte APPEND_CHARSEQ = 13;
    private static final byte APPEND_CHARSEQ_RANGE = 14;
    private static final byte APPEND_BYTES = 15;
    private static final byte APPEND_TIMESTAMP = 16;
    private static final byte APPEND_NULL = 17;
    private static final byte APPEND_THROWABLE = 18;
    private static final byte NF = 19;
    private static final byte NL = 20;
    private static final byte APPEND_TIMESTAMP_MICROS = 21;
    private static final byte END_OF_HEADER = 22;
    private final Pool<ByteBuffer> bufferPool;
    private ByteBuffer[] buffers = new ByteBuffer[4];
    private int bufferPtr = 0;
    private final ByteBufferStreams.Sink SINK = new ByteBufferStreams.Sink(){

        @Override
        public ByteBuffer acceptBuffer(ByteBuffer b, int need) throws IOException {
            b.flip();
            DelayedLogEntryImpl2.access$002(DelayedLogEntryImpl2.this, (ByteBuffer[])ArrayUtil.put((Object[])DelayedLogEntryImpl2.this.buffers, (int)DelayedLogEntryImpl2.this.bufferPtr++, (Object)b, ByteBuffer.class));
            return (ByteBuffer)DelayedLogEntryImpl2.this.bufferPool.take();
        }

        @Override
        public void close(ByteBuffer b) throws IOException {
            DelayedLogEntryImpl2.access$002(DelayedLogEntryImpl2.this, (ByteBuffer[])ArrayUtil.put((Object[])DelayedLogEntryImpl2.this.buffers, (int)DelayedLogEntryImpl2.this.bufferPtr++, (Object)b, ByteBuffer.class));
        }
    };
    private final ByteBufferStreams.Source SOURCE = new ByteBufferStreams.Source(){

        @Override
        public ByteBuffer nextBuffer(ByteBuffer lastBuffer) {
            if (lastBuffer != null) {
                DelayedLogEntryImpl2.this.bufferPool.give((Object)lastBuffer);
            }
            ByteBuffer b = null;
            if (DelayedLogEntryImpl2.this.bufferPtr < DelayedLogEntryImpl2.this.buffers.length && (b = DelayedLogEntryImpl2.this.buffers[DelayedLogEntryImpl2.this.bufferPtr++]) != null) {
                ((DelayedLogEntryImpl2)DelayedLogEntryImpl2.this).buffers[((DelayedLogEntryImpl2)DelayedLogEntryImpl2.this).bufferPtr - 1] = null;
            }
            return b;
        }
    };
    private final ByteBufferStreams.Output primitiveWriter = new ByteBufferStreams.Output(null, this.SINK);
    private Object[] objects = null;
    private int objectsPtr = 0;
    private int numActions = 0;
    private final ByteBufferStreams.Input primitiveReader = new ByteBufferStreams.Input(null, this.SOURCE);
    private long timestamp;
    private LogLevel level;
    private Throwable throwable;
    private LogSink logSink;

    public LogOutput markEndOfHeader() {
        try {
            this.primitiveWriter.writeByte(22);
            ++this.numActions;
        }
        catch (IOException x) {
            throw new UncheckedIOException(x);
        }
        return this;
    }

    public int getEndOfHeaderOffset() {
        return 0;
    }

    private void reset() {
        this.primitiveWriter.setBuffer((ByteBuffer)this.bufferPool.take());
        this.bufferPtr = 0;
        Arrays.fill(this.objects, 0, this.objectsPtr, null);
        this.objectsPtr = 0;
        this.numActions = 0;
    }

    public DelayedLogEntryImpl2(Pool<ByteBuffer> bufferPool) {
        this.bufferPool = bufferPool;
        this.timestamp = System.currentTimeMillis() * 1000L;
        this.logSink = null;
    }

    @Override
    public LogEntry start(LogSink logSink, LogLevel level) {
        return this.start(logSink, level, System.currentTimeMillis());
    }

    @Override
    public LogEntry start(LogSink logSink, LogLevel level, long currentTimeMicros) {
        return this.start(logSink, level, currentTimeMicros, null);
    }

    @Override
    public LogEntry start(LogSink logSink, LogLevel level, long currentTimeMicros, Throwable t) {
        this.timestamp = currentTimeMicros;
        this.level = level;
        this.throwable = t;
        this.logSink = logSink;
        return this;
    }

    @Override
    public void end() {
        this.logSink.write(this);
    }

    @Override
    public void endl() {
        this.nl();
        this.end();
    }

    @Override
    public long getTimestampMicros() {
        return this.timestamp;
    }

    @Override
    public LogLevel getLevel() {
        return this.level;
    }

    @Override
    public Throwable getThrowable() {
        return this.throwable;
    }

    @Override
    public LogOutput writing(LogOutput outputBuffer) {
        outputBuffer.start();
        this.pushToDelegate(outputBuffer);
        outputBuffer.close();
        return outputBuffer;
    }

    @Override
    public void written(LogOutput outputBuffer) {
        outputBuffer.clear();
        this.reset();
    }

    @Override
    public LogEntry append(boolean b) {
        try {
            this.primitiveWriter.writeByte(0);
            this.primitiveWriter.writeBoolean(b);
            ++this.numActions;
        }
        catch (IOException x) {
            throw new UncheckedIOException(x);
        }
        return this;
    }

    @Override
    public LogEntry append(char c) {
        try {
            this.primitiveWriter.writeByte(1);
            this.primitiveWriter.writeChar(c);
            ++this.numActions;
        }
        catch (IOException x) {
            throw new UncheckedIOException(x);
        }
        return this;
    }

    @Override
    public LogEntry append(short s) {
        try {
            this.primitiveWriter.writeByte(2);
            this.primitiveWriter.writeChar(s);
            ++this.numActions;
        }
        catch (IOException x) {
            throw new UncheckedIOException(x);
        }
        return this;
    }

    @Override
    public LogEntry append(int i) {
        try {
            this.primitiveWriter.writeByte(3);
            this.primitiveWriter.writeInt(i);
            ++this.numActions;
        }
        catch (IOException x) {
            throw new UncheckedIOException(x);
        }
        return this;
    }

    @Override
    public LogEntry append(long l) {
        try {
            this.primitiveWriter.writeByte(5);
            this.primitiveWriter.writeLong(l);
            ++this.numActions;
        }
        catch (IOException x) {
            throw new UncheckedIOException(x);
        }
        return this;
    }

    @Override
    public LogEntry appendDouble(double f) {
        try {
            this.primitiveWriter.writeByte(11);
            this.primitiveWriter.writeDouble(f);
            ++this.numActions;
        }
        catch (IOException x) {
            throw new UncheckedIOException(x);
        }
        return this;
    }

    @Override
    public LogEntry append(LogOutputAppendable appendable) {
        if (appendable == null) {
            try {
                this.primitiveWriter.writeByte(17);
                ++this.numActions;
            }
            catch (IOException x) {
                throw new UncheckedIOException(x);
            }
        } else {
            appendable.append((LogOutput)this);
        }
        return this;
    }

    @Override
    public LogEntry append(LogOutput.LongFormatter formatter, long n) {
        formatter.format((LogOutput)this, n);
        return this;
    }

    @Override
    public <T> LogEntry append(LogOutput.ObjFormatter<T> objFormatter, T t) {
        objFormatter.format((LogOutput)this, t);
        return this;
    }

    @Override
    public <T> LogEntry append(LogOutput.ObjIntIntFormatter<T> objFormatter, T t, int nOffset, int nLength) {
        objFormatter.format((LogOutput)this, t, nOffset, nLength);
        return this;
    }

    @Override
    public <T, U> LogEntry append(LogOutput.ObjObjFormatter<T, U> objObjFormatter, T t, U u) {
        objObjFormatter.format((LogOutput)this, t, u);
        return this;
    }

    @Override
    public LogEntry append(CharSequence seq) {
        if (seq == null) {
            try {
                this.primitiveWriter.writeByte(17);
                ++this.numActions;
            }
            catch (IOException x) {
                throw new UncheckedIOException(x);
            }
        }
        try {
            this.primitiveWriter.writeByte(13);
            this.objects = ArrayUtil.put((Object[])this.objects, (int)this.objectsPtr++, (Object)seq, Object.class);
            ++this.numActions;
        }
        catch (IOException x) {
            throw new UncheckedIOException(x);
        }
        return this;
    }

    @Override
    public LogEntry append(CharSequence seq, int start, int length) {
        if (seq == null) {
            try {
                this.primitiveWriter.writeByte(17);
                ++this.numActions;
            }
            catch (IOException x) {
                throw new UncheckedIOException(x);
            }
        }
        try {
            this.primitiveWriter.writeByte(13);
            this.objects = ArrayUtil.put((Object[])this.objects, (int)this.objectsPtr++, (Object)seq, Object.class);
            this.primitiveWriter.writeInt(start);
            this.primitiveWriter.writeInt(length);
            ++this.numActions;
        }
        catch (IOException x) {
            throw new UncheckedIOException(x);
        }
        return this;
    }

    @Override
    public LogEntry append(ByteBuffer bb) {
        if (bb == null) {
            try {
                this.primitiveWriter.writeByte(17);
            }
            catch (IOException x) {
                throw new UncheckedIOException(x);
            }
        }
        try {
            int pos = bb.position();
            this.primitiveWriter.writeByte(15);
            this.primitiveWriter.writeInt(bb.remaining());
            this.primitiveWriter.write(bb);
            bb.position(pos);
            ++this.numActions;
        }
        catch (IOException x) {
            throw new UncheckedIOException(x);
        }
        return this;
    }

    @Override
    public LogEntry appendTimestamp(long utcMillis, TimestampBuffer tb) {
        try {
            this.primitiveWriter.writeByte(16);
            this.primitiveWriter.writeLong(utcMillis);
            this.objects = ArrayUtil.put((Object[])this.objects, (int)this.objectsPtr++, (Object)tb, Object.class);
            ++this.numActions;
        }
        catch (IOException x) {
            throw new UncheckedIOException(x);
        }
        return this;
    }

    @Override
    public LogEntry appendTimestampMicros(long utcMicros, TimestampBufferMicros tb) {
        try {
            this.primitiveWriter.writeByte(21);
            this.primitiveWriter.writeLong(utcMicros);
            this.objects = ArrayUtil.put((Object[])this.objects, (int)this.objectsPtr++, (Object)tb, Object.class);
            ++this.numActions;
        }
        catch (IOException x) {
            throw new UncheckedIOException(x);
        }
        return this;
    }

    @Override
    public LogEntry append(Throwable t) {
        try {
            this.primitiveWriter.writeByte(18);
            this.objects = ArrayUtil.put((Object[])this.objects, (int)this.objectsPtr++, (Object)t, Object.class);
            ++this.numActions;
        }
        catch (IOException x) {
            throw new UncheckedIOException(x);
        }
        return this;
    }

    @Override
    public LogEntry append(byte[] ba) {
        try {
            this.primitiveWriter.writeByte(15);
            this.primitiveWriter.writeInt(ba.length);
            this.primitiveWriter.write(ba, 0, ba.length);
            ++this.numActions;
        }
        catch (IOException x) {
            throw new UncheckedIOException(x);
        }
        return this;
    }

    @Override
    public LogEntry append(byte[] ba, int pos, int length) {
        try {
            this.primitiveWriter.writeByte(15);
            this.primitiveWriter.writeInt(length);
            this.primitiveWriter.write(ba, pos, length);
            ++this.numActions;
        }
        catch (IOException x) {
            throw new UncheckedIOException(x);
        }
        return this;
    }

    @Override
    public LogEntry append(byte[] ba, byte terminator) {
        int n;
        for (n = 0; n < ba.length && ba[n] != terminator; ++n) {
        }
        return this.append(ba, 0, n);
    }

    @Override
    public LogEntry nf() {
        try {
            this.primitiveWriter.writeByte(19);
            ++this.numActions;
        }
        catch (IOException x) {
            throw new UncheckedIOException(x);
        }
        return this;
    }

    @Override
    public LogEntry nl() {
        try {
            this.primitiveWriter.writeByte(20);
            ++this.numActions;
        }
        catch (IOException x) {
            throw new UncheckedIOException(x);
        }
        return this;
    }

    private void pushToDelegate(LogOutput logOutputBuffer) {
        try {
            int action;
            this.primitiveWriter.close();
            this.primitiveReader.setBuffer(this.buffers[0]);
            this.bufferPtr = 1;
            this.objectsPtr = 0;
            block20: while ((action = this.primitiveReader.read()) != -1) {
                switch (action) {
                    case 0: {
                        logOutputBuffer = logOutputBuffer.append(this.primitiveReader.readBoolean());
                        continue block20;
                    }
                    case 1: {
                        logOutputBuffer = logOutputBuffer.append(this.primitiveReader.readChar());
                        continue block20;
                    }
                    case 2: {
                        logOutputBuffer = logOutputBuffer.append(this.primitiveReader.readShort());
                        continue block20;
                    }
                    case 3: {
                        logOutputBuffer = logOutputBuffer.append(this.primitiveReader.readInt());
                        continue block20;
                    }
                    case 5: {
                        logOutputBuffer = logOutputBuffer.append(this.primitiveReader.readLong());
                        continue block20;
                    }
                    case 11: {
                        logOutputBuffer = logOutputBuffer.appendDouble(this.primitiveReader.readDouble());
                        continue block20;
                    }
                    case 13: {
                        logOutputBuffer = logOutputBuffer.append((CharSequence)this.objects[this.objectsPtr++]);
                        continue block20;
                    }
                    case 14: {
                        CharSequence seq = (CharSequence)this.objects[this.objectsPtr++];
                        int pos = this.primitiveReader.readInt();
                        int length = this.primitiveReader.readInt();
                        logOutputBuffer = logOutputBuffer.append(seq, pos, length);
                        continue block20;
                    }
                    case 15: {
                        int n = this.primitiveReader.readInt();
                        for (int i = 0; i < n; ++i) {
                            logOutputBuffer = logOutputBuffer.append((char)this.primitiveReader.read());
                        }
                        continue block20;
                    }
                    case 16: {
                        TimestampBuffer tb = (TimestampBuffer)this.objects[this.objectsPtr++];
                        long utcMillis = this.primitiveReader.readLong();
                        logOutputBuffer = logOutputBuffer.appendTimestamp(utcMillis, tb);
                        continue block20;
                    }
                    case 21: {
                        TimestampBuffer tb = (TimestampBufferMicros)this.objects[this.objectsPtr++];
                        long utcMicros = this.primitiveReader.readLong();
                        logOutputBuffer = logOutputBuffer.appendTimestampMicros(utcMicros, (TimestampBufferMicros)tb);
                        continue block20;
                    }
                    case 17: {
                        logOutputBuffer = logOutputBuffer.append((LogOutputAppendable)null);
                        continue block20;
                    }
                    case 18: {
                        logOutputBuffer = logOutputBuffer.append((Throwable)this.objects[this.objectsPtr++]);
                        continue block20;
                    }
                    case 19: {
                        logOutputBuffer = logOutputBuffer.nf();
                        continue block20;
                    }
                    case 20: {
                        logOutputBuffer = logOutputBuffer.nl();
                        continue block20;
                    }
                    case 22: {
                        logOutputBuffer.markEndOfHeader();
                        continue block20;
                    }
                }
                throw Assert.statementNeverExecuted((String)("Unexpected action: " + action));
            }
        }
        catch (IOException x) {
            throw new UncheckedIOException(x);
        }
    }

    public int relativeSize() {
        return this.numActions;
    }

    public LogOutput start() {
        throw Assert.statementNeverExecuted((String)"Not implemented");
    }

    public LogOutput close() {
        throw Assert.statementNeverExecuted((String)"Not implemented");
    }

    public int size() {
        throw Assert.statementNeverExecuted((String)"Not implemented");
    }

    public int getBufferCount() {
        throw Assert.statementNeverExecuted((String)"Not implemented");
    }

    public ByteBuffer getBuffer(int i) {
        throw Assert.statementNeverExecuted((String)"Not implemented");
    }

    public LogEntry clear() {
        throw Assert.statementNeverExecuted((String)"Not implemented");
    }

    static /* synthetic */ ByteBuffer[] access$002(DelayedLogEntryImpl2 x0, ByteBuffer[] x1) {
        x0.buffers = x1;
        return x1;
    }
}

