/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.io.log.impl;

import io.deephaven.base.pool.ThreadSafeLenientFixedSizePool;
import io.deephaven.io.log.LogBufferPool;
import java.nio.ByteBuffer;

public class DynamicLogBufferPoolImpl
extends ThreadSafeLenientFixedSizePool<ByteBuffer>
implements LogBufferPool {
    public DynamicLogBufferPoolImpl(String name, int poolSize, int byteBufferCapacity) {
        super(name, poolSize, () -> ByteBuffer.allocate(byteBufferCapacity), null);
    }

    @Override
    public ByteBuffer take(int minSize) {
        ByteBuffer buffer = (ByteBuffer)this.take();
        if (buffer.capacity() < minSize) {
            buffer = ByteBuffer.allocate(minSize);
        }
        return buffer;
    }
}

