/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.io.log.impl;

import io.deephaven.base.log.LogOutput;
import io.deephaven.base.log.LogOutputAppendable;
import io.deephaven.base.text.TimestampBuffer;
import io.deephaven.base.text.TimestampBufferMicros;
import io.deephaven.io.log.LogBufferPool;
import io.deephaven.io.log.LogEntry;
import io.deephaven.io.log.LogLevel;
import io.deephaven.io.log.LogSink;
import io.deephaven.io.log.impl.LogOutputCsvImpl;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;

public class LogEntryImpl
extends LogOutputCsvImpl
implements LogEntry {
    private static final AtomicLong starts = new AtomicLong(0L);
    private static final AtomicLong ends = new AtomicLong(0L);
    private long timestamp = System.currentTimeMillis() * 1000L;
    private LogLevel level;
    private Throwable throwable;
    private LogSink sink = null;

    public static long getDifferenceInStartToEnds() {
        long e = ends.get();
        long s = starts.get();
        return s - e;
    }

    public LogEntryImpl(LogBufferPool bufferPool) {
        super(bufferPool);
    }

    @Override
    public LogEntry start(LogSink sink, LogLevel level) {
        return this.start(sink, level, System.currentTimeMillis() * 1000L);
    }

    @Override
    public LogEntry start(LogSink sink, LogLevel level, long currentTimeMicros) {
        return this.start(sink, level, currentTimeMicros, null);
    }

    @Override
    public LogEntry start(LogSink sink, LogLevel level, long currentTimeMicros, Throwable t) {
        super.start();
        starts.getAndIncrement();
        this.timestamp = currentTimeMicros;
        this.level = level;
        this.sink = sink;
        this.throwable = t;
        return this;
    }

    @Override
    public void end() {
        this.close();
        this.sink.write(this);
        ends.getAndIncrement();
    }

    @Override
    public void endl() {
        this.nl();
        this.end();
    }

    @Override
    public long getTimestampMicros() {
        return this.timestamp;
    }

    @Override
    public LogLevel getLevel() {
        return this.level;
    }

    @Override
    public Throwable getThrowable() {
        return this.throwable;
    }

    @Override
    public LogOutput writing(LogOutput outputBuffer) {
        return this;
    }

    @Override
    public void written(LogOutput outputBuffer) {
        super.clear();
    }

    @Override
    public LogEntry append(boolean b) {
        super.append(b);
        return this;
    }

    @Override
    public LogEntry append(char c) {
        super.append(c);
        return this;
    }

    @Override
    public LogEntry append(short s) {
        super.append(s);
        return this;
    }

    @Override
    public LogEntry append(int i) {
        super.append(i);
        return this;
    }

    @Override
    public LogEntry append(long l) {
        super.append(l);
        return this;
    }

    @Override
    public LogEntry appendDouble(double f) {
        super.appendDouble(f);
        return this;
    }

    @Override
    public LogEntry append(LogOutputAppendable appendable) {
        super.append(appendable);
        return this;
    }

    @Override
    public LogEntry append(LogOutput.LongFormatter formatter, long n) {
        super.append(formatter, n);
        return this;
    }

    @Override
    public <T> LogEntry append(LogOutput.ObjFormatter<T> objFormatter, T t) {
        super.append(objFormatter, t);
        return this;
    }

    @Override
    public <T> LogEntry append(LogOutput.ObjIntIntFormatter<T> objFormatter, T t, int nOffset, int nLength) {
        super.append(objFormatter, t, nOffset, nLength);
        return this;
    }

    @Override
    public <T, U> LogEntry append(LogOutput.ObjObjFormatter<T, U> objObjFormatter, T t, U u) {
        super.append(objObjFormatter, t, u);
        return this;
    }

    @Override
    public LogEntry append(CharSequence seq) {
        super.append(seq);
        return this;
    }

    @Override
    public LogEntry append(CharSequence seq, int start, int length) {
        super.append(seq, start, length);
        return this;
    }

    @Override
    public LogEntry append(ByteBuffer bb) {
        super.append(bb);
        return this;
    }

    @Override
    public LogEntry appendTimestamp(long utcMillis, TimestampBuffer tb) {
        super.appendTimestamp(utcMillis, tb);
        return this;
    }

    @Override
    public LogEntry appendTimestampMicros(long utcMicros, TimestampBufferMicros tb) {
        super.appendTimestampMicros(utcMicros, tb);
        return this;
    }

    @Override
    public LogEntry append(Throwable t) {
        super.append(t);
        return this;
    }

    @Override
    public LogEntry append(byte[] ba) {
        super.append(ba);
        return this;
    }

    @Override
    public LogEntry append(byte[] ba, int pos, int length) {
        super.append(ba, pos, length);
        return this;
    }

    @Override
    public LogEntry append(byte[] ba, byte terminator) {
        super.append(ba, terminator);
        return this;
    }

    @Override
    public LogEntry nf() {
        super.nf();
        return this;
    }

    @Override
    public LogEntry nl() {
        super.nl();
        return this;
    }
}

