/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.io.log.impl;

import io.deephaven.base.ArrayUtil;
import io.deephaven.base.ClassUtil;
import io.deephaven.base.LockFreeArrayQueue;
import io.deephaven.base.UnfairSemaphore;
import io.deephaven.base.log.LogOutput;
import io.deephaven.base.pool.Pool;
import io.deephaven.base.system.AsyncSystem;
import io.deephaven.base.system.PrintStreamGlobals;
import io.deephaven.base.verify.Assert;
import io.deephaven.io.log.LogSink;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;

public class LogSinkImpl<T extends LogSink.Element>
implements LogSink<T> {
    private static final int EXIT_STATUS = 1;
    private static LogSink.Factory _FACTORY = new LogSink.Factory(){

        public LogSink create(String basePath, int rollInterval, DateFormat rollFormat, Pool elementPool, boolean append, LogOutput outputBuffer, String header, LogSink.LogSinkWriter maybeWriter) {
            return new LogSinkImpl(basePath, rollInterval, rollFormat, elementPool, append, outputBuffer, header, maybeWriter);
        }
    };
    private final String basePath;
    private final long rollIntervalMicros;
    private final DateFormat rollFormat;
    private final Pool<T> elementPool;
    private final boolean append;
    private final LockFreeArrayQueue<T> outputQueue;
    private final LogOutput outputBuffer;
    private final String header;
    private LogSink.Interceptor<T>[] interceptors = null;
    private final boolean passedInWriter;
    private final LogSink.LogSinkWriter<LogSinkImpl<T>> writer;
    private final Thread writerThread;
    private long currentIntervalMicros;
    private String currentPath;
    private FileChannel outputFile;
    private Path linkPath;
    private boolean supportsLinks;
    private volatile boolean shutdown;
    private final UnfairSemaphore writtenOnShutdown;
    private static final int ENQUEUE_SPIN_COUNT = 10000;
    public static final int ROLL_INTERVAL = 3600000;
    public static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd-HHmmss.SSSZ");
    public static final BigWriterThread globalWriterThread = new BigWriterThread("LogSinkImpl.GlobalWriterThread", 1000000L);

    public static <T extends LogSink.Element> LogSink.Factory<T> FACTORY() {
        return _FACTORY;
    }

    public LogSinkImpl(String basePath, long rollIntervalMillis, Pool<T> elementPool) {
        this(basePath, rollIntervalMillis, DATE_FORMAT, elementPool, true, null, null);
    }

    public LogSinkImpl(String basePath, long rollIntervalMillis, Pool<T> elementPool, LogOutput outputBuffer) {
        this(basePath, rollIntervalMillis, DATE_FORMAT, elementPool, true, outputBuffer, null);
    }

    public LogSinkImpl(String basePath, long rollIntervalMillis, Pool<T> elementPool, boolean append) {
        this(basePath, rollIntervalMillis, DATE_FORMAT, elementPool, append, null, null);
    }

    public LogSinkImpl(String basePath, long rollIntervalMillis, Pool<T> elementPool, boolean append, LogOutput outputBuffer) {
        this(basePath, rollIntervalMillis, DATE_FORMAT, elementPool, append, outputBuffer, null);
    }

    public LogSinkImpl(String basePath, long rollIntervalMillis, DateFormat rollFormat, Pool<T> elementPool, boolean append) {
        this(basePath, rollIntervalMillis, rollFormat, elementPool, append, null, null);
    }

    public LogSinkImpl(String basePath, long rollIntervalMillis, DateFormat rollFormat, Pool<T> elementPool, boolean append, LogOutput outputBuffer, String header) {
        this(basePath, rollIntervalMillis, rollFormat, elementPool, append, outputBuffer, header, null);
    }

    public LogSinkImpl(String basePath, long rollIntervalMillis, DateFormat rollFormat, Pool<T> elementPool, boolean append, LogOutput outputBuffer, String header, LogSink.LogSinkWriter<LogSinkImpl<T>> maybeWriter) {
        this.basePath = basePath;
        this.rollIntervalMicros = rollIntervalMillis * 1000L;
        this.rollFormat = null == rollFormat ? null : (DateFormat)rollFormat.clone();
        this.elementPool = elementPool;
        this.append = append;
        this.outputQueue = new LockFreeArrayQueue(20);
        this.outputBuffer = outputBuffer;
        this.header = header;
        this.linkPath = new File(basePath + ".current").toPath();
        this.supportsLinks = !System.getProperty("os.name").toLowerCase().contains("win");
        this.currentIntervalMicros = 0L;
        this.currentPath = null;
        this.outputFile = null;
        this.shutdown = false;
        this.writtenOnShutdown = new UnfairSemaphore(1, 1000);
        this.writtenOnShutdown.acquire(1);
        boolean bl = this.passedInWriter = maybeWriter != null;
        if (this.passedInWriter) {
            this.writer = maybeWriter;
            this.writer.addLogSink(this);
        } else {
            WriterThread thread = new WriterThread("LogSinkImpl.WriterThread-" + basePath);
            thread.setDaemon(true);
            this.writer = thread;
            this.writer.addLogSink(this);
        }
        this.writerThread = (Thread)((Object)this.writer);
        LogSink.Shutdown.addSink(this);
    }

    public String toString() {
        return "LogSinkImpl(" + this.basePath + ")";
    }

    @Override
    public void write(T e) {
        if (this.shutdown) {
            return;
        }
        int spins = 0;
        while (!this.outputQueue.enqueue(e)) {
            if (this.shutdown) {
                return;
            }
            if (++spins <= 10000) continue;
            LockSupport.unpark(this.writerThread);
            Thread.yield();
            spins = 0;
        }
        if (!this.passedInWriter) {
            LockSupport.unpark(this.writerThread);
        }
    }

    private void notifyShutdownWritten() {
        this.writtenOnShutdown.release(1);
    }

    @Override
    public void shutdown() {
        this.shutdown = true;
        LockSupport.unpark(this.writerThread);
        this.writtenOnShutdown.acquire(1);
        this.writtenOnShutdown.release(1);
    }

    @Override
    public void terminate() {
        this.shutdown = true;
        this.writtenOnShutdown.release(1);
    }

    @Override
    public void addInterceptor(LogSink.Interceptor<T> interceptor) {
        this.interceptors = (LogSink.Interceptor[])ArrayUtil.pushArray(interceptor, (Object[])this.interceptors, (Class)ClassUtil.generify(LogSink.Interceptor.class));
    }

    private boolean isOpenAfterWrite() throws IOException {
        while (this.didWrite()) {
        }
        return this.isOpen();
    }

    private boolean isOpen() throws IOException {
        if (this.shutdown) {
            if (this.outputFile != null) {
                this.outputFile.close();
            }
            return false;
        }
        return true;
    }

    private boolean didWrite() throws IOException {
        LogSink.Element e = (LogSink.Element)this.outputQueue.dequeue();
        if (e == null) {
            return false;
        }
        this.writeOut(e);
        return true;
    }

    private void writeOut(T e) throws IOException {
        this.checkOutputFile(e.getTimestampMicros());
        LogOutput outputData = e.writing(this.outputBuffer);
        if (null != e.getThrowable()) {
            outputData.append(e.getThrowable());
        }
        this.flushOutput(e, outputData);
        e.written(outputData);
        this.elementPool.give(e);
    }

    private void checkOutputFile(long nowMicros) throws IOException {
        boolean updateLink = false;
        if (this.outputFile == null) {
            this.currentIntervalMicros = nowMicros - (this.rollIntervalMicros == 0L ? 0L : nowMicros % this.rollIntervalMicros);
            this.currentPath = this.stampedOutputFilePath(nowMicros);
            this.outputFile = new FileOutputStream(this.currentPath, this.append).getChannel();
            this.writeHeader();
            updateLink = true;
        } else if (this.rollIntervalMicros > 0L && nowMicros > this.currentIntervalMicros + this.rollIntervalMicros) {
            this.outputFile.close();
            this.currentIntervalMicros = nowMicros - nowMicros % this.rollIntervalMicros;
            this.currentPath = this.stampedOutputFilePath(this.currentIntervalMicros);
            this.outputFile = new FileOutputStream(this.currentPath, this.append).getChannel();
            this.writeHeader();
            updateLink = true;
        }
        if (updateLink && this.supportsLinks) {
            try {
                Files.deleteIfExists(this.linkPath);
                Files.createLink(this.linkPath, new File(this.currentPath).toPath());
            }
            catch (UnsupportedOperationException x) {
                this.supportsLinks = false;
            }
        }
    }

    private String stampedOutputFilePath(long nowMicros) {
        return this.rollFormat == null ? this.basePath : this.basePath + "." + this.rollFormat.format(new Date(nowMicros / 1000L));
    }

    private void writeHeader() throws IOException {
        if (this.header != null) {
            this.outputBuffer.start().append((CharSequence)this.header).nl().close();
            this.flushOutput(null, this.outputBuffer);
            this.outputBuffer.clear();
        }
    }

    private void flushOutput(T e, LogOutput data) throws IOException {
        LogSink.Interceptor<T>[] localInterceptors;
        int i;
        int n = data.getBufferCount();
        for (i = 0; i < n; ++i) {
            ByteBuffer b = data.getBuffer(i);
            b.flip();
        }
        if (e != null && (localInterceptors = this.interceptors) != null) {
            for (int i2 = 0; i2 < localInterceptors.length; ++i2) {
                localInterceptors[i2].element(e, data);
            }
        }
        for (i = 0; i < n; ++i) {
            ByteBuffer b = data.getBuffer(i);
            while (b.remaining() > 0 && this.outputFile.write(b) != 0) {
            }
        }
    }

    private class WriterThread<T extends LogSink.Element>
    extends Thread
    implements LogSink.LogSinkWriter<LogSinkImpl<T>> {
        private final AtomicBoolean started;
        private final PrintStream err;

        private WriterThread(String name) {
            super(name);
            this.started = new AtomicBoolean(false);
            this.err = PrintStreamGlobals.getErr();
        }

        @Override
        public void addLogSink(LogSinkImpl<T> sink) {
            Assert.eq(sink, (String)"sink", (Object)LogSinkImpl.this);
            if (this.started.compareAndSet(false, true)) {
                this.start();
            }
        }

        @Override
        public void run() {
            try {
                this.started.set(true);
                while (LogSinkImpl.this.isOpenAfterWrite()) {
                    LockSupport.park(this);
                }
                LogSinkImpl.this.notifyShutdownWritten();
            }
            catch (Throwable t) {
                try {
                    LogSinkImpl.this.terminate();
                }
                catch (Throwable t2) {
                    t.addSuppressed(t2);
                }
                finally {
                    AsyncSystem.exitCaught((Thread)this, (Throwable)t, (int)1, (PrintStream)this.err, (String)"LogSinkImpl: unable to write log entry");
                }
            }
        }
    }

    public static class BigWriterThread
    extends Thread
    implements LogSink.LogSinkWriter<LogSinkImpl<?>> {
        private final LockFreeArrayQueue<LogSinkImpl<? extends LogSink.Element>> toWriteOut;
        private final UnfairSemaphore semaphoreEntries;
        private final AtomicBoolean started;
        private final long parkNanos;
        private final PrintStream err;

        private BigWriterThread(String name, long parkNanos) {
            super(name);
            this.parkNanos = parkNanos;
            this.toWriteOut = new LockFreeArrayQueue(14);
            this.semaphoreEntries = new UnfairSemaphore(0, 1000);
            this.started = new AtomicBoolean(false);
            this.err = PrintStreamGlobals.getErr();
        }

        @Override
        public void addLogSink(LogSinkImpl<?> impl) {
            Assert.eqTrue((boolean)this.toWriteOut.enqueue(impl), (String)"toWriteOut.add(impl)");
            this.semaphoreEntries.release(1);
            if (this.started.compareAndSet(false, true)) {
                this.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.started.set(true);
            this.waitForSomeEntries();
            int spinsSinceLastChange = 0;
            while (true) {
                LogSinkImpl impl = (LogSinkImpl)this.toWriteOut.dequeue();
                Assert.neqNull((Object)impl, (String)"impl");
                try {
                    if (impl.didWrite()) {
                        spinsSinceLastChange = 0;
                        Assert.eqTrue((boolean)this.toWriteOut.enqueue((Object)impl), (String)"toWriteOut.enqueue(impl)");
                    } else if (impl.isOpen()) {
                        Assert.eqTrue((boolean)this.toWriteOut.enqueue((Object)impl), (String)"toWriteOut.enqueue(impl)");
                    } else {
                        spinsSinceLastChange = 0;
                        impl.notifyShutdownWritten();
                        Assert.eqTrue((boolean)this.semaphoreEntries.tryAcquire(1), (String)"semaphore.tryAcquire(1)");
                        this.waitForSomeEntries();
                    }
                    if (++spinsSinceLastChange <= 2 * this.semaphoreEntries.availablePermits()) continue;
                    spinsSinceLastChange = 0;
                    LockSupport.parkNanos(this, this.parkNanos);
                }
                catch (Throwable t) {
                    try {
                        this.terminateAll(impl);
                    }
                    catch (Throwable t2) {
                        t.addSuppressed(t2);
                    }
                    finally {
                        AsyncSystem.exitCaught((Thread)this, (Throwable)t, (int)1, (PrintStream)this.err, (String)"LogSinkImpl: unable to write log entry");
                    }
                    return;
                }
            }
        }

        private void terminateAll(LogSinkImpl<? extends LogSink.Element> impl) {
            impl.terminate();
            while ((impl = (LogSinkImpl)this.toWriteOut.dequeue()) != null) {
                impl.terminate();
            }
        }

        private void waitForSomeEntries() {
            this.semaphoreEntries.acquire(1);
            this.semaphoreEntries.release(1);
        }
    }
}

