/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.io.logger;

import io.deephaven.base.verify.Assert;
import io.deephaven.io.log.LogLevel;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class LogBufferRecord
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private long timestampMicros;
    private LogLevel level;
    private ByteBuffer data;

    public long getTimestampMicros() {
        return this.timestampMicros;
    }

    public void setTimestampMicros(long timestampMicros) {
        this.timestampMicros = timestampMicros;
    }

    public LogLevel getLevel() {
        return this.level;
    }

    public void setLevel(LogLevel level) {
        this.level = level;
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public void setData(ByteBuffer data) {
        Assert.assertion((boolean)data.hasArray(), (String)"data.hasArray()");
        this.data = data;
    }

    public LogBufferRecord deepCopy() {
        LogBufferRecord copy = new LogBufferRecord();
        copy.setTimestampMicros(this.timestampMicros);
        copy.setLevel(this.level);
        copy.setData(ByteBuffer.wrap(Arrays.copyOfRange(this.data.array(), this.data.position() + this.data.arrayOffset(), this.data.limit() + this.data.arrayOffset())));
        return copy;
    }

    @Override
    public void readExternal(@NotNull ObjectInput in) throws IOException, ClassNotFoundException {
        this.timestampMicros = in.readLong();
        this.level = LogLevel.valueOf(in.readUTF());
        byte[] dataArray = new byte[in.readInt()];
        in.readFully(dataArray);
        this.data = ByteBuffer.wrap(dataArray);
    }

    @Override
    public void writeExternal(@NotNull ObjectOutput out) throws IOException {
        out.writeLong(this.timestampMicros);
        out.writeUTF(this.level.getName());
        out.writeInt(this.data.remaining());
        out.write(this.data.array(), this.data.position() + this.data.arrayOffset(), this.data.remaining());
    }

    public String getDataString() {
        this.getData().mark();
        try {
            String string = StandardCharsets.ISO_8859_1.newDecoder().decode(this.getData()).toString();
            return string;
        }
        catch (CharacterCodingException e) {
            throw new IllegalStateException("Failed to decode log data to a string", e);
        }
        finally {
            this.getData().reset();
        }
    }
}

