/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.io.logger;

import io.deephaven.base.text.TimestampBufferMicros;
import io.deephaven.io.log.LogEntry;
import io.deephaven.io.log.LogEntryPool;
import io.deephaven.io.log.LogLevel;
import io.deephaven.io.log.LogSink;
import io.deephaven.io.logger.Logger;
import io.deephaven.io.logger.LoggerTimeSource;
import java.util.TimeZone;
import org.jetbrains.annotations.Nullable;

public class LoggerImpl
implements Logger {
    protected static final LogEntry EMPTY_LOG_ENTRY = LogEntry.NULL;
    protected final LogEntryPool logEntryPool;
    protected final LogSink logSink;
    protected final String name;
    protected final TimeZone tz;
    protected final LoggerTimeSource timeSource;
    protected TimestampBufferMicros localTimestamp;
    protected LogLevel loggingLevel;
    protected final boolean showLevel;
    protected final boolean showThreadName;
    private static final ThreadLocal<String> THREAD_NAME = new ThreadLocal<String>(){
        private String threadName;

        @Override
        protected String initialValue() {
            this.threadName = Thread.currentThread().getName();
            return this.threadName;
        }
    };

    public LoggerImpl(LogEntryPool logEntryPool, LogSink logSink, String prefix, LogLevel loggingLevel, LoggerTimeSource timeSource, TimeZone tz, boolean showLevel, boolean showThreadName) {
        this.logEntryPool = logEntryPool;
        this.logSink = logSink;
        this.name = prefix;
        this.timeSource = timeSource;
        this.tz = tz;
        this.localTimestamp = tz == null ? null : new TimestampBufferMicros(tz);
        this.showLevel = showLevel;
        this.showThreadName = showThreadName;
        this.loggingLevel = loggingLevel;
    }

    @Override
    public void shutdown() {
        this.logSink.shutdown();
        this.logEntryPool.shutdown();
    }

    @Override
    public LogEntry getEntry(LogLevel level) {
        return this.getEntry(level, this.timeSource.currentTimeMicros(), null);
    }

    @Override
    public LogEntry getEntry(LogLevel level, Throwable t) {
        return this.getEntry(level, this.timeSource.currentTimeMicros(), t);
    }

    @Override
    public LogEntry getEntry(LogLevel level, long currentTimeMicros) {
        return this.getEntry(level, currentTimeMicros, null);
    }

    @Override
    public LogEntry getEntry(LogLevel level, long currentTimeMicros, @Nullable Throwable t) {
        if (!this.isLevelEnabled(level)) {
            return EMPTY_LOG_ENTRY;
        }
        LogEntry entry = ((LogEntry)this.logEntryPool.take()).start(this.logSink, level, currentTimeMicros, t);
        if (this.tz != null) {
            entry.append("[").appendTimestampMicros(entry.getTimestampMicros(), this.localTimestamp).append("] ");
        }
        if (this.showLevel) {
            entry.append("- ").append(level.toString()).append(" ");
        }
        if (this.name != null) {
            entry.append("- ").append(this.name).append(" ");
        }
        if (this.showThreadName) {
            entry.append("- ").append(THREAD_NAME.get()).append(" ");
        }
        if (this.tz != null || this.showLevel || this.name != null || this.showThreadName) {
            entry.append("- ");
        }
        entry.markEndOfHeader();
        return entry;
    }

    @Override
    public void setLevel(LogLevel level) {
        this.loggingLevel = level;
    }

    @Override
    public LogSink getSink() {
        return this.logSink;
    }

    @Override
    public boolean isLevelEnabled(LogLevel level) {
        return this.loggingLevel.getPriority() <= level.getPriority();
    }

    @Override
    public LogEntry fatal() {
        return this.getEntry(LogLevel.FATAL);
    }

    @Override
    public LogEntry error() {
        return this.getEntry(LogLevel.ERROR);
    }

    @Override
    public LogEntry warn() {
        return this.getEntry(LogLevel.WARN);
    }

    @Override
    public LogEntry info() {
        return this.getEntry(LogLevel.INFO);
    }

    @Override
    public LogEntry debug() {
        return this.getEntry(LogLevel.DEBUG);
    }

    @Override
    public LogEntry trace() {
        return this.getEntry(LogLevel.TRACE);
    }

    @Override
    public LogEntry email() {
        return this.getEntry(LogLevel.EMAIL);
    }

    @Override
    public LogEntry fatal(Throwable t) {
        return this.getEntry(LogLevel.FATAL, t);
    }

    @Override
    public LogEntry error(Throwable t) {
        return this.getEntry(LogLevel.ERROR, t);
    }

    @Override
    public LogEntry warn(Throwable t) {
        return this.getEntry(LogLevel.WARN, t);
    }

    @Override
    public LogEntry info(Throwable t) {
        return this.getEntry(LogLevel.INFO, t);
    }

    @Override
    public LogEntry debug(Throwable t) {
        return this.getEntry(LogLevel.DEBUG, t);
    }

    @Override
    public LogEntry trace(Throwable t) {
        return this.getEntry(LogLevel.TRACE, t);
    }

    private void logObjectWithThrowable(LogLevel level, Object object, Throwable t) {
        LogEntry entry = this.getEntry(level, this.timeSource.currentTimeMicros());
        if (object != null) {
            entry.append(object.toString());
        }
        if (t != null) {
            if (object != null) {
                entry.nl();
            }
            entry.append(t);
        }
        entry.endl();
    }

    @Override
    public void fatal(Object object) {
        if (this.isFatalEnabled()) {
            LogEntry e = this.fatal();
            e.append(object == null ? "" : object.toString());
            e.endl();
        }
    }

    @Override
    public void fatal(Object object, Throwable t) {
        if (this.isFatalEnabled()) {
            this.logObjectWithThrowable(LogLevel.FATAL, object, t);
        }
    }

    @Override
    public void error(Object object) {
        if (this.isErrorEnabled()) {
            LogEntry e = this.error();
            e.append(object.toString());
            e.endl();
        }
    }

    @Override
    public void error(Object object, Throwable t) {
        if (this.isErrorEnabled()) {
            this.logObjectWithThrowable(LogLevel.ERROR, object, t);
        }
    }

    @Override
    public void warn(Object object) {
        if (this.isWarnEnabled()) {
            LogEntry e = this.warn();
            e.append(object.toString());
            e.endl();
        }
    }

    @Override
    public void warn(Object object, Throwable t) {
        if (this.isErrorEnabled()) {
            this.logObjectWithThrowable(LogLevel.WARN, object, t);
        }
    }

    @Override
    public void info(Object object) {
        if (this.isInfoEnabled()) {
            LogEntry e = this.info();
            e.append(object.toString());
            e.endl();
        }
    }

    @Override
    public void info(Object object, Throwable t) {
        if (this.isErrorEnabled()) {
            this.logObjectWithThrowable(LogLevel.INFO, object, t);
        }
    }

    @Override
    public void debug(Object object) {
        if (this.isDebugEnabled()) {
            LogEntry e = this.debug();
            e.append(object.toString());
            e.endl();
        }
    }

    @Override
    public void debug(Object object, Throwable t) {
        if (this.isErrorEnabled()) {
            this.logObjectWithThrowable(LogLevel.DEBUG, object, t);
        }
    }

    @Override
    public void trace(Object object) {
        if (this.isTraceEnabled()) {
            LogEntry e = this.trace();
            e.append(object.toString());
            e.endl();
        }
    }

    @Override
    public void trace(Object object, Throwable t) {
        if (this.isErrorEnabled()) {
            this.logObjectWithThrowable(LogLevel.TRACE, object, t);
        }
    }

    @Override
    public void email(Object object) {
        if (this.isEmailEnabled()) {
            LogEntry e = this.email();
            e.append(object.toString());
            e.endl();
        }
    }

    @Override
    public void email(Object object, Throwable t) {
        if (this.isErrorEnabled()) {
            this.logObjectWithThrowable(LogLevel.EMAIL, object, t);
        }
    }

    @Override
    public boolean isFatalEnabled() {
        return this.isLevelEnabled(LogLevel.FATAL);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.isLevelEnabled(LogLevel.ERROR);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.isLevelEnabled(LogLevel.WARN);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.isLevelEnabled(LogLevel.INFO);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isLevelEnabled(LogLevel.DEBUG);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.isLevelEnabled(LogLevel.TRACE);
    }

    @Override
    public boolean isEmailEnabled() {
        return this.isLevelEnabled(LogLevel.EMAIL);
    }
}

