/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.io.logger;

import io.deephaven.base.system.StandardStreamReceiver;
import io.deephaven.io.log.LogLevel;
import io.deephaven.io.logger.LogBuffer;
import io.deephaven.io.logger.LogBufferOutputStream;
import java.io.OutputStream;
import java.util.Objects;
import java.util.Optional;

public class StreamToLogBuffer
implements StandardStreamReceiver {
    private final LogBuffer logBuffer;
    private final boolean receiveOut;
    private final boolean receiveErr;
    private final int initialBufferSize;
    private final int maxBufferSize;

    public StreamToLogBuffer(LogBuffer logBuffer, boolean receiveOut, boolean receiveErr, int initialBufferSize, int maxBufferSize) {
        this.logBuffer = Objects.requireNonNull(logBuffer);
        this.receiveOut = receiveOut;
        this.receiveErr = receiveErr;
        this.initialBufferSize = initialBufferSize;
        this.maxBufferSize = maxBufferSize;
    }

    public Optional<OutputStream> receiveOut() {
        if (!this.receiveOut) {
            return Optional.empty();
        }
        return Optional.of(new LogBufferOutputStream(this.logBuffer, LogLevel.STDOUT, this.initialBufferSize, this.maxBufferSize));
    }

    public Optional<OutputStream> receiveErr() {
        if (!this.receiveErr) {
            return Optional.empty();
        }
        return Optional.of(new LogBufferOutputStream(this.logBuffer, LogLevel.STDERR, this.initialBufferSize, this.maxBufferSize));
    }
}

