/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.io.logger;

import io.deephaven.base.log.LogOutput;
import io.deephaven.base.pool.Pool;
import io.deephaven.base.pool.ThreadSafeLenientFixedSizePool;
import io.deephaven.io.log.LogEntry;
import io.deephaven.io.log.LogLevel;
import io.deephaven.io.log.LogSink;
import io.deephaven.io.logger.Logger;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.function.Supplier;

public class StringsLoggerImpl<E extends LogEntry>
implements Logger {
    private final Pool<E> entries;
    private final LogOutput outputBuffer;
    private final Queue<String> output;
    private final LogSink<E> sink = new LogSink<E>(){
        private final ByteArrayOutputStream stream = new ByteArrayOutputStream(1024);
        private LogSink.Interceptor<E>[] interceptors = null;

        @Override
        public void write(E e) {
            LogOutput outputData = e.writing(StringsLoggerImpl.this.outputBuffer);
            try {
                if (null != e.getThrowable()) {
                    outputData.append(e.getThrowable());
                }
                this.flushOutput(e, outputData);
            }
            finally {
                e.written(outputData);
                StringsLoggerImpl.this.entries.give(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flushOutput(E e, LogOutput outputData) {
            this.stream.reset();
            if (outputData.getBufferCount() == 1 && outputData.getBuffer(0).hasArray()) {
                ByteBuffer b = outputData.getBuffer(0);
                b.flip();
                byte[] ba = b.array();
                ByteArrayOutputStream byteArrayOutputStream = this.stream;
                synchronized (byteArrayOutputStream) {
                    this.stream.write(ba, 0, b.limit());
                }
            }
            ByteArrayOutputStream byteArrayOutputStream = this.stream;
            synchronized (byteArrayOutputStream) {
                for (int i = 0; i < outputData.getBufferCount(); ++i) {
                    ByteBuffer b = outputData.getBuffer(i);
                    b.flip();
                    while (b.remaining() > 0) {
                        this.stream.write(b.get());
                    }
                }
            }
            StringsLoggerImpl.this.output.add(this.stream.toString());
        }

        @Override
        public void shutdown() {
        }

        @Override
        public void terminate() {
        }

        @Override
        public void addInterceptor(LogSink.Interceptor<E> entryInterceptor) {
            throw new UnsupportedOperationException("no interceptors allowed");
        }
    };
    private LogLevel loggingLevel;

    public StringsLoggerImpl(Supplier<E> entryFactory, int entryPoolSize, LogOutput outputBuffer, LogLevel loggingLevel) {
        this.loggingLevel = loggingLevel;
        this.entries = new ThreadSafeLenientFixedSizePool(entryPoolSize, entryFactory, null);
        this.outputBuffer = outputBuffer;
        this.output = new ArrayDeque<String>();
    }

    public String next() {
        return this.output.poll();
    }

    public String[] takeAll() {
        String[] result = this.output.toArray(new String[this.output.size()]);
        this.output.clear();
        return result;
    }

    private LogEntry startEntry(LogLevel level, long currentTime) {
        return ((LogEntry)this.entries.take()).start(this.sink, level, currentTime);
    }

    private LogEntry startEntry(LogLevel level, long currentTime, Throwable t) {
        return ((LogEntry)this.entries.take()).start(this.sink, level, currentTime, t);
    }

    @Override
    public LogEntry getEntry(LogLevel level) {
        return this.isLevelEnabled(level) ? this.startEntry(level, System.currentTimeMillis() * 1000L) : LogEntry.NULL;
    }

    @Override
    public LogEntry getEntry(LogLevel level, Throwable t) {
        return this.isLevelEnabled(level) ? this.startEntry(level, System.currentTimeMillis() * 1000L, t) : LogEntry.NULL;
    }

    @Override
    public LogEntry getEntry(LogLevel level, long currentTime) {
        return this.isLevelEnabled(level) ? this.startEntry(level, currentTime) : LogEntry.NULL;
    }

    @Override
    public LogEntry getEntry(LogLevel level, long currentTime, Throwable t) {
        return this.isLevelEnabled(level) ? this.startEntry(level, currentTime, t) : LogEntry.NULL;
    }

    @Override
    public void setLevel(LogLevel level) {
        this.loggingLevel = level;
    }

    @Override
    public LogSink getSink() {
        return this.sink;
    }

    @Override
    public boolean isLevelEnabled(LogLevel level) {
        return this.loggingLevel.getPriority() <= level.getPriority();
    }

    @Override
    public void shutdown() {
    }

    @Override
    public LogEntry fatal() {
        return this.getEntry(LogLevel.FATAL);
    }

    @Override
    public LogEntry error() {
        return this.getEntry(LogLevel.ERROR);
    }

    @Override
    public LogEntry warn() {
        return this.getEntry(LogLevel.WARN);
    }

    @Override
    public LogEntry info() {
        return this.getEntry(LogLevel.INFO);
    }

    @Override
    public LogEntry debug() {
        return this.getEntry(LogLevel.DEBUG);
    }

    @Override
    public LogEntry trace() {
        return this.getEntry(LogLevel.TRACE);
    }

    @Override
    public LogEntry email() {
        return this.getEntry(LogLevel.EMAIL);
    }

    @Override
    public LogEntry fatal(Throwable t) {
        return this.getEntry(LogLevel.FATAL, t);
    }

    @Override
    public LogEntry error(Throwable t) {
        return this.getEntry(LogLevel.ERROR, t);
    }

    @Override
    public LogEntry warn(Throwable t) {
        return this.getEntry(LogLevel.WARN, t);
    }

    @Override
    public LogEntry info(Throwable t) {
        return this.getEntry(LogLevel.INFO, t);
    }

    @Override
    public LogEntry debug(Throwable t) {
        return this.getEntry(LogLevel.DEBUG, t);
    }

    @Override
    public LogEntry trace(Throwable t) {
        return this.getEntry(LogLevel.TRACE, t);
    }

    private void logObjectWithThrowable(LogLevel level, Object object, Throwable t) {
        LogEntry entry = this.getEntry(level, System.currentTimeMillis() * 1000L);
        if (object != null) {
            entry.append(object.toString());
        }
        if (t != null) {
            if (object != null) {
                entry.nl();
            }
            entry.append(t);
        }
        entry.endl();
    }

    @Override
    public void fatal(Object object) {
        if (this.isFatalEnabled()) {
            LogEntry e = this.fatal();
            e.append(object == null ? "" : object.toString());
            e.endl();
        }
    }

    @Override
    public void fatal(Object object, Throwable t) {
        if (this.isFatalEnabled()) {
            this.logObjectWithThrowable(LogLevel.FATAL, object, t);
        }
    }

    @Override
    public void error(Object object) {
        if (this.isErrorEnabled()) {
            LogEntry e = this.error();
            e.append(object.toString());
            e.endl();
        }
    }

    @Override
    public void error(Object object, Throwable t) {
        if (this.isErrorEnabled()) {
            this.logObjectWithThrowable(LogLevel.ERROR, object, t);
        }
    }

    @Override
    public void warn(Object object) {
        if (this.isWarnEnabled()) {
            LogEntry e = this.warn();
            e.append(object.toString());
            e.endl();
        }
    }

    @Override
    public void warn(Object object, Throwable t) {
        if (this.isErrorEnabled()) {
            this.logObjectWithThrowable(LogLevel.WARN, object, t);
        }
    }

    @Override
    public void info(Object object) {
        if (this.isInfoEnabled()) {
            LogEntry e = this.info();
            e.append(object.toString());
            e.endl();
        }
    }

    @Override
    public void info(Object object, Throwable t) {
        if (this.isErrorEnabled()) {
            this.logObjectWithThrowable(LogLevel.INFO, object, t);
        }
    }

    @Override
    public void debug(Object object) {
        if (this.isDebugEnabled()) {
            LogEntry e = this.debug();
            e.append(object.toString());
            e.endl();
        }
    }

    @Override
    public void debug(Object object, Throwable t) {
        if (this.isErrorEnabled()) {
            this.logObjectWithThrowable(LogLevel.DEBUG, object, t);
        }
    }

    @Override
    public void trace(Object object) {
        if (this.isTraceEnabled()) {
            LogEntry e = this.trace();
            e.append(object.toString());
            e.endl();
        }
    }

    @Override
    public void trace(Object object, Throwable t) {
        if (this.isErrorEnabled()) {
            this.logObjectWithThrowable(LogLevel.TRACE, object, t);
        }
    }

    @Override
    public void email(Object object) {
        if (this.isEmailEnabled()) {
            LogEntry e = this.email();
            e.append(object.toString());
            e.endl();
        }
    }

    @Override
    public void email(Object object, Throwable t) {
        if (this.isErrorEnabled()) {
            this.logObjectWithThrowable(LogLevel.EMAIL, object, t);
        }
    }

    @Override
    public boolean isFatalEnabled() {
        return this.isLevelEnabled(LogLevel.FATAL);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.isLevelEnabled(LogLevel.ERROR);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.isLevelEnabled(LogLevel.WARN);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.isLevelEnabled(LogLevel.INFO);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isLevelEnabled(LogLevel.DEBUG);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.isLevelEnabled(LogLevel.TRACE);
    }

    @Override
    public boolean isEmailEnabled() {
        return this.isLevelEnabled(LogLevel.EMAIL);
    }
}

