/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.io.streams;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.NotNull;

public class ByteBufferInputStream
extends InputStream
implements DataInput {
    protected ByteBuffer buf;

    public ByteBufferInputStream(ByteBuffer buf) {
        this.buf = buf;
    }

    public void setBuffer(ByteBuffer buf) {
        this.buf = buf;
    }

    @Override
    public int read() throws IOException {
        try {
            return this.buf.get() & 0xFF;
        }
        catch (BufferUnderflowException x) {
            throw new EOFException();
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        int n = Math.min(this.buf.remaining(), b.length);
        if (n == 0 && b.length > 0) {
            return -1;
        }
        this.buf.get(b, 0, n);
        return n;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int n = Math.min(this.buf.remaining(), len);
        if (n == 0 && len > 0) {
            return -1;
        }
        this.buf.get(b, off, n);
        return n;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n < 0L) {
            return 0L;
        }
        n = Math.min((long)this.buf.remaining(), n);
        this.buf.position(this.buf.position() + (int)n);
        return n;
    }

    @Override
    public int available() throws IOException {
        return this.buf.remaining();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.buf.mark();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.buf.reset();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        try {
            this.buf.get(b, 0, b.length);
        }
        catch (BufferUnderflowException x) {
            throw new EOFException();
        }
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        try {
            this.buf.get(b, off, len);
        }
        catch (BufferUnderflowException x) {
            throw new EOFException();
        }
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return (int)this.skip(n);
    }

    @Override
    public boolean readBoolean() throws IOException {
        try {
            return this.buf.get() != 0;
        }
        catch (BufferUnderflowException x) {
            throw new EOFException();
        }
    }

    @Override
    public byte readByte() throws IOException {
        try {
            return this.buf.get();
        }
        catch (BufferUnderflowException x) {
            throw new EOFException();
        }
    }

    @Override
    public int readUnsignedByte() throws IOException {
        try {
            return this.buf.get() & 0xFF;
        }
        catch (BufferUnderflowException x) {
            throw new EOFException();
        }
    }

    @Override
    public short readShort() throws IOException {
        try {
            return this.buf.getShort();
        }
        catch (BufferUnderflowException x) {
            throw new EOFException();
        }
    }

    @Override
    public int readUnsignedShort() throws IOException {
        try {
            return this.buf.getShort() & 0xFFFF;
        }
        catch (BufferUnderflowException x) {
            throw new EOFException();
        }
    }

    @Override
    public char readChar() throws IOException {
        try {
            return this.buf.getChar();
        }
        catch (BufferUnderflowException x) {
            throw new EOFException();
        }
    }

    @Override
    public int readInt() throws IOException {
        try {
            return this.buf.getInt();
        }
        catch (BufferUnderflowException x) {
            throw new EOFException();
        }
    }

    @Override
    public long readLong() throws IOException {
        try {
            return this.buf.getLong();
        }
        catch (BufferUnderflowException x) {
            throw new EOFException();
        }
    }

    @Override
    public float readFloat() throws IOException {
        try {
            return this.buf.getFloat();
        }
        catch (BufferUnderflowException x) {
            throw new EOFException();
        }
    }

    @Override
    public double readDouble() throws IOException {
        try {
            return this.buf.getDouble();
        }
        catch (BufferUnderflowException x) {
            throw new EOFException();
        }
    }

    @Override
    public String readLine() throws IOException {
        int end;
        int begin;
        block6: {
            begin = this.buf.position();
            try {
                int b;
                do {
                    if ((b = this.buf.get() & 0xFF) != 10) continue;
                    end = this.buf.position() - 1;
                    break block6;
                } while (b != 13);
                b = this.buf.get() & 0xFF;
                if (b == 10) {
                    end = this.buf.position() - 2;
                } else {
                    this.buf.position(this.buf.position() - 1);
                    end = this.buf.position() - 1;
                }
            }
            catch (BufferUnderflowException x) {
                end = this.buf.position();
            }
        }
        char[] chars = new char[end - begin];
        for (int i = begin; i < end; ++i) {
            chars[i - begin] = (char)(this.buf.get(i) & 0xFF);
        }
        return new String(chars);
    }

    @Override
    @NotNull
    public String readUTF() throws IOException {
        int length = 0;
        int total = this.readUnsignedShort();
        char[] chars = new char[total];
        while (total > 0) {
            byte b2;
            byte b1 = this.buf.get();
            if ((b1 & 0x80) == 0) {
                chars[length++] = (char)(b1 & 0xFF);
                --total;
                continue;
            }
            if ((b1 & 0xE0) == 192) {
                b2 = this.buf.get();
                if ((b2 & 0xC0) != 128) {
                    throw new UTFDataFormatException("malformed second byte " + b2);
                }
                chars[length++] = (char)((b1 & 0x1F) << 6 | b2 & 0x3F);
                total -= 2;
                continue;
            }
            if ((b1 & 0xF0) == 224) {
                b2 = this.buf.get();
                byte b3 = this.buf.get();
                if ((b2 & 0xC0) != 128 || (b3 & 0xC0) != 128) {
                    throw new UTFDataFormatException("malformed second byte " + b2 + " or third byte " + b3);
                }
                chars[length++] = (char)((b1 & 0xF) << 12 | (b2 & 0x3F) << 6 | b3 & 0x3F);
                total -= 3;
                continue;
            }
            throw new UTFDataFormatException("malformed first byte " + b1);
        }
        return new String(chars, 0, length);
    }
}

