/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.io.streams;

import io.deephaven.base.ArrayUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public class ByteBufferStreams {

    public static class Input
    extends InputStream
    implements DataInput {
        protected ByteBuffer buf;
        private Source source;
        private char[] stringBuffer;
        private int stringBufferCount;
        private static final char[] EMPTY_STRING_BUFFER = new char[0];

        public Input(ByteBuffer buf) {
            this.buf = buf;
            this.source = null;
            this.stringBuffer = EMPTY_STRING_BUFFER;
            this.stringBufferCount = 0;
        }

        public Input(ByteBuffer buf, Source source) {
            this.buf = buf;
            this.source = source;
            this.stringBuffer = EMPTY_STRING_BUFFER;
            this.stringBufferCount = 0;
        }

        public void setBuffer(ByteBuffer buf) {
            this.buf = buf;
        }

        private void need(int n) throws BufferUnderflowException, EOFException {
            if (this.buf == null) {
                throw new EOFException();
            }
            if (this.buf.remaining() < n) {
                if (this.buf.remaining() != 0) {
                    throw new IllegalStateException("Partial primitive, input was not written by ByteBufferOutputStream?");
                }
                if (this.next() == null) {
                    throw new BufferUnderflowException();
                }
            }
        }

        private ByteBuffer next() {
            if (this.source == null) {
                return null;
            }
            while ((this.buf = this.source.nextBuffer(this.buf)) != null && this.buf.remaining() == 0) {
            }
            return this.buf;
        }

        private boolean eof() {
            return this.buf == null || this.buf.remaining() == 0 && this.next() == null;
        }

        private int peek() {
            if (this.eof()) {
                return -1;
            }
            return this.buf.get(this.buf.position()) & 0xFF;
        }

        @Override
        public int read() throws IOException {
            if (this.eof()) {
                return -1;
            }
            return this.buf.get() & 0xFF;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (len <= 0) {
                return 0;
            }
            if (this.eof()) {
                return -1;
            }
            int n = Math.min(this.buf.remaining(), len);
            if (n == 0 && len > 0) {
                return -1;
            }
            this.buf.get(b, off, n);
            return n;
        }

        @Override
        public long skip(long n) throws IOException {
            if (n < 0L || this.eof()) {
                return 0L;
            }
            n = Math.min((long)this.buf.remaining(), n);
            this.buf.position(this.buf.position() + (int)n);
            return n;
        }

        @Override
        public int available() throws IOException {
            if (this.eof()) {
                return 0;
            }
            return this.buf.remaining();
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public synchronized void mark(int readlimit) {
        }

        @Override
        public synchronized void reset() throws IOException {
            throw new IOException("mark/reset is not supported");
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public void readFully(byte[] b) throws IOException {
            this.readFully(b, 0, b.length);
        }

        @Override
        public void readFully(byte[] b, int off, int len) throws IOException {
            try {
                int nread = 0;
                while ((nread += this.read(b, off + nread, len - nread)) < len) {
                }
            }
            catch (BufferUnderflowException x) {
                throw new EOFException();
            }
        }

        @Override
        public int skipBytes(int n) throws IOException {
            return (int)this.skip(n);
        }

        @Override
        public boolean readBoolean() throws IOException {
            try {
                this.need(1);
                return this.buf.get() != 0;
            }
            catch (BufferUnderflowException x) {
                throw new EOFException();
            }
        }

        @Override
        public byte readByte() throws IOException {
            try {
                this.need(1);
                return this.buf.get();
            }
            catch (BufferUnderflowException x) {
                throw new EOFException();
            }
        }

        @Override
        public int readUnsignedByte() throws IOException {
            try {
                this.need(1);
                return this.buf.get() & 0xFF;
            }
            catch (BufferUnderflowException x) {
                throw new EOFException();
            }
        }

        @Override
        public short readShort() throws IOException {
            try {
                this.need(2);
                return this.buf.getShort();
            }
            catch (BufferUnderflowException x) {
                throw new EOFException();
            }
        }

        @Override
        public int readUnsignedShort() throws IOException {
            try {
                this.need(2);
                return this.buf.getShort() & 0xFFFF;
            }
            catch (BufferUnderflowException x) {
                throw new EOFException();
            }
        }

        @Override
        public char readChar() throws IOException {
            try {
                this.need(2);
                return this.buf.getChar();
            }
            catch (BufferUnderflowException x) {
                throw new EOFException();
            }
        }

        @Override
        public int readInt() throws IOException {
            try {
                this.need(4);
                return this.buf.getInt();
            }
            catch (BufferUnderflowException x) {
                throw new EOFException();
            }
        }

        @Override
        public long readLong() throws IOException {
            try {
                this.need(8);
                return this.buf.getLong();
            }
            catch (BufferUnderflowException x) {
                throw new EOFException();
            }
        }

        @Override
        public float readFloat() throws IOException {
            try {
                this.need(4);
                return this.buf.getFloat();
            }
            catch (BufferUnderflowException x) {
                throw new EOFException();
            }
        }

        @Override
        public double readDouble() throws IOException {
            try {
                this.need(8);
                return this.buf.getDouble();
            }
            catch (BufferUnderflowException x) {
                throw new EOFException();
            }
        }

        @Override
        public String readLine() throws IOException {
            this.stringBufferCount = 0;
            int b = this.read();
            if (b == -1) {
                return null;
            }
            while (b != 10) {
                if (b == 13) {
                    b = this.peek();
                    if (b != 10) break;
                    b = this.read();
                    break;
                }
                this.stringBuffer = ArrayUtil.put((char[])this.stringBuffer, (int)this.stringBufferCount++, (char)((char)b));
                b = this.read();
                if (b != -1) continue;
            }
            return new String(this.stringBuffer, 0, this.stringBufferCount);
        }

        @Override
        public String readUTF() throws IOException {
            int length = 0;
            int total = this.readUnsignedShort();
            if (total > this.stringBuffer.length) {
                this.stringBuffer = new char[Math.max(total, this.stringBuffer.length * 2)];
            }
            while (total > 0) {
                int b2;
                int b1 = this.read();
                if (b1 == -1) {
                    throw new UTFDataFormatException();
                }
                if ((b1 & 0x80) == 0) {
                    this.stringBuffer[length++] = (char)(b1 & 0xFF);
                    --total;
                    continue;
                }
                if ((b1 & 0xE0) == 192) {
                    b2 = this.read();
                    if (b2 == -1 || (b2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    this.stringBuffer[length++] = (char)((b1 & 0x1F) << 6 | b2 & 0x3F);
                    total -= 2;
                    continue;
                }
                if ((b1 & 0xF0) != 224) continue;
                b2 = this.read();
                int b3 = this.read();
                if (b2 == -1 || b3 == -1 || (b2 & 0xC0) != 128 || (b3 & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                this.stringBuffer[length++] = (char)((b1 & 0xF) << 12 | (b2 & 0x3F) << 6 | b3 & 0x3F);
                total -= 3;
            }
            return new String(this.stringBuffer, 0, length);
        }
    }

    public static interface Source {
        public ByteBuffer nextBuffer(ByteBuffer var1);
    }

    public static class Output
    extends OutputStream
    implements DataOutput {
        protected volatile ByteBuffer buf;
        protected Sink sink;

        public Output(ByteBuffer b, Sink sink) {
            this.buf = b;
            this.sink = sink;
        }

        public void setBuffer(ByteBuffer b) {
            this.buf = b;
        }

        public void setSink(Sink sink) {
            this.sink = sink;
        }

        @Override
        public void close() throws IOException {
            ByteBuffer b = this.buf;
            this.buf = null;
            this.sink.close(b);
        }

        @Override
        public void flush() throws IOException {
            if (this.buf.position() != 0) {
                this.buf = this.sink.acceptBuffer(this.buf, 0);
            }
        }

        @Override
        public void write(int b) throws IOException {
            if (this.buf.remaining() < 1) {
                this.buf = this.sink.acceptBuffer(this.buf, 1);
            }
            this.buf.put((byte)b);
        }

        @Override
        public void write(byte[] ba) throws IOException {
            this.write(ba, 0, ba.length);
        }

        @Override
        public void write(byte[] ba, int off, int len) throws IOException {
            int remaining;
            while ((remaining = this.buf.remaining()) < len) {
                this.buf.put(ba, off, remaining);
                this.buf = this.sink.acceptBuffer(this.buf, this.buf.capacity());
                len -= remaining;
                off += remaining;
            }
            this.buf.put(ba, off, len);
        }

        public void write(ByteBuffer b) throws IOException {
            int remaining;
            for (int len = b.remaining(); (remaining = this.buf.remaining()) < len; len -= remaining) {
                for (int i = 0; i < remaining; ++i) {
                    this.buf.put(b.get());
                }
                this.buf = this.sink.acceptBuffer(this.buf, this.buf.capacity());
            }
            this.buf.put(b);
        }

        @Override
        public void writeBoolean(boolean v) throws IOException {
            if (this.buf.remaining() < 1) {
                this.buf = this.sink.acceptBuffer(this.buf, 1);
            }
            this.buf.put((byte)(v ? 1 : 0));
        }

        @Override
        public void writeByte(int v) throws IOException {
            if (this.buf.remaining() < 1) {
                this.buf = this.sink.acceptBuffer(this.buf, 1);
            }
            this.buf.put((byte)v);
        }

        @Override
        public void writeShort(int v) throws IOException {
            if (this.buf.remaining() < 2) {
                this.buf = this.sink.acceptBuffer(this.buf, 2);
            }
            this.buf.putShort((short)v);
        }

        @Override
        public void writeChar(int v) throws IOException {
            if (this.buf.remaining() < 2) {
                this.buf = this.sink.acceptBuffer(this.buf, 2);
            }
            this.buf.putChar((char)v);
        }

        @Override
        public void writeInt(int v) throws IOException {
            if (this.buf.remaining() < 4) {
                this.buf = this.sink.acceptBuffer(this.buf, 4);
            }
            this.buf.putInt(v);
        }

        @Override
        public void writeLong(long v) throws IOException {
            if (this.buf.remaining() < 8) {
                this.buf = this.sink.acceptBuffer(this.buf, 8);
            }
            this.buf.putLong(v);
        }

        @Override
        public void writeFloat(float f) throws IOException {
            if (this.buf.remaining() < 8) {
                this.buf = this.sink.acceptBuffer(this.buf, 8);
            }
            this.buf.putFloat(f);
        }

        @Override
        public void writeDouble(double d) throws IOException {
            if (this.buf.remaining() < 8) {
                this.buf = this.sink.acceptBuffer(this.buf, 8);
            }
            this.buf.putDouble(d);
        }

        @Override
        public void writeBytes(String s) throws IOException {
            this.appendBytes(s);
        }

        @Override
        public void writeChars(String s) throws IOException {
            this.appendChars(s);
        }

        @Override
        public void writeUTF(String str) throws IOException {
            char c;
            int i;
            int remaining;
            int len = str.length();
            int total = 0;
            for (int i2 = 0; i2 < len; ++i2) {
                char c2 = str.charAt(i2);
                if (c2 <= '\u007f') {
                    ++total;
                    if (c2 != '\u0000') continue;
                    ++total;
                    continue;
                }
                if (c2 <= '\u07ff') {
                    total += 2;
                    continue;
                }
                total += 3;
            }
            if (total >= 65536) {
                throw new UTFDataFormatException();
            }
            int position = 0;
            if (this.buf.remaining() < 2) {
                this.buf = this.sink.acceptBuffer(this.buf, 2);
            }
            this.buf.putShort((short)total);
            while ((remaining = this.buf.remaining() / 3) < len) {
                for (i = 0; i < remaining; ++i) {
                    if ((c = str.charAt(position++)) <= '\u007f') {
                        if (c == '\u0000') {
                            this.buf.put((byte)-64);
                            this.buf.put((byte)-128);
                            continue;
                        }
                        this.buf.put((byte)c);
                        continue;
                    }
                    if (c <= '\u07ff') {
                        this.buf.put((byte)(0xC0 | 0x1F & c >> 6));
                        this.buf.put((byte)(0x80 | 0x3F & c));
                        continue;
                    }
                    this.buf.put((byte)(0xE0 | 0xF & c >> 12));
                    this.buf.put((byte)(0x80 | 0x3F & c >> 6));
                    this.buf.put((byte)(0x80 | 0x3F & c));
                }
                this.buf = this.sink.acceptBuffer(this.buf, Math.max(this.buf.capacity(), 3));
                len -= remaining;
            }
            for (i = 0; i < len; ++i) {
                if ((c = str.charAt(position++)) <= '\u007f') {
                    if (c == '\u0000') {
                        this.buf.put((byte)-64);
                        this.buf.put((byte)-128);
                        continue;
                    }
                    this.buf.put((byte)c);
                    continue;
                }
                if (c <= '\u07ff') {
                    this.buf.put((byte)(0xC0 | 0x1F & c >> 6));
                    this.buf.put((byte)(0x80 | 0x3F & c));
                    continue;
                }
                this.buf.put((byte)(0xE0 | 0xF & c >> 12));
                this.buf.put((byte)(0x80 | 0x3F & c >> 6));
                this.buf.put((byte)(0x80 | 0x3F & c));
            }
        }

        public Output appendChars(CharSequence s) throws IOException {
            return this.appendChars(s, 0, s.length());
        }

        public Output appendChars(CharSequence s, int position, int len) throws IOException {
            int i;
            int remaining;
            while ((remaining = this.buf.remaining() / 2) < len) {
                for (i = 0; i < remaining; ++i) {
                    this.buf.putChar(s.charAt(position++));
                }
                this.buf = this.sink.acceptBuffer(this.buf, Math.max(this.buf.capacity(), 2));
                len -= remaining;
            }
            for (i = 0; i < len; ++i) {
                this.buf.putChar(s.charAt(position++));
            }
            return this;
        }

        public Output appendBytes(CharSequence s) throws IOException {
            return this.appendBytes(s, 0, s.length());
        }

        public Output appendBytes(CharSequence s, int position, int len) throws IOException {
            int i;
            int remaining;
            while ((remaining = this.buf.remaining()) < len) {
                for (i = 0; i < remaining; ++i) {
                    this.buf.put((byte)s.charAt(position++));
                }
                this.buf = this.sink.acceptBuffer(this.buf, this.buf.capacity());
                len -= remaining;
            }
            for (i = 0; i < len; ++i) {
                this.buf.put((byte)s.charAt(position++));
            }
            return this;
        }
    }

    public static interface Sink {
        public ByteBuffer acceptBuffer(ByteBuffer var1, int var2) throws IOException;

        public void close(ByteBuffer var1) throws IOException;
    }
}

