/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.io.streams;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;

public class ZipInputStream
extends FilterInputStream {
    public static final int BUFFER_LIMIT = 0x4000000;
    protected DataInputStream dataIn;
    protected InflaterInputStream iis;

    public ZipInputStream(InputStream in) throws IOException {
        super(in);
        this.dataIn = new DataInputStream(in);
        this.fill();
    }

    private void fill() throws IOException {
        byte[] buf;
        if (this.iis != null) {
            this.iis.close();
            this.iis = null;
        }
        try {
            int noBytes = this.dataIn.readInt();
            if (noBytes < 0 || noBytes > 0x4000000) {
                throw new ZipException("io.deephaven.io.streams.ZipInputStream was asked to read " + noBytes + " which exceeded buffer limit.  Is this a Zip file?");
            }
            buf = new byte[noBytes];
        }
        catch (EOFException ee) {
            return;
        }
        this.dataIn.readFully(buf);
        this.iis = new InflaterInputStream(new ByteArrayInputStream(buf));
    }

    @Override
    public synchronized int read() throws IOException {
        int ret = this.iis.read();
        while (ret == -1) {
            this.fill();
            if (this.iis == null) break;
            ret = this.iis.read();
        }
        return ret;
    }

    @Override
    public synchronized int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int data;
        if (this.iis.available() == 0) {
            this.fill();
            if (this.iis == null) {
                return -1;
            }
        }
        int i = 0;
        for (i = 0; i < len && (data = this.iis.read()) != -1; ++i) {
            b[i + off] = (byte)data;
        }
        return i;
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        this.ensureOpen();
        int i = 0;
        while ((long)i < n) {
            this.read();
            ++i;
        }
        return n;
    }

    @Override
    public synchronized int available() throws IOException {
        return this.in.available() + this.iis.available();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void close() throws IOException {
        if (this.in == null) {
            return;
        }
        this.in.close();
        this.in = null;
    }

    private void ensureOpen() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
    }
}

