/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.charts.stats.buffers;

import io.gatling.commons.util.Maps;
import io.gatling.commons.util.Maps$;
import io.gatling.core.stats.IntVsTimePlot;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Iterable$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u00154Q!\u0001\u0002\u0001\t1\u0011!cU3tg&|g\u000eR3mi\u0006\u0014UO\u001a4fe*\u00111\u0001B\u0001\bEV4g-\u001a:t\u0015\t)a!A\u0003ti\u0006$8O\u0003\u0002\b\u0011\u000511\r[1siNT!!\u0003\u0006\u0002\u000f\u001d\fG\u000f\\5oO*\t1\"\u0001\u0002j_N\u0011\u0001!\u0004\t\u0003\u001dEi\u0011a\u0004\u0006\u0002!\u0005)1oY1mC&\u0011!c\u0004\u0002\u0007\u0003:L(+\u001a4\t\u0011Q\u0001!\u0011!Q\u0001\nY\tA\"\\5o)&lWm\u001d;b[B\u001c\u0001\u0001\u0005\u0002\u000f/%\u0011\u0001d\u0004\u0002\u0005\u0019>tw\r\u0003\u0005\u001b\u0001\t\u0005\t\u0015!\u0003\u0017\u00031i\u0017\r\u001f+j[\u0016\u001cH/Y7q\u0011!a\u0002A!A!\u0002\u0013i\u0012a\u00022vG.,Go\u001d\t\u0004\u001dy\u0001\u0013BA\u0010\u0010\u0005\u0015\t%O]1z!\tq\u0011%\u0003\u0002#\u001f\t\u0019\u0011J\u001c;\t\u0011\u0011\u0002!\u0011!Q\u0001\n\u0001\nAC];o\tV\u0014\u0018\r^5p]&s7+Z2p]\u0012\u001c\b\"\u0002\u0014\u0001\t\u00039\u0013A\u0002\u001fj]&$h\bF\u0003)U-bS\u0006\u0005\u0002*\u00015\t!\u0001C\u0003\u0015K\u0001\u0007a\u0003C\u0003\u001bK\u0001\u0007a\u0003C\u0003\u001dK\u0001\u0007Q\u0004C\u0003%K\u0001\u0007\u0001\u0005C\u00040\u0001\t\u0007I\u0011\u0002\u0019\u0002\u0017M$\u0018M\u001d;D_VtGo]\u000b\u0002;!1!\u0007\u0001Q\u0001\nu\tAb\u001d;beR\u001cu.\u001e8ug\u0002Bq\u0001\u000e\u0001C\u0002\u0013%\u0001'A\u0005f]\u0012\u001cu.\u001e8ug\"1a\u0007\u0001Q\u0001\nu\t!\"\u001a8e\u0007>,h\u000e^:!\u0011\u0015A\u0004\u0001\"\u0001:\u0003!\tG\rZ*uCJ$HC\u0001\u001e>!\tq1(\u0003\u0002=\u001f\t!QK\\5u\u0011\u0015qt\u00071\u0001!\u0003\u0019\u0019XmY8oI\")\u0001\t\u0001C\u0001\u0003\u00061\u0011\r\u001a3F]\u0012$\"A\u000f\"\t\u000byz\u0004\u0019\u0001\u0011\t\u000b\u0011\u0003A\u0011A#\u0002\u0013\u0015tGm\u0014:qQ\u0006tG#\u0001\u001e\t\u000f\u001d\u0003!\u0019!C\u0005\u0011\u0006\u0019\"-^2lKR<\u0016\u000e\u001a;i\u0013:l\u0015\u000e\u001c7jgV\t\u0001\u0005\u0003\u0004K\u0001\u0001\u0006I\u0001I\u0001\u0015EV\u001c7.\u001a;XS\u0012$\b.\u00138NS2d\u0017n\u001d\u0011\t\u000b1\u0003A\u0011B'\u0002\u001dM,7m\u001c8e)>\u0014UoY6fiR\u0011\u0001E\u0014\u0005\u0006}-\u0003\r\u0001\t\u0005\u0006!\u0002!\t!U\u0001\rI&\u001cHO]5ckRLwN\\\u000b\u0002%B\u00191k\u00170\u000f\u0005QKfBA+Y\u001b\u00051&BA,\u0016\u0003\u0019a$o\\8u}%\t\u0001#\u0003\u0002[\u001f\u00059\u0001/Y2lC\u001e,\u0017B\u0001/^\u0005\u0011a\u0015n\u001d;\u000b\u0005i{\u0001CA0d\u001b\u0005\u0001'BA\u0003b\u0015\t\u0011\u0007\"\u0001\u0003d_J,\u0017B\u00013a\u00055Ie\u000e\u001e,t)&lW\r\u00157pi\u0002")
public class SessionDeltaBuffer {
    private final int[] buckets;
    private final int runDurationInSeconds;
    private final int[] startCounts;
    private final int[] endCounts;
    private final int bucketWidthInMillis;

    private int[] startCounts() {
        return this.startCounts;
    }

    private int[] endCounts() {
        return this.endCounts;
    }

    public void addStart(int second) {
        this.startCounts()[second] = this.startCounts()[second] + 1;
    }

    public void addEnd(int second) {
        this.endCounts()[second] = this.endCounts()[second] + 1;
    }

    public void endOrphan() {
        this.addEnd(this.runDurationInSeconds - 1);
    }

    private int bucketWidthInMillis() {
        return this.bucketWidthInMillis;
    }

    private int secondToBucket(int second) {
        return package$.MODULE$.min(second * 1000 / this.bucketWidthInMillis(), this.buckets.length - 1);
    }

    public List<IntVsTimePlot> distribution() {
        int[] eachSecondActiveSessions = (int[])Array$.MODULE$.fill(this.runDurationInSeconds, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0, ClassTag$.MODULE$.Int());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.runDurationInSeconds).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)second -> {
            int bucketSessions;
            int previousSessions = second == 0 ? 0 : eachSecondActiveSessions[second - 1];
            int previousEnds = second == 0 ? 0 : this.endCounts()[second - 1];
            eachSecondActiveSessions$1[second] = bucketSessions = previousSessions - previousEnds + this.startCounts()[second];
        });
        return (List)((TraversableOnce)Maps.PimpedPairTraversableOnce$.MODULE$.groupByKey$extension(Maps$.MODULE$.PimpedPairTraversableOnce((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(eachSecondActiveSessions)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).iterator().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int sessions = tuple2._1$mcI$sp();
            int second = tuple2._2$mcI$sp();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)second)), (Object)BoxesRunTime.boxToInteger((int)sessions));
            return tuple22;
        })), (Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)second -> this.secondToBucket(second)).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int bucket = tuple2._1$mcI$sp();
            ArrayBuffer sessionCounts = (ArrayBuffer)tuple2._2();
            int averageSessionCount = BoxesRunTime.unboxToInt((Object)sessionCounts.sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / sessionCounts.size();
            int time = $this.buckets[bucket];
            IntVsTimePlot intVsTimePlot = new IntVsTimePlot(time, averageSessionCount);
            return intVsTimePlot;
        }, Iterable$.MODULE$.canBuildFrom())).toList().sortBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.time()), (Ordering)Ordering.Int$.MODULE$);
    }

    public SessionDeltaBuffer(long minTimestamp, long maxTimestamp, int[] buckets, int runDurationInSeconds) {
        this.buckets = buckets;
        this.runDurationInSeconds = runDurationInSeconds;
        this.startCounts = (int[])Array$.MODULE$.fill(runDurationInSeconds, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0, ClassTag$.MODULE$.Int());
        this.endCounts = (int[])Array$.MODULE$.fill(runDurationInSeconds, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0, ClassTag$.MODULE$.Int());
        this.bucketWidthInMillis = (int)((maxTimestamp - minTimestamp) / (long)buckets.length);
    }
}

