/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.feeder;

import io.gatling.commons.util.RoundRobin$;
import io.gatling.core.feeder.Circular$;
import io.gatling.core.feeder.FeederStrategy;
import io.gatling.core.feeder.Queue$;
import io.gatling.core.feeder.Random$;
import io.gatling.core.feeder.Shuffle$;
import java.io.Serializable;
import java.util.concurrent.ThreadLocalRandom;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.IndexedSeqLike;
import scala.collection.Iterator;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.package$;

public final class InMemoryFeeder$ {
    public static InMemoryFeeder$ MODULE$;

    static {
        new InMemoryFeeder$();
    }

    public <T> Iterator<Map<String, Object>> apply(IndexedSeq<Map<String, T>> records, Option<Function1<Map<String, T>, Map<String, Object>>> conversion, FeederStrategy strategy) {
        Iterator iterator;
        IndexedSeq indexedSeq;
        Option<Function1<Map<String, T>, Map<String, Object>>> option = conversion;
        if (option instanceof Some) {
            Some some = (Some)option;
            Function1 f = (Function1)some.value();
            indexedSeq = (IndexedSeq)records.map(f, IndexedSeq$.MODULE$.canBuildFrom());
        } else {
            indexedSeq = records;
        }
        IndexedSeq convertedRecords = indexedSeq;
        FeederStrategy feederStrategy = strategy;
        if (Queue$.MODULE$.equals(feederStrategy)) {
            iterator = convertedRecords.iterator();
        } else if (Random$.MODULE$.equals(feederStrategy)) {
            iterator = package$.MODULE$.Iterator().continually((Function0 & Serializable & scala.Serializable)() -> (Map)convertedRecords.apply(ThreadLocalRandom.current().nextInt(records.length())));
        } else if (Shuffle$.MODULE$.equals(feederStrategy)) {
            iterator = ((IndexedSeqLike)scala.util.Random$.MODULE$.shuffle((TraversableOnce)convertedRecords, IndexedSeq$.MODULE$.canBuildFrom())).iterator();
        } else if (Circular$.MODULE$.equals(feederStrategy)) {
            iterator = RoundRobin$.MODULE$.apply(convertedRecords);
        } else {
            throw new MatchError((Object)feederStrategy);
        }
        return iterator;
    }

    private InMemoryFeeder$() {
        MODULE$ = this;
    }
}

