/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.fetch;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.Status;
import io.gatling.commons.validation.Failure;
import io.gatling.commons.validation.Success;
import io.gatling.commons.validation.Validation;
import io.gatling.core.CoreComponents;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.filter.Filters;
import io.gatling.core.session.Session;
import io.gatling.http.cache.HttpCaches;
import io.gatling.http.cache.InferredPageResources;
import io.gatling.http.client.Request;
import io.gatling.http.client.ahc.uri.Uri;
import io.gatling.http.engine.tx.HttpTx;
import io.gatling.http.engine.tx.HttpTxExecutor;
import io.gatling.http.fetch.ConcurrentResource;
import io.gatling.http.fetch.CssParser$;
import io.gatling.http.fetch.DefaultResourceAggregator;
import io.gatling.http.fetch.HtmlParser;
import io.gatling.http.fetch.ResourceAggregator;
import io.gatling.http.fetch.ResourceFetcher$;
import io.gatling.http.fetch.UserAgent$;
import io.gatling.http.protocol.HttpProtocol;
import io.gatling.http.request.HttpRequest;
import io.gatling.http.request.HttpRequestDef;
import io.gatling.http.response.Response;
import io.gatling.http.util.HttpHelper$;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015x!B\u0001\u0003\u0011\u0003Y\u0011a\u0004*fg>,(oY3GKR\u001c\u0007.\u001a:\u000b\u0005\r!\u0011!\u00024fi\u000eD'BA\u0003\u0007\u0003\u0011AG\u000f\u001e9\u000b\u0005\u001dA\u0011aB4bi2Lgn\u001a\u0006\u0002\u0013\u0005\u0011\u0011n\\\u0002\u0001!\taQ\"D\u0001\u0003\r\u0015q!\u0001#\u0001\u0010\u0005=\u0011Vm]8ve\u000e,g)\u001a;dQ\u0016\u00148cA\u0007\u0011-A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001a\u0004\"a\u0006\u0010\u000e\u0003aQ!!\u0007\u000e\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005ma\u0012\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003u\t1aY8n\u0013\ty\u0002DA\u0007TiJL7\r\u001e'pO\u001eLgn\u001a\u0005\u0006C5!\tAI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003-AQ\u0001J\u0007\u0005\u0002\u0015\nA#\u00199qYf\u0014Vm]8ve\u000e,g)\u001b7uKJ\u001cHc\u0001\u00146oA\u0019qe\f\u001a\u000f\u0005!jcBA\u0015-\u001b\u0005Q#BA\u0016\u000b\u0003\u0019a$o\\8u}%\t1#\u0003\u0002/%\u00059\u0001/Y2lC\u001e,\u0017B\u0001\u00192\u0005\u0011a\u0015n\u001d;\u000b\u00059\u0012\u0002C\u0001\u00074\u0013\t!$A\u0001\nD_:\u001cWO\u001d:f]R\u0014Vm]8ve\u000e,\u0007\"\u0002\u001c$\u0001\u00041\u0013!\u0003:fg>,(oY3t\u0011\u0015A4\u00051\u0001:\u0003\u001d1\u0017\u000e\u001c;feN\u00042!\u0005\u001e=\u0013\tY$C\u0001\u0004PaRLwN\u001c\t\u0003{\tk\u0011A\u0010\u0006\u0003\u007f\u0001\u000baAZ5mi\u0016\u0014(BA!\u0007\u0003\u0011\u0019wN]3\n\u0005\rs$a\u0002$jYR,'o\u001d\u0005\u0006\u000b6!\tAR\u0001\u0014e\u0016\u001cx.\u001e:dKN$vNU3rk\u0016\u001cHo\u001d\u000b\b\u000f:{eK\u00184l!\r9s\u0006\u0013\t\u0003\u00132k\u0011A\u0013\u0006\u0003\u0017\u0012\tqA]3rk\u0016\u001cH/\u0003\u0002N\u0015\nY\u0001\n\u001e;q%\u0016\fX/Z:u\u0011\u00151D\t1\u0001'\u0011\u0015\u0001F\t1\u0001R\u0003\u001d\u0019Xm]:j_:\u0004\"A\u0015+\u000e\u0003MS!\u0001\u0015!\n\u0005U\u001b&aB*fgNLwN\u001c\u0005\u0006/\u0012\u0003\r\u0001W\u0001\u000bQR$\boQ1dQ\u0016\u001c\bCA-]\u001b\u0005Q&BA.\u0005\u0003\u0015\u0019\u0017m\u00195f\u0013\ti&L\u0001\u0006IiR\u00048)Y2iKNDQa\u0018#A\u0002\u0001\fA\u0002\u001b;uaB\u0013x\u000e^8d_2\u0004\"!\u00193\u000e\u0003\tT!a\u0019\u0003\u0002\u0011A\u0014x\u000e^8d_2L!!\u001a2\u0003\u0019!#H\u000f\u001d)s_R|7m\u001c7\t\u000b\u001d$\u0005\u0019\u00015\u0002\u0013QD'o\u001c;uY\u0016$\u0007CA\tj\u0013\tQ'CA\u0004C_>dW-\u00198\t\u000b1$\u0005\u0019A7\u0002\u001b\r|gNZ5hkJ\fG/[8o!\tq\u0017/D\u0001p\u0015\t\u0001\b)\u0001\u0004d_:4\u0017nZ\u0005\u0003e>\u0014AcR1uY&twmQ8oM&<WO]1uS>tg\u0001\u0002\b\u0003\u0001Q\u001c2a\u001d\t\u0017\u0011!18O!A!\u0002\u00139\u0018AD2pe\u0016\u001cu.\u001c9p]\u0016tGo\u001d\t\u0003qfl\u0011\u0001Q\u0005\u0003u\u0002\u0013abQ8sK\u000e{W\u000e]8oK:$8\u000f\u0003\u0005Xg\n\u0005\t\u0015!\u0003Y\u0011!y6O!A!\u0002\u0013\u0001\u0007\u0002\u0003@t\u0005\u0003\u0005\u000b\u0011B@\u0002\u001d!$H\u000f\u001d+y\u000bb,7-\u001e;peB!\u0011\u0011AA\u0006\u001b\t\t\u0019A\u0003\u0003\u0002\u0006\u0005\u001d\u0011A\u0001;y\u0015\r\tI\u0001B\u0001\u0007K:<\u0017N\\3\n\t\u00055\u00111\u0001\u0002\u000f\u0011R$\b\u000f\u0016=Fq\u0016\u001cW\u000f^8s\u0011\u0019\t3\u000f\"\u0001\u0002\u0012QQ\u00111CA\u000b\u0003/\tI\"a\u0007\u0011\u00051\u0019\bB\u0002<\u0002\u0010\u0001\u0007q\u000f\u0003\u0004X\u0003\u001f\u0001\r\u0001\u0017\u0005\u0007?\u0006=\u0001\u0019\u00011\t\ry\fy\u00011\u0001\u0000\u0011\u001d\tyb\u001dC\u0005\u0003C\t!#\u001b8gKJ\u0004\u0016mZ3SKN|WO]2fgRIq)a\t\u00022\u0005}\u0012\u0011\t\u0005\b\u0017\u0006u\u0001\u0019AA\u0013!\u0011\t9#!\f\u000e\u0005\u0005%\"bAA\u0016\t\u000511\r\\5f]RLA!a\f\u0002*\t9!+Z9vKN$\b\u0002CA\u001a\u0003;\u0001\r!!\u000e\u0002\u0011I,7\u000f]8og\u0016\u0004B!a\u000e\u0002<5\u0011\u0011\u0011\b\u0006\u0004\u0003g!\u0011\u0002BA\u001f\u0003s\u0011\u0001BU3ta>t7/\u001a\u0005\u0007!\u0006u\u0001\u0019A)\t\r\u001d\fi\u00021\u0001i\u0011\u001d\t)e\u001dC\u0001\u0003\u000f\n!bY:t\r\u0016$8\r[3e)59\u0015\u0011JA.\u0003k\nY)a$\u0002\u0012\"A\u00111JA\"\u0001\u0004\ti%A\u0002ve&\u0004B!a\u0014\u0002X5\u0011\u0011\u0011\u000b\u0006\u0005\u0003\u0017\n\u0019F\u0003\u0003\u0002V\u0005%\u0012aA1iG&!\u0011\u0011LA)\u0005\r)&/\u001b\u0005\t\u0003;\n\u0019\u00051\u0001\u0002`\u0005q!/Z:q_:\u001cXm\u0015;biV\u001c\b\u0003BA1\u0003cj!!a\u0019\u000b\u0007\u0015\t)G\u0003\u0003\u0002h\u0005%\u0014!B2pI\u0016\u001c'\u0002BA6\u0003[\nq\u0001[1oI2,'OC\u0002\u0002p!\tQA\\3uifLA!a\u001d\u0002d\t\u0011\u0002\n\u001e;q%\u0016\u001c\bo\u001c8tKN#\u0018\r^;t\u0011!\t9(a\u0011A\u0002\u0005e\u0014A\u00057bgRlu\u000eZ5gS\u0016$wJ]#uC\u001e\u0004B!\u0005\u001e\u0002|A!\u0011QPAC\u001d\u0011\ty(!!\u0011\u0005%\u0012\u0012bAAB%\u00051\u0001K]3eK\u001aLA!a\"\u0002\n\n11\u000b\u001e:j]\u001eT1!a!\u0013\u0011!\ti)a\u0011A\u0002\u0005m\u0014aB2p]R,g\u000e\u001e\u0005\u0007!\u0006\r\u0003\u0019A)\t\r\u001d\f\u0019\u00051\u0001i\u0011\u001d\t)j\u001dC\u0005\u0003/\u000baCY;jY\u0012,\u0005\u0010\u001d7jG&$(+Z:pkJ\u001cWm\u001d\u000b\u0006\u000f\u0006e\u00151\u0015\u0005\bm\u0005M\u0005\u0019AAN!\u00119s&!(\u0011\u0007%\u000by*C\u0002\u0002\"*\u0013a\u0002\u0013;uaJ+\u0017/^3ti\u0012+g\r\u0003\u0004Q\u0003'\u0003\r!\u0015\u0005\b\u0003O\u001bH\u0011BAU\u0003I\u0011Xm]8ve\u000e,\u0017iZ4sK\u001e\fGo\u001c:\u0015\r\u0005-\u00161WA^!\u0011\t\"(!,\u0011\u00071\ty+C\u0002\u00022\n\u0011!CU3t_V\u00148-Z!hOJ,w-\u0019;pe\"A\u0011QAAS\u0001\u0004\t)\f\u0005\u0003\u0002\u0002\u0005]\u0016\u0002BA]\u0003\u0007\u0011a\u0001\u0013;uaRC\bbBA_\u0003K\u0003\raR\u0001\u0012S:4WM\u001d:fIJ+7o\\;sG\u0016\u001c\bbBAag\u0012\u0005\u00111Y\u0001#]\u0016<(+Z:pkJ\u001cW-Q4he\u0016<\u0017\r^8s\r>\u00148)Y2iK\u0012\u0004\u0016mZ3\u0015\t\u0005-\u0016Q\u0019\u0005\t\u0003\u000b\ty\f1\u0001\u00026\"9\u0011\u0011Z:\u0005\u0002\u0005-\u0017a\t8foJ+7o\\;sG\u0016\fum\u001a:fO\u0006$xN\u001d$pe\u001a+Go\u00195fIB\u000bw-\u001a\u000b\t\u0003W\u000bi-a4\u0002R\"A\u00111GAd\u0001\u0004\t)\u0004\u0003\u0005\u0002\u0006\u0005\u001d\u0007\u0019AA[\u0011!\t\u0019.a2A\u0002\u0005U\u0017AB:uCR,8\u000f\u0005\u0003\u0002X\u0006\u0005XBAAm\u0015\u0011\tY.!8\u0002\u000bM$\u0018\r^:\u000b\u0007\u0005}g!A\u0004d_6lwN\\:\n\t\u0005\r\u0018\u0011\u001c\u0002\u0007'R\fG/^:")
public class ResourceFetcher
implements StrictLogging {
    private final CoreComponents coreComponents;
    private final HttpCaches httpCaches;
    private final HttpProtocol httpProtocol;
    private final HttpTxExecutor httpTxExecutor;
    private final Logger logger;

    public static List<HttpRequest> resourcesToRequests(List<ConcurrentResource> list, Session session, HttpCaches httpCaches, HttpProtocol httpProtocol, boolean bl, GatlingConfiguration gatlingConfiguration) {
        return ResourceFetcher$.MODULE$.resourcesToRequests(list, session, httpCaches, httpProtocol, bl, gatlingConfiguration);
    }

    public static List<ConcurrentResource> applyResourceFilters(List<ConcurrentResource> list, Option<Filters> option) {
        return ResourceFetcher$.MODULE$.applyResourceFilters(list, option);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private List<HttpRequest> inferPageResources(Request request, Response response, Session session, boolean throttled) {
        Nil$ nil$;
        Uri htmlDocumentUri = request.getUri();
        HttpResponseStatus httpResponseStatus = response.status();
        HttpResponseStatus httpResponseStatus2 = HttpResponseStatus.OK;
        HttpResponseStatus httpResponseStatus3 = httpResponseStatus;
        if (!(httpResponseStatus2 != null ? !httpResponseStatus2.equals(httpResponseStatus3) : httpResponseStatus3 != null)) {
            List<HttpRequest> list;
            Option<String> option = response.lastModifiedOrEtag(this.httpProtocol);
            if (option instanceof Some) {
                Some some = (Some)option;
                String newLastModifiedOrEtag = (String)some.value();
                list = this.httpCaches.computeInferredResourcesIfAbsent(this.httpProtocol, htmlDocumentUri, newLastModifiedOrEtag, (Function0<List<HttpRequest>>)(Function0 & Serializable & scala.Serializable)() -> this.inferredResourcesRequests$1(request, response, session, throttled, htmlDocumentUri));
            } else {
                list = this.inferredResourcesRequests$1(request, response, session, throttled, htmlDocumentUri);
            }
            nil$ = list;
        } else {
            HttpResponseStatus httpResponseStatus4 = HttpResponseStatus.NOT_MODIFIED;
            HttpResponseStatus httpResponseStatus5 = httpResponseStatus;
            if (!(httpResponseStatus4 != null ? !httpResponseStatus4.equals(httpResponseStatus5) : httpResponseStatus5 != null)) {
                Nil$ nil$2;
                InferredPageResources inferredPageResources = this.httpCaches.getCachedInferredResources(this.httpProtocol, htmlDocumentUri);
                if (inferredPageResources == null) {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn("Got a 304 for {} but could find cache entry?!", new Object[]{htmlDocumentUri});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    nil$2 = Nil$.MODULE$;
                } else {
                    nil$2 = inferredPageResources.requests();
                }
                nil$ = nil$2;
            } else {
                nil$ = Nil$.MODULE$;
            }
        }
        return nil$;
    }

    public List<HttpRequest> cssFetched(Uri uri, HttpResponseStatus responseStatus, Option<String> lastModifiedOrEtag, String content, Session session, boolean throttled) {
        Nil$ nil$;
        HttpResponseStatus httpResponseStatus = responseStatus;
        HttpResponseStatus httpResponseStatus2 = HttpResponseStatus.OK;
        HttpResponseStatus httpResponseStatus3 = httpResponseStatus;
        if (!(httpResponseStatus2 != null ? !httpResponseStatus2.equals(httpResponseStatus3) : httpResponseStatus3 != null)) {
            List<HttpRequest> list;
            Option<String> option = lastModifiedOrEtag;
            if (option instanceof Some) {
                Some some = (Some)option;
                String newLastModifiedOrEtag = (String)some.value();
                list = this.httpCaches.computeInferredResourcesIfAbsent(this.httpProtocol, uri, newLastModifiedOrEtag, (Function0<List<HttpRequest>>)(Function0 & Serializable & scala.Serializable)() -> {
                    $this.httpCaches.removeCssResources(uri);
                    return this.parseCssResources$1(uri, content, session, throttled);
                });
            } else {
                list = this.parseCssResources$1(uri, content, session, throttled);
            }
            nil$ = list;
        } else {
            HttpResponseStatus httpResponseStatus4 = HttpResponseStatus.NOT_MODIFIED;
            HttpResponseStatus httpResponseStatus5 = httpResponseStatus;
            if (!(httpResponseStatus4 != null ? !httpResponseStatus4.equals(httpResponseStatus5) : httpResponseStatus5 != null)) {
                Nil$ nil$2;
                InferredPageResources inferredPageResources = this.httpCaches.getCachedInferredResources(this.httpProtocol, uri);
                if (inferredPageResources == null) {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn("Got a 304 for {} but could find cache entry?!", new Object[]{uri});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    nil$2 = Nil$.MODULE$;
                } else {
                    nil$2 = inferredPageResources.requests();
                }
                nil$ = nil$2;
            } else {
                nil$ = Nil$.MODULE$;
            }
        }
        return nil$;
    }

    private List<HttpRequest> buildExplicitResources(List<HttpRequestDef> resources, Session session) {
        return (List)resources.flatMap((Function1 & Serializable & scala.Serializable)resource -> {
            Iterable iterable;
            Validation validation = (Validation)resource.requestName().apply((Object)session);
            if (validation instanceof Success) {
                Iterable iterable2;
                Success success = (Success)validation;
                String requestName = (String)success.value();
                Validation<HttpRequest> validation2 = resource.build(requestName, session);
                if (validation2 instanceof Success) {
                    Success success2 = (Success)validation2;
                    HttpRequest httpRequest = (HttpRequest)success2.value();
                    iterable2 = Option$.MODULE$.option2Iterable((Option)new Some((Object)httpRequest));
                } else if (validation2 instanceof Failure) {
                    Failure failure = (Failure)validation2;
                    String m = failure.message();
                    $this.coreComponents.statsEngine().reportUnbuildableRequest(session, requestName, m);
                    iterable2 = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                } else {
                    throw new MatchError(validation2);
                }
                iterable = iterable2;
            } else if (validation instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)validation;
                String m = failure.message();
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringBuilder(47).append("Could build request name for explicitResource: ").append(m).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            } else {
                throw new MatchError((Object)validation);
            }
            return iterable;
        }, List$.MODULE$.canBuildFrom());
    }

    private Option<ResourceAggregator> resourceAggregator(HttpTx tx, List<HttpRequest> inferredResources) {
        None$ none$;
        List<HttpRequest> list;
        List<HttpRequest> explicitResources = tx.request().requestConfig().explicitResources().nonEmpty() ? this.buildExplicitResources(tx.request().requestConfig().explicitResources(), tx.session()) : Nil$.MODULE$;
        List list2 = explicitResources.$colon$colon$colon(list = inferredResources);
        if (Nil$.MODULE$.equals(list2)) {
            none$ = None$.MODULE$;
        } else {
            List filteredResources;
            Tuple2 tuple2 = (Tuple2)list2.foldLeft((Object)new Tuple2((Object)Predef$.MODULE$.Set().empty(), (Object)List$.MODULE$.empty()), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2;
                Tuple2 tuple22 = new Tuple2(x0$1, x1$1);
                if (tuple22 == null) throw new MatchError((Object)tuple22);
                Tuple2 tuple23 = (Tuple2)tuple22._1();
                HttpRequest request = (HttpRequest)tuple22._2();
                if (tuple23 == null) throw new MatchError((Object)tuple22);
                Set urls = (Set)tuple23._1();
                List requests = (List)tuple23._2();
                String newUrl = request.clientRequest().getUri().toUrl();
                if (urls.contains((Object)newUrl)) {
                    tuple2 = new Tuple2((Object)urls, (Object)requests);
                    return tuple2;
                } else {
                    HttpRequest httpRequest = request;
                    Tuple2 tuple24 = new Tuple2((Object)urls.$plus((Object)newUrl), (Object)requests.$colon$colon((Object)httpRequest));
                    tuple2 = tuple24;
                }
                return tuple2;
            });
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            List list3 = filteredResources = (List)tuple2._2();
            List filteredResources2 = list3;
            none$ = new Some((Object)new DefaultResourceAggregator(tx, (Seq<HttpRequest>)filteredResources2.reverse(), this.httpCaches, this, this.httpTxExecutor, this.coreComponents.clock(), this.coreComponents.configuration()));
        }
        return none$;
    }

    public Option<ResourceAggregator> newResourceAggregatorForCachedPage(HttpTx tx) {
        InferredPageResources inferredPageResources = this.httpCaches.getCachedInferredResources(tx.request().requestConfig().httpProtocol(), tx.request().clientRequest().getUri());
        List<HttpRequest> list = inferredPageResources == null ? Nil$.MODULE$ : inferredPageResources.requests();
        List<HttpRequest> inferredResources = list;
        return this.resourceAggregator(tx, inferredResources);
    }

    public Option<ResourceAggregator> newResourceAggregatorForFetchedPage(Response response, HttpTx tx, Status status) {
        Option<ResourceAggregator> option;
        Status status2 = status;
        KO$ kO$ = KO$.MODULE$;
        if (!(status2 != null ? !status2.equals(kO$) : kO$ != null)) {
            option = None$.MODULE$;
        } else {
            List<HttpRequest> inferredResources = this.httpProtocol.responsePart().inferHtmlResources() && HttpHelper$.MODULE$.isHtml(response.headers()) ? this.inferPageResources(tx.request().clientRequest(), response, tx.session(), tx.request().requestConfig().throttled()) : Nil$.MODULE$;
            option = this.resourceAggregator(tx, inferredResources);
        }
        return option;
    }

    private final List inferredResourcesRequests$1(Request request$1, Response response$1, Session session$3, boolean throttled$3, Uri htmlDocumentUri$1) {
        List<ConcurrentResource> inferred = new HtmlParser().getEmbeddedResources(htmlDocumentUri$1, response$1.body().chars(), UserAgent$.MODULE$.getAgent(request$1));
        List<ConcurrentResource> filtered = ResourceFetcher$.MODULE$.applyResourceFilters(inferred, this.httpProtocol.responsePart().htmlResourcesInferringFilters());
        return ResourceFetcher$.MODULE$.resourcesToRequests(filtered, session$3, this.httpCaches, this.httpProtocol, throttled$3, this.coreComponents.configuration());
    }

    private final List parseCssResources$1(Uri uri$1, String content$1, Session session$1, boolean throttled$1) {
        Function1 & Serializable & scala.Serializable computer = (Function1 & Serializable & scala.Serializable)x$2 -> CssParser$.MODULE$.extractResources((Uri)x$2, content$1);
        List<ConcurrentResource> inferred = this.httpCaches.computeCssResourcesIfAbsent(uri$1, (Function1<Uri, List<ConcurrentResource>>)computer);
        List<ConcurrentResource> filtered = ResourceFetcher$.MODULE$.applyResourceFilters(inferred, this.httpProtocol.responsePart().htmlResourcesInferringFilters());
        return ResourceFetcher$.MODULE$.resourcesToRequests(filtered, session$1, this.httpCaches, this.httpProtocol, throttled$1, this.coreComponents.configuration());
    }

    public ResourceFetcher(CoreComponents coreComponents, HttpCaches httpCaches, HttpProtocol httpProtocol, HttpTxExecutor httpTxExecutor) {
        this.coreComponents = coreComponents;
        this.httpCaches = httpCaches;
        this.httpProtocol = httpProtocol;
        this.httpTxExecutor = httpTxExecutor;
        StrictLogging.$init$((StrictLogging)this);
    }
}

