/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.util;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.core.config.HttpConfiguration;
import io.gatling.http.util.SslContexts;
import io.gatling.http.util.SslContextsFactory$;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.DelegatingSslContext;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.Serializable;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManagerFactory;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005s!\u0002\f\u0018\u0011\u0003\u0001c!\u0002\u0012\u0018\u0011\u0003\u0019\u0003\"\u0002\u0016\u0002\t\u0003Y\u0003b\u0002\u0017\u0002\u0005\u0004%I!\f\u0005\u0007m\u0005\u0001\u000b\u0011\u0002\u0018\t\u000f]\n!\u0019!C\u0005q!1a)\u0001Q\u0001\neBqaR\u0001C\u0002\u0013%\u0001\n\u0003\u0004S\u0003\u0001\u0006I!\u0013\u0004\u0005E]\u00011\u000b\u0003\u0005_\u0013\t\u0005\t\u0015!\u0003`\u0011\u0015Q\u0013\u0002\"\u0001h\u0011\u001dQ\u0017B1A\u0005\n-Daa\\\u0005!\u0002\u0013a\u0007b\u00029\n\u0005\u0004%I!\u001d\u0005\u0007}&\u0001\u000b\u0011\u0002:\t\u0011}L!\u0019!C\u0005\u0003\u0003A\u0001\"!\u0004\nA\u0003%\u00111\u0001\u0005\n\u0003\u001fI!\u0019!C\u0005\u0003#A\u0001\"!\u0007\nA\u0003%\u00111\u0003\u0005\b\u00037IA\u0011AA\u000f\u0011\u001d\tI#\u0003C\u0005\u0003W\t!cU:m\u0007>tG/\u001a=ug\u001a\u000b7\r^8ss*\u0011\u0001$G\u0001\u0005kRLGN\u0003\u0002\u001b7\u0005!\u0001\u000e\u001e;q\u0015\taR$A\u0004hCRd\u0017N\\4\u000b\u0003y\t!![8\u0004\u0001A\u0011\u0011%A\u0007\u0002/\t\u00112k\u001d7D_:$X\r\u001f;t\r\u0006\u001cGo\u001c:z'\t\tA\u0005\u0005\u0002&Q5\taEC\u0001(\u0003\u0015\u00198-\u00197b\u0013\tIcE\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0001\na\u0003R3gCVdGoU:m'\u0016\u001cWO]3SC:$w.\\\u000b\u0002]A\u0011q\u0006N\u0007\u0002a)\u0011\u0011GM\u0001\tg\u0016\u001cWO]5us*\t1'\u0001\u0003kCZ\f\u0017BA\u001b1\u00051\u0019VmY;sKJ\u000bg\u000eZ8n\u0003]!UMZ1vYR\u001c6\u000f\\*fGV\u0014XMU1oI>l\u0007%\u0001\u000bEK\u001a\fW\u000f\u001c;UeV\u001cH/T1oC\u001e,'o]\u000b\u0002sA\u0019QE\u000f\u001f\n\u0005m2#!B!se\u0006L\bCA\u001fE\u001b\u0005q$BA A\u0003\r\u00198\u000f\u001c\u0006\u0003\u0003\n\u000b1A\\3u\u0015\u0005\u0019\u0015!\u00026bm\u0006D\u0018BA#?\u00051!&/^:u\u001b\u0006t\u0017mZ3s\u0003U!UMZ1vYR$&/^:u\u001b\u0006t\u0017mZ3sg\u0002\n1!\u00119o+\u0005I\u0005C\u0001&Q\u001b\u0005Y%BA M\u0015\tie*A\u0004iC:$G.\u001a:\u000b\u0005=k\u0012!\u00028fiRL\u0018BA)L\u0005e\t\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8Qe>$xnY8m\u0007>tg-[4\u0002\t\u0005\u0003h\u000eI\n\u0004\u0013\u0011\"\u0006CA+]\u001b\u00051&BA,Y\u00031\u00198-\u00197bY><w-\u001b8h\u0015\tI&,\u0001\u0005usB,7/\u00194f\u0015\u0005Y\u0016aA2p[&\u0011QL\u0016\u0002\u000e'R\u0014\u0018n\u0019;M_\u001e<\u0017N\\4\u0002\u0015!$H\u000f]\"p]\u001aLw\r\u0005\u0002aK6\t\u0011M\u0003\u0002cG\u000611m\u001c8gS\u001eT!\u0001Z\u000e\u0002\t\r|'/Z\u0005\u0003M\u0006\u0014\u0011\u0003\u0013;ua\u000e{gNZ5hkJ\fG/[8o)\tA\u0017\u000e\u0005\u0002\"\u0013!)al\u0003a\u0001?\u0006A2o\u001d7TKN\u001c\u0018n\u001c8US6,w.\u001e;TK\u000e|g\u000eZ:\u0016\u00031\u0004\"!J7\n\u000594#\u0001\u0002'p]\u001e\f\u0011d]:m'\u0016\u001c8/[8o)&lWm\\;u'\u0016\u001cwN\u001c3tA\u0005\u0001RM\\1cY\u0016$\u0007K]8u_\u000e|Gn]\u000b\u0002eB\u0019QEO:\u0011\u0005Q\\hBA;z!\t1h%D\u0001x\u0015\tAx$\u0001\u0004=e>|GOP\u0005\u0003u\u001a\na\u0001\u0015:fI\u00164\u0017B\u0001?~\u0005\u0019\u0019FO]5oO*\u0011!PJ\u0001\u0012K:\f'\r\\3e!J|Go\\2pYN\u0004\u0013aE3oC\ndW\rZ\"ja\",'oU;ji\u0016\u001cXCAA\u0002!\u0015\t)!!\u0003t\u001b\t\t9A\u0003\u0002\u0019e%!\u00111BA\u0004\u0005\u0011a\u0015n\u001d;\u0002)\u0015t\u0017M\u00197fI\u000eK\u0007\u000f[3s'VLG/Z:!\u0003))8/Z(qK:\u001c6\u000f\\\u000b\u0003\u0003'\u00012!JA\u000b\u0013\r\t9B\n\u0002\b\u0005>|G.Z1o\u0003-)8/Z(qK:\u001c6\u000f\u001c\u0011\u0002\u001d9,woU:m\u0007>tG/\u001a=ugR!\u0011qDA\u0013!\r\t\u0013\u0011E\u0005\u0004\u0003G9\"aC*tY\u000e{g\u000e^3yiNDq!a\n\u0015\u0001\u0004\t\u0019\"\u0001\u0007iiR\u0004('\u00128bE2,G-A\u0007oK^\u001c6\u000f\\\"p]R,\u0007\u0010\u001e\u000b\u0007\u0003[\t\u0019$!\u0010\u0011\u0007)\u000by#C\u0002\u00022-\u0013!bU:m\u0007>tG/\u001a=u\u0011\u001d\t)$\u0006a\u0001\u0003o\tQB\u001b3l'Nd7i\u001c8uKb$\bcA\u001f\u0002:%\u0019\u00111\b \u0003\u0015M\u001bFjQ8oi\u0016DH\u000f\u0003\u0004\u0002@U\u0001\r!S\u0001\u0004CBt\u0007")
public class SslContextsFactory
implements StrictLogging {
    private final HttpConfiguration httpConfig;
    private final long sslSessionTimeoutSeconds;
    private final String[] io$gatling$http$util$SslContextsFactory$$enabledProtocols;
    private final List<String> io$gatling$http$util$SslContextsFactory$$enabledCipherSuites;
    private final boolean useOpenSsl;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private long sslSessionTimeoutSeconds() {
        return this.sslSessionTimeoutSeconds;
    }

    public String[] io$gatling$http$util$SslContextsFactory$$enabledProtocols() {
        return this.io$gatling$http$util$SslContextsFactory$$enabledProtocols;
    }

    public List<String> io$gatling$http$util$SslContextsFactory$$enabledCipherSuites() {
        return this.io$gatling$http$util$SslContextsFactory$$enabledCipherSuites;
    }

    private boolean useOpenSsl() {
        return this.useOpenSsl;
    }

    public SslContexts newSslContexts(boolean http2Enabled) {
        SslContexts sslContexts;
        if (this.useOpenSsl()) {
            BoxedUnit boxedUnit;
            SslContextBuilder sslContextBuilder = SslContextBuilder.forClient().sslProvider(SslProvider.OPENSSL);
            Object object = this.httpConfig.advanced().sslSessionCacheSize() > 0 ? sslContextBuilder.sessionCacheSize((long)this.httpConfig.advanced().sslSessionCacheSize()) : BoxedUnit.UNIT;
            Object object2 = this.httpConfig.advanced().sslSessionTimeout().$greater((Object)Duration$.MODULE$.Zero()) ? sslContextBuilder.sessionTimeout(this.sslSessionTimeoutSeconds()) : BoxedUnit.UNIT;
            Object object3 = this.io$gatling$http$util$SslContextsFactory$$enabledProtocols().length > 0 ? sslContextBuilder.protocols(this.io$gatling$http$util$SslContextsFactory$$enabledProtocols()) : BoxedUnit.UNIT;
            SslContextBuilder sslContextBuilder2 = this.httpConfig.advanced().sslEnabledCipherSuites().nonEmpty() ? sslContextBuilder.ciphers(this.io$gatling$http$util$SslContextsFactory$$enabledCipherSuites()) : sslContextBuilder.ciphers(null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE_DEFAULTING_TO_SUPPORTED_CIPHERS);
            this.httpConfig.ssl().keyManagerFactory().foreach((Function1 & Serializable & scala.Serializable)x$1 -> sslContextBuilder.keyManager(x$1));
            Option option = this.httpConfig.ssl().trustManagerFactory();
            if (option instanceof Some) {
                Some some = (Some)option;
                TrustManagerFactory tmf = (TrustManagerFactory)some.value();
                boxedUnit = sslContextBuilder.trustManager(tmf);
            } else {
                boxedUnit = this.httpConfig.advanced().useInsecureTrustManager() ? sslContextBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE) : BoxedUnit.UNIT;
            }
            SslContext sslContext = sslContextBuilder.build();
            None$ alpnSslContext = http2Enabled ? new Some((Object)sslContextBuilder.applicationProtocolConfig(SslContextsFactory$.MODULE$.io$gatling$http$util$SslContextsFactory$$Apn()).build()) : None$.MODULE$;
            sslContexts = new SslContexts(sslContext, (Option<SslContext>)alpnSslContext);
        } else {
            SSLContext jdkSslContext = SSLContext.getInstance("TLS");
            jdkSslContext.init((KeyManager[])this.httpConfig.ssl().keyManagerFactory().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getKeyManagers()).orNull(Predef$.MODULE$.$conforms()), SslContextsFactory$.MODULE$.io$gatling$http$util$SslContextsFactory$$DefaultTrustManagers(), SslContextsFactory$.MODULE$.io$gatling$http$util$SslContextsFactory$$DefaultSslSecureRandom());
            SslContext sslContext = this.newSslContext(jdkSslContext, null);
            None$ alpnSslContext = http2Enabled ? new Some((Object)this.newSslContext(jdkSslContext, SslContextsFactory$.MODULE$.io$gatling$http$util$SslContextsFactory$$Apn())) : None$.MODULE$;
            sslContexts = new SslContexts(sslContext, (Option<SslContext>)alpnSslContext);
        }
        return sslContexts;
    }

    private SslContext newSslContext(SSLContext jdkSslContext, ApplicationProtocolConfig apn) {
        return new DelegatingSslContext(this, jdkSslContext, apn){
            private final /* synthetic */ SslContextsFactory $outer;

            public void initEngine(SSLEngine engine) {
                block0: {
                    if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.$outer.io$gatling$http$util$SslContextsFactory$$enabledProtocols())).nonEmpty()) break block0;
                    engine.setEnabledProtocols(this.$outer.io$gatling$http$util$SslContextsFactory$$enabledProtocols());
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super((SslContext)new JdkSslContext(jdkSslContext$1, true, $outer.io$gatling$http$util$SslContextsFactory$$enabledCipherSuites().isEmpty() ? null : $outer.io$gatling$http$util$SslContextsFactory$$enabledCipherSuites(), (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE_DEFAULTING_TO_SUPPORTED_CIPHERS, apn$1, ClientAuth.NONE, null, false));
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public SslContextsFactory(HttpConfiguration httpConfig) {
        boolean bl;
        this.httpConfig = httpConfig;
        StrictLogging.$init$((StrictLogging)this);
        this.sslSessionTimeoutSeconds = httpConfig.advanced().sslSessionTimeout().toSeconds();
        this.io$gatling$http$util$SslContextsFactory$$enabledProtocols = (String[])httpConfig.advanced().sslEnabledProtocols().toArray(ClassTag$.MODULE$.apply(String.class));
        this.io$gatling$http$util$SslContextsFactory$$enabledCipherSuites = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)httpConfig.advanced().sslEnabledCipherSuites()).asJava();
        if (httpConfig.advanced().useOpenSsl()) {
            void var2_2;
            BoxedUnit boxedUnit;
            boolean available = OpenSsl.isAvailable();
            if (!available) {
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("OpenSSL is enabled in the Gatling configuration but it's not available on your architecture.");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            bl = var2_2;
        } else {
            bl = false;
        }
        this.useOpenSsl = bl;
    }
}

