/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.dialect.springdata;

import java.util.Collections;
import java.util.Map;
import org.springframework.data.domain.Page;
import org.thymeleaf.Arguments;
import org.thymeleaf.Configuration;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.dialect.springdata.exception.InvalidObjectParameterException;
import org.thymeleaf.dialect.springdata.util.ProcessorUtils;
import org.thymeleaf.dom.Element;
import org.thymeleaf.processor.ProcessorResult;
import org.thymeleaf.processor.attr.AbstractAttrProcessor;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.standard.expression.IStandardExpressionParser;
import org.thymeleaf.standard.expression.StandardExpressions;

final class PageObjectAttrProcessor
extends AbstractAttrProcessor {
    private static final String ATTR_NAME = "page-object";

    protected PageObjectAttrProcessor() {
        super(ATTR_NAME);
    }

    protected ProcessorResult processAttribute(Arguments arguments, Element element, String attrName) {
        Configuration configuration = arguments.getConfiguration();
        IStandardExpressionParser parser = StandardExpressions.getExpressionParser((Configuration)configuration);
        String attributeValue = element.getAttributeValue(attrName);
        IStandardExpression expression = parser.parseExpression(configuration, (IProcessingContext)arguments, attributeValue);
        ProcessorUtils.removeAttribute(element, ATTR_NAME);
        Object page = expression.execute(configuration, (IProcessingContext)arguments);
        if (page == null || !(page instanceof Page)) {
            throw new InvalidObjectParameterException("No Page<?> object found with page-object parameter: " + attributeValue);
        }
        Map<String, Object> vars = Collections.singletonMap("_sd_.page.object", page);
        return ProcessorResult.setLocalVariables(vars);
    }

    public int getPrecedence() {
        return 900;
    }
}

