/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.dialect.springdata;

import org.thymeleaf.Arguments;
import org.thymeleaf.dialect.springdata.decorator.PaginationDecorator;
import org.thymeleaf.dialect.springdata.decorator.PaginationDecoratorRegistry;
import org.thymeleaf.dialect.springdata.util.ProcessorUtils;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.Node;
import org.thymeleaf.dom.Text;
import org.thymeleaf.processor.ProcessorResult;
import org.thymeleaf.processor.attr.AbstractAttrProcessor;

final class PaginationAttrProcessor
extends AbstractAttrProcessor {
    private static final String ATTR_NAME = "pagination";

    protected PaginationAttrProcessor() {
        super(ATTR_NAME);
    }

    protected ProcessorResult processAttribute(Arguments arguments, Element element, String attrName) {
        String attributeValue = element.getAttributeValue(attrName);
        ProcessorUtils.removeAttribute(element, ATTR_NAME);
        element.clearChildren();
        PaginationDecorator decorator = PaginationDecoratorRegistry.getInstance().getDecorator(attributeValue);
        String content = decorator.decorate(element, arguments);
        Text newNode = new Text("");
        newNode.setContent(content, true);
        String elementName = element.getNormalizedName();
        boolean isUl = "ul".equals(elementName);
        if (isUl) {
            element.getParent().addChild((Node)newNode);
            element.getParent().removeChild((Node)element);
        } else {
            element.addChild((Node)newNode);
        }
        return ProcessorResult.ok();
    }

    public int getPrecedence() {
        return 1000;
    }
}

