/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.dialect.springdata;

import java.util.HashMap;
import java.util.Map;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.thymeleaf.Arguments;
import org.thymeleaf.dialect.springdata.util.PageUtils;
import org.thymeleaf.dialect.springdata.util.ProcessorUtils;
import org.thymeleaf.dom.Element;
import org.thymeleaf.processor.attr.AbstractAttributeModifierAttrProcessor;

class PaginationSortAttrProcessor
extends AbstractAttributeModifierAttrProcessor {
    private static final String ATTR_NAME = "pagination-sort";

    protected PaginationSortAttrProcessor() {
        super(ATTR_NAME);
    }

    protected Map<String, String> getModifiedAttributeValues(Arguments arguments, Element element, String attributeName) {
        String attributeValue = element.getAttributeValue(attributeName);
        Page<?> page = PageUtils.findPage(arguments);
        String url = PageUtils.createSortUrl(arguments, attributeValue);
        ProcessorUtils.removeAttribute(element, ATTR_NAME);
        Sort sort = page.getSort();
        boolean isSorted = sort != null && sort.getOrderFor(attributeValue) != null;
        String clas = isSorted ? "sorted-".concat(sort.getOrderFor(attributeValue).getDirection().toString().toLowerCase()) : "";
        HashMap<String, String> modifiedAttributes = new HashMap<String, String>();
        modifiedAttributes.put("href", url);
        modifiedAttributes.put("class", clas);
        return modifiedAttributes;
    }

    protected AbstractAttributeModifierAttrProcessor.ModificationType getModificationType(Arguments arguments, Element element, String attributeName, String newAttributeName) {
        return "class".equals(newAttributeName) ? AbstractAttributeModifierAttrProcessor.ModificationType.APPEND_WITH_SPACE : AbstractAttributeModifierAttrProcessor.ModificationType.SUBSTITUTION;
    }

    protected boolean removeAttributeIfEmpty(Arguments arguments, Element element, String attributeName, String newAttributeName) {
        return true;
    }

    protected boolean recomputeProcessorsAfterExecution(Arguments arguments, Element element, String attributeName) {
        return false;
    }

    public int getPrecedence() {
        return 1000;
    }
}

