/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.dialect.springdata;

import java.util.Collections;
import java.util.Map;
import org.thymeleaf.Arguments;
import org.thymeleaf.Configuration;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.dialect.springdata.util.ProcessorUtils;
import org.thymeleaf.dom.Element;
import org.thymeleaf.processor.ProcessorResult;
import org.thymeleaf.processor.attr.AbstractAttrProcessor;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.standard.expression.IStandardExpressionParser;
import org.thymeleaf.standard.expression.StandardExpressions;

final class PaginationSplitAttrProcessor
extends AbstractAttrProcessor {
    private static final String ATTR_NAME = "pagination-split";

    protected PaginationSplitAttrProcessor() {
        super(ATTR_NAME);
    }

    protected ProcessorResult processAttribute(Arguments arguments, Element element, String attrName) {
        Configuration configuration = arguments.getConfiguration();
        IStandardExpressionParser parser = StandardExpressions.getExpressionParser((Configuration)configuration);
        String attributeValue = element.getAttributeValue(attrName);
        IStandardExpression expression = parser.parseExpression(configuration, (IProcessingContext)arguments, attributeValue);
        ProcessorUtils.removeAttribute(element, ATTR_NAME);
        Number split = (Number)expression.execute(configuration, (IProcessingContext)arguments);
        Map<String, Integer> vars = Collections.singletonMap("_sd_.pagination.split", split.intValue());
        return ProcessorResult.setLocalVariables(vars);
    }

    public int getPrecedence() {
        return 900;
    }
}

