/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.dialect.springdata.decorator;

import java.util.Locale;
import org.springframework.data.domain.Page;
import org.thymeleaf.Arguments;
import org.thymeleaf.dialect.springdata.decorator.PaginationDecorator;
import org.thymeleaf.dialect.springdata.util.Messages;
import org.thymeleaf.dialect.springdata.util.PageUtils;
import org.thymeleaf.dialect.springdata.util.Strings;
import org.thymeleaf.dom.Element;

abstract class AbstractPagerDecorator
implements PaginationDecorator {
    AbstractPagerDecorator() {
    }

    @Override
    public final String decorate(Element element, Arguments arguments) {
        String bundleName = this.getClass().getSimpleName();
        Locale locale = arguments.getContext().getLocale();
        Page<?> page = PageUtils.findPage(arguments);
        boolean isFirstPage = page.getNumber() == 0;
        String previousPage = PageUtils.createPageUrl(arguments, page.getNumber() - 1);
        String prevKey = isFirstPage ? "pager.previous" : "pager.previous.link";
        String prev = Messages.getMessage(bundleName, prevKey, locale, previousPage);
        boolean isLatestPage = page.getNumber() == page.getTotalPages() - 1;
        String nextPage = PageUtils.createPageUrl(arguments, page.getNumber() + 1);
        String nextKey = isLatestPage ? "pager.next" : "pager.next.link";
        String next = Messages.getMessage(bundleName, nextKey, locale, nextPage);
        String content = Strings.concat(prev, next);
        return Messages.getMessage(bundleName, "pager", locale, content);
    }
}

