/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.dialect.springdata.decorator;

import java.util.Locale;
import org.springframework.data.domain.Page;
import org.thymeleaf.Arguments;
import org.thymeleaf.dialect.springdata.decorator.PaginationDecorator;
import org.thymeleaf.dialect.springdata.util.Messages;
import org.thymeleaf.dialect.springdata.util.PageUtils;
import org.thymeleaf.dialect.springdata.util.Strings;
import org.thymeleaf.dom.Element;

public final class FullPaginationDecorator
implements PaginationDecorator {
    private static final String DEFAULT_CLASS = "pagination";
    private static final String BUNDLE_NAME = FullPaginationDecorator.class.getSimpleName();
    private static final int DEFAULT_PAGE_SPLIT = 7;

    @Override
    public String getIdentifier() {
        return "full";
    }

    @Override
    public final String decorate(Element element, Arguments arguments) {
        Page<?> page = PageUtils.findPage(arguments);
        String firstPage = PageUtils.createPageUrl(arguments, 0);
        boolean isFirstPage = page.getNumber() == 0;
        Locale locale = arguments.getContext().getLocale();
        String laquo = isFirstPage ? this.getLaquo(locale) : this.getLaquo(firstPage, locale);
        String previous = this.getPreviousPageLink(page, arguments);
        String pageLinks = this.createPageLinks(page, arguments);
        String next = this.getNextPageLink(page, arguments);
        boolean isLastPage = page.getTotalPages() == 0 || page.getNumber() == page.getTotalPages() - 1;
        String lastPage = PageUtils.createPageUrl(arguments, page.getTotalPages() - 1);
        String raquo = isLastPage ? this.getRaquo(locale) : this.getRaquo(lastPage, locale);
        boolean isUl = "ul".equals(element.getNormalizedName());
        String currentClass = element.getAttributeValue("class");
        String clas = isUl && !Strings.isEmpty(currentClass) ? currentClass : DEFAULT_CLASS;
        return Messages.getMessage(BUNDLE_NAME, DEFAULT_CLASS, locale, clas, laquo, previous, pageLinks, next, raquo);
    }

    private String createPageLinks(Page<?> page, Arguments arguments) {
        int pageSplit = 7;
        if (arguments.hasLocalVariable("_sd_.pagination.split")) {
            pageSplit = (Integer)arguments.getLocalVariable("_sd_.pagination.split");
        }
        int firstPage = 0;
        int latestPage = page.getTotalPages();
        int currentPage = page.getNumber();
        if (latestPage >= pageSplit) {
            int pageDiff = latestPage - currentPage;
            if (currentPage == 0) {
                latestPage = pageSplit;
            } else if (pageDiff < pageSplit) {
                firstPage = currentPage - (pageSplit - pageDiff);
            } else {
                firstPage = currentPage - 1;
                latestPage = currentPage + pageSplit - 1;
            }
        }
        StringBuilder builder = new StringBuilder();
        for (int i = firstPage; i < latestPage; ++i) {
            int pageNumber = i + 1;
            String link = PageUtils.createPageUrl(arguments, i);
            boolean isCurrentPage = i == currentPage;
            Locale locale = arguments.getContext().getLocale();
            String li = isCurrentPage ? this.getLink(pageNumber, locale) : this.getLink(pageNumber, link, locale);
            builder.append(li);
        }
        return builder.toString();
    }

    private String getLaquo(Locale locale) {
        return Messages.getMessage(BUNDLE_NAME, "laquo", locale);
    }

    private String getLaquo(String firstPage, Locale locale) {
        return Messages.getMessage(BUNDLE_NAME, "laquo.link", locale, firstPage);
    }

    private String getRaquo(Locale locale) {
        return Messages.getMessage(BUNDLE_NAME, "raquo", locale);
    }

    private String getRaquo(String lastPage, Locale locale) {
        return Messages.getMessage(BUNDLE_NAME, "raquo.link", locale, lastPage);
    }

    private String getLink(int pageNumber, Locale locale) {
        return Messages.getMessage(BUNDLE_NAME, "link.active", locale, pageNumber);
    }

    private String getLink(int pageNumber, String url, Locale locale) {
        return Messages.getMessage(BUNDLE_NAME, "link", locale, url, pageNumber);
    }

    private String getPreviousPageLink(Page<?> page, Arguments arguments) {
        int previousPage = page.getNumber() - 1;
        String msgKey = previousPage < 0 ? "previous.page" : "previous.page.link";
        Locale locale = arguments.getContext().getLocale();
        String link = PageUtils.createPageUrl(arguments, previousPage);
        return Messages.getMessage(BUNDLE_NAME, msgKey, locale, link);
    }

    private String getNextPageLink(Page<?> page, Arguments arguments) {
        int totalPages;
        int nextPage = page.getNumber() + 1;
        String msgKey = nextPage == (totalPages = page.getTotalPages()) ? "next.page" : "next.page.link";
        Locale locale = arguments.getContext().getLocale();
        String link = PageUtils.createPageUrl(arguments, nextPage);
        return Messages.getMessage(BUNDLE_NAME, msgKey, locale, link);
    }
}

