/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.dialect.springdata.decorator;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.thymeleaf.dialect.springdata.decorator.PaginationDecorator;
import org.thymeleaf.dialect.springdata.exception.PaginationDecoratorNotFoundException;

public final class PaginationDecoratorRegistry {
    private static PaginationDecoratorRegistry instance;
    private final Map<String, PaginationDecorator> availableDecorators;

    private PaginationDecoratorRegistry() {
        ServiceLoader<PaginationDecorator> loader = ServiceLoader.load(PaginationDecorator.class);
        this.availableDecorators = new HashMap<String, PaginationDecorator>();
        for (PaginationDecorator decorator : loader) {
            this.availableDecorators.put(decorator.getIdentifier(), decorator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PaginationDecoratorRegistry getInstance() {
        if (instance != null) return instance;
        Class<PaginationDecoratorRegistry> clazz = PaginationDecoratorRegistry.class;
        synchronized (PaginationDecoratorRegistry.class) {
            if (instance != null) return instance;
            instance = new PaginationDecoratorRegistry();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public PaginationDecorator getDecorator(String identifier) throws PaginationDecoratorNotFoundException {
        if (!this.availableDecorators.containsKey(identifier)) {
            throw new PaginationDecoratorNotFoundException("Pagination decorator with identifier: " + identifier + " not found!");
        }
        return this.availableDecorators.get(identifier);
    }
}

