/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.dialect.springdata.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.thymeleaf.Arguments;
import org.thymeleaf.Configuration;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.context.IWebContext;
import org.thymeleaf.dialect.springdata.exception.InvalidObjectParameterException;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.standard.expression.IStandardExpressionParser;
import org.thymeleaf.standard.expression.StandardExpressions;

public final class PageUtils {
    private PageUtils() {
    }

    public static int getFirstItemInPage(Page<?> page) {
        return page.getSize() * page.getNumber() + 1;
    }

    public static int getLatestItemInPage(Page<?> page) {
        return page.getSize() * page.getNumber() + page.getNumberOfElements();
    }

    public static Page<?> findPage(Arguments arguments) {
        Object pageFromLocalVariables = arguments.getLocalVariable("_sd_.page.object");
        if (PageUtils.isPageInstance(pageFromLocalVariables)) {
            return (Page)pageFromLocalVariables;
        }
        Configuration configuration = arguments.getConfiguration();
        IStandardExpressionParser parser = StandardExpressions.getExpressionParser((Configuration)configuration);
        IStandardExpression expression = parser.parseExpression(configuration, (IProcessingContext)arguments, "${page}");
        Object page = expression.execute(configuration, (IProcessingContext)arguments);
        if (PageUtils.isPageInstance(page)) {
            return (Page)page;
        }
        IContext context = arguments.getContext();
        if (context instanceof IWebContext) {
            HttpServletRequest request = ((IWebContext)context).getHttpServletRequest();
            Enumeration attrNames = request.getAttributeNames();
            Page pageOnRequest = null;
            while (attrNames.hasMoreElements()) {
                String attrName = (String)attrNames.nextElement();
                Object attr = request.getAttribute(attrName);
                if (!PageUtils.isPageInstance(attr)) continue;
                if (pageOnRequest != null) {
                    throw new InvalidObjectParameterException("More than one Page object found on request!");
                }
                pageOnRequest = (Page)attr;
            }
            if (pageOnRequest != null) {
                return pageOnRequest;
            }
        }
        throw new InvalidObjectParameterException("Invalid or not present Page object found on request!");
    }

    public static String createPageUrl(Arguments arguments, int pageNumber) {
        String prefix = PageUtils.getParamPrefix(arguments);
        List<String> excludedParams = Arrays.asList(prefix.concat("page"));
        String baseUrl = PageUtils.buildBaseUrl(arguments, excludedParams);
        return PageUtils.buildUrl(baseUrl, arguments).append("page").append("=").append(pageNumber).toString();
    }

    public static String createSortUrl(Arguments arguments, String fieldName) {
        boolean hasPreviousOrder;
        String prefix = PageUtils.getParamPrefix(arguments);
        List<String> excludedParams = Arrays.asList(prefix.concat("sort"), prefix.concat("page"));
        String baseUrl = PageUtils.buildBaseUrl(arguments, excludedParams);
        StringBuilder sortParam = new StringBuilder();
        Page<?> page = PageUtils.findPage(arguments);
        Sort sort = page.getSort();
        boolean bl = hasPreviousOrder = sort != null && sort.getOrderFor(fieldName) != null;
        if (hasPreviousOrder) {
            Sort.Order previousOrder = sort.getOrderFor(fieldName);
            Sort.Direction dir = previousOrder.isAscending() ? Sort.Direction.DESC : Sort.Direction.ASC;
            sortParam.append(fieldName).append(",").append(dir.toString().toLowerCase());
        } else {
            sortParam.append(fieldName);
        }
        return PageUtils.buildUrl(baseUrl, arguments).append("sort").append("=").append((CharSequence)sortParam).toString();
    }

    private static String buildBaseUrl(Arguments arguments, Collection<String> excludeParams) {
        String url = (String)arguments.getLocalVariable("_sd_.pagination.url");
        IContext context = arguments.getContext();
        if (url == null && context instanceof IWebContext) {
            StringBuilder builder = new StringBuilder();
            IWebContext webContext = (IWebContext)context;
            HttpServletRequest request = webContext.getHttpServletRequest();
            builder.append(request.getRequestURI());
            Map params = request.getParameterMap();
            Set entries = params.entrySet();
            boolean firstParam = true;
            for (Map.Entry param : entries) {
                String name = (String)param.getKey();
                if (excludeParams.contains(name)) continue;
                if (firstParam) {
                    builder.append("?");
                    firstParam = false;
                } else {
                    builder.append("&");
                }
                String[] values = (String[])param.getValue();
                List<String> paramValues = Arrays.asList(values);
                Iterator it = paramValues.iterator();
                while (it.hasNext()) {
                    String value = (String)it.next();
                    builder.append(name).append("=").append(value);
                    if (!it.hasNext()) continue;
                    builder.append("&");
                }
            }
            return builder.toString();
        }
        return url == null ? "" : url;
    }

    private static boolean isPageInstance(Object page) {
        return page != null && page instanceof Page;
    }

    private static StringBuilder buildUrl(String baseUrl, Arguments arguments) {
        String paramAppender = String.valueOf(baseUrl).contains("?") ? "&" : "?";
        String prefix = PageUtils.getParamPrefix(arguments);
        return new StringBuilder(baseUrl).append(paramAppender).append(prefix);
    }

    private static String getParamPrefix(Arguments arguments) {
        String prefix = (String)arguments.getLocalVariable("_sd_.pagination.qualifier.prefix");
        return prefix == null ? "" : prefix.concat("_");
    }
}

