/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc.security;

import io.grpc.CallCredentials;
import io.grpc.Metadata;
import io.grpc.Status;
import java.util.concurrent.Executor;
import org.lognet.springboot.grpc.security.AuthHeader;

public class AuthCallCredentials
extends CallCredentials {
    private AuthHeader authHeader;

    public AuthCallCredentials(AuthHeader.AuthHeaderBuilder authHeaderBuilder) {
        this(authHeaderBuilder.build());
    }

    public AuthCallCredentials(AuthHeader authHeader) {
        this.authHeader = authHeader;
    }

    public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor appExecutor, CallCredentials.MetadataApplier metadataApplier) {
        appExecutor.execute(() -> {
            try {
                metadataApplier.apply(this.authHeader.attach(new Metadata()));
            }
            catch (Throwable e) {
                metadataApplier.fail(Status.UNAUTHENTICATED.withCause(e));
            }
        });
    }

    public void thisUsesUnstableApi() {
    }
}

