/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc.security;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import org.lognet.springboot.grpc.security.AuthHeader;

public class AuthClientInterceptor
implements ClientInterceptor {
    private AuthHeader authHeader;

    public AuthClientInterceptor(AuthHeader authHeader) {
        this.authHeader = authHeader;
    }

    public AuthClientInterceptor(AuthHeader.AuthHeaderBuilder authHeaderBuilder) {
        this(authHeaderBuilder.build());
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions, Channel next) {
        return new ClientInterceptors.CheckedForwardingClientCall<ReqT, RespT>(next.newCall(methodDescriptor, callOptions)){

            protected void checkedStart(ClientCall.Listener<RespT> responseListener, Metadata headers) throws Exception {
                this.delegate().start(responseListener, AuthClientInterceptor.this.authHeader.attach(headers));
            }
        };
    }
}

