/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc.security.jwt;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationProvider;
import org.springframework.util.Assert;

public class JwtAuthProviderFactory {
    public static JwtAuthenticationProvider forRoles(JwtDecoder jwtDecoder) {
        JwtAuthenticationConverter authenticationConverter = new JwtAuthenticationConverter();
        authenticationConverter.setJwtGrantedAuthoritiesConverter(jwt -> {
            String claim = Optional.ofNullable(jwt.getClaimAsString("aud")).orElse(jwt.getClaimAsString("azp"));
            Assert.hasText((String)claim, (String)"Neither 'aud' nor 'azp' claims exist");
            Map resource_access = jwt.getClaimAsMap("resource_access");
            Object roles = ((Map)resource_access.get(claim)).get("roles");
            List rolesList = (List)roles;
            return IntStream.range(0, rolesList.size()).mapToObj(k -> new SimpleGrantedAuthority("ROLE_" + (String)rolesList.get(k))).collect(Collectors.toList());
        });
        JwtAuthenticationProvider authenticationProvider = new JwtAuthenticationProvider(jwtDecoder);
        authenticationProvider.setJwtAuthenticationConverter((Converter)authenticationConverter);
        return authenticationProvider;
    }

    public static JwtAuthenticationProvider forAuthorities(JwtDecoder jwtDecoder) {
        return new JwtAuthenticationProvider(jwtDecoder);
    }
}

